package com.ups.xmlsdk.xpci;

/**
 * The Shipment Class is to be used as a data container.  The instance variables available
 * in the Shipment Class are those provided by the XPCI for package activity.
 */
public class Shipment implements java.io.Serializable
{
	private Agent shipper;
	private Agent shipTo;
	private Agent shipFrom;
	private java.lang.String description;
	private java.lang.String deliveryZone;
	private java.lang.String pickupDate;
	private java.lang.String scheduledDeliveryDate;
	private java.lang.String scheduledDeliveryTime;
	private java.lang.String alternateDeliveryDate;
	private java.lang.String alternateDeliveryTime;
	private java.lang.String serviceCode;
	private java.lang.String serviceDescription;
	private java.lang.String shipmentWeight;
	private java.lang.String shipmentWeightCode;
	private java.lang.String shipmentWeightDescription;
	private java.lang.String shipmentID;
	private java.lang.String invoiceCurrencyCode;
	private java.lang.String invoiceMonetaryValue;
	private boolean documents;
	private java.util.Vector referenceNumbers;
	private java.lang.Object paymentInfo;
	private ShipmentServiceOptions shipmentServiceOptions;
	private java.util.Vector packages;
	private HandlingCharge handlingCharge;
/**
 * Shipment constructor.
 */
public Shipment()
{
	super();
	packages = new java.util.Vector();
	referenceNumbers = new java.util.Vector();
}
/**
 * Returns the instance variable value for Shipment Alternate Delivery Date
 * @return java.lang.String
 */
public java.lang.String getAlternateDeliveryDate()
{
	return alternateDeliveryDate;
}
/**
 * Returns the instance variable value for Shipment Alternate Delivery Time
 * @return java.lang.String
 */
public java.lang.String getAlternateDeliveryTime()
{
	return alternateDeliveryTime;
}
/**
 * Returns the instance variable value for Shipment Delivery Zone
 * @return java.lang.String
 */
public java.lang.String getDeliveryZone()
{
	return deliveryZone;
}
/**
 * Returns the instance variable value for Shipment Description
 * @return java.lang.String
 */
public java.lang.String getDescription()
{
	return description;
}
/**
 * Returns the instance variable value for Shipment Documents Indicator
 * @return boolean
 */
public boolean getDocuments()
{
	return documents;
}
/**
 * Returns the instance variable value for Shipment Handling Charge
 * @return com.ups.xml.beans.HandlingCharge
 */
public HandlingCharge getHandlingCharge()
{
	return handlingCharge;
}
/**
 * Returns the instance variable value for Shipment Invoice Currency Code
 * @return java.lang.String
 */
public java.lang.String getInvoiceCurrencyCode()
{
	return invoiceCurrencyCode;
}
/**
 * Returns the instance variable value for Shipment Invoice Monetary Value
 * @return java.lang.String
 */
public java.lang.String getInvoiceMonetaryValue()
{
	return invoiceMonetaryValue;
}
/**
 * Returns the instance variable value for Shipment Packages
 * @return java.util.Vector
 */
public java.util.Vector getPackages()
{
	return packages;
}
/**
 * Returns the instance variable value for Shipment Payment Information
 * @return java.lang.Object
 */
public java.lang.Object getPaymentInfo()
{
	return paymentInfo;
}
/**
 * Returns the instance variable value for Shipment Pickup Date
 * @return java.lang.String
 */
public java.lang.String getPickupDate()
{
	return pickupDate;
}
/**
 * Returns the instance variable value for Shipment Reference Numbers
 * @return java.util.Vector
 */
public java.util.Vector getReferenceNumbers()
{
	return referenceNumbers;
}
/**
 * Returns the instance variable value for Shipment Scheduled Delivery Date
 * @return java.lang.String
 */
public java.lang.String getScheduledDeliveryDate() {
	return scheduledDeliveryDate;
}
/**
 * Returns the instance variable value for Shipment Scheduled Delivery Time
 * @return java.lang.String
 */
public java.lang.String getScheduledDeliveryTime()
{
	return scheduledDeliveryTime;
}
/**
 * Returns the instance variable value for Shipment Service Code
 * @return java.lang.String
 */
public java.lang.String getServiceCode()
{
	return serviceCode;
}
/**
 * Returns the instance variable value for Shipment Service Description
 * @return java.lang.String
 */
public java.lang.String getServiceDescription()
{
	return serviceDescription;
}
/**
 * Returns the instance variable value for Shipment Ship From Agent
 * @return com.ups.xml.beans.Agent
 */
public Agent getShipFrom()
{
	return shipFrom;
}
/**
 * Returns the instance variable value for Shipment Shipment Identification Number
 * @return java.lang.String
 */
public java.lang.String getShipmentID()
{
	return shipmentID;
}
/**
 * Returns the instance variable value for Shipment Shipment Service Options
 * @return com.ups.xml.beans.ShipmentServiceOptions
 */
public ShipmentServiceOptions getShipmentServiceOptions()
{
	return shipmentServiceOptions;
}
/**
 * Returns the instance variable value for Shipment Weight
 * @return java.lang.String
 */
public java.lang.String getShipmentWeight()
{
	return shipmentWeight;
}
/**
 * Returns the instance variable value for Shipment Weight Code
 * @return java.lang.String
 */
public java.lang.String getShipmentWeightCode()
{
	return shipmentWeightCode;
}
/**
 * Returns the instance variable value for Shipment Weight Description
 * @return java.lang.String
 */
public java.lang.String getShipmentWeightDescription()
{
	return shipmentWeightDescription;
}
/**
 * Returns the instance variable value for Shipment Shipper Agent
 * @return com.ups.xml.beans.Agent
 */
public Agent getShipper()
{
	return shipper;
}
/**
 * Returns the instance variable value for Shipment Ship To Agent
 * @return com.ups.xml.beans.Agent
 */
public Agent getShipTo()
{
	return shipTo;
}
/**
 * Sets the instance variable value for Shipment Alternate Delivery Date
 * @param newAlternateDeliveryDate java.lang.String
 */
public void setAlternateDeliveryDate(java.lang.String newAlternateDeliveryDate)
{
	alternateDeliveryDate = newAlternateDeliveryDate;
}
/**
 * Sets the instance variable value for Shipment Alternate Delivery Time
 * @param newAlternateDeliveryTime java.lang.String
 */
public void setAlternateDeliveryTime(java.lang.String newAlternateDeliveryTime)
{
	alternateDeliveryTime = newAlternateDeliveryTime;
}
/**
 * Sets the instance variable value for Shipment Delivery Zone
 * @param newDeliveryZone java.lang.String
 */
public void setDeliveryZone(java.lang.String newDeliveryZone)
{
	deliveryZone = newDeliveryZone;
}
/**
 * Sets the instance variable value for Shipment Description
 * @param newDescription java.lang.String
 */
public void setDescription(String newDescription)
{
	description = newDescription;
}
/**
 * Sets the instance variable value for Shipment Documents
 * @param newDocuments boolean
 */
public void setDocuments(boolean newDocuments)
{
	documents = newDocuments;
}
/**
 * Sets the instance variable value for Shipment Handling Charge
 * @param newHandlingCharge com.ups.xml.beans.HandlingCharge
 */
public void setHandlingCharge(HandlingCharge newHandlingCharge)
{
	handlingCharge = newHandlingCharge;
}
/**
 * Sets the instance variable value for Shipment Invoice Currency Code
 * @param newInvoiceCurrencyCode java.lang.String
 */
public void setInvoiceCurrencyCode(java.lang.String newInvoiceCurrencyCode)
{
	invoiceCurrencyCode = newInvoiceCurrencyCode;
}
/**
 * Sets the instance variable value for Shipment Invoice Monetary Value
 * @param newInvoiceMonetaryValue java.lang.String
 */
public void setInvoiceMonetaryValue(java.lang.String newInvoiceMonetaryValue)
{
	invoiceMonetaryValue = newInvoiceMonetaryValue;
}
/**
 * Sets the instance variable value for Shipment Packages
 * @param newPackages java.util.Vector
 */
public void setPackages(java.util.Vector newPackages)
{
	packages = newPackages;
}
/**
 * Sets the instance variable value for Shipment Payment Information
 * @param newPaymentInfo java.lang.Object
 */
public void setPaymentInfo(java.lang.Object newPaymentInfo)
{
	paymentInfo = newPaymentInfo;
}
/**
 * Sets the instance variable value for Shipment Pickup Date
 * @param newPickupDate java.lang.String
 */
public void setPickupDate(java.lang.String newPickupDate)
{
	pickupDate = newPickupDate;
}
/**
 * Sets the instance variable value for Shipment Reference Numbers
 * @param newReferenceNumbers java.util.Vector
 */
public void setReferenceNumbers(java.util.Vector newReferenceNumbers)
{
	referenceNumbers = newReferenceNumbers;
}
/**
 * Sets the instance variable value for Shipment Scheduled Delivery Date
 * @param newScheduledDeliveryDate java.lang.String
 */
public void setScheduledDeliveryDate(java.lang.String newScheduledDeliveryDate)
{
	scheduledDeliveryDate = newScheduledDeliveryDate;
}
/**
 * Sets the instance variable value for Shipment Scheduled Delivery Time
 * @param newScheduledDeliveryTime java.lang.String
 */
public void setScheduledDeliveryTime(java.lang.String newScheduledDeliveryTime)
{
	scheduledDeliveryTime = newScheduledDeliveryTime;
}
/**
 * Sets the instance variable value for Shipment Service Code
 * @param newServiceCode java.lang.String
 */
public void setServiceCode(java.lang.String newServiceCode)
{
	serviceCode = newServiceCode;
}
/**
 * Sets the instance variable value for Shipment Service Description
 * @param newServiceDescription java.lang.String
 */
public void setServiceDescription(java.lang.String newServiceDescription)
{
	serviceDescription = newServiceDescription;
}
/**
 * Sets the instance variable value for Shipment Ship From Agent
 * @param newShipFrom com.ups.xml.beans.Agent
 */
public void setShipFrom(Agent newShipFrom)
{
	shipFrom = newShipFrom;
}
/**
 * Sets the instance variable value for Shipment Shipment Identification Number
 * @param newShipmentID java.lang.String
 */
public void setShipmentID(java.lang.String newShipmentID)
{
	shipmentID = newShipmentID;
}
/**
 * Sets the instance variable value for Shipment Service Options
 * @param newShipmentServiceOptions com.ups.xml.beans.ShipmentServiceOptions
 */
public void setShipmentServiceOptions(ShipmentServiceOptions newShipmentServiceOptions)
{
	shipmentServiceOptions = newShipmentServiceOptions;
}
/**
 * Sets the instance variable value for Shipment Weight
 * @param newShipmentWeight java.lang.String
 */
public void setShipmentWeight(java.lang.String newShipmentWeight)
{
	shipmentWeight = newShipmentWeight;
}
/**
 * Sets the instance variable value for Shipment Weight Code
 * @param newShipmentWeightCode java.lang.String
 */
public void setShipmentWeightCode(java.lang.String newShipmentWeightCode)
{
	shipmentWeightCode = newShipmentWeightCode;
}
/**
 * Sets the instance variable value for Shipment Weight Description
 * @param newShipmentWeightDescription java.lang.String
 */
public void setShipmentWeightDescription(java.lang.String newShipmentWeightDescription)
{
	shipmentWeightDescription = newShipmentWeightDescription;
}
/**
 * Sets the instance variable value for Shipment Shipper Agent
 * @param newShipper com.ups.xml.beans.Agent
 */
public void setShipper(Agent newShipper)
{
	shipper = newShipper;
}
/**
 * Sets the instance variable value for Shipment ShipTo Agent
 * @param newShipTo com.ups.xml.beans.Agent
 */
public void setShipTo(Agent newShipTo)
{
	shipTo = newShipTo;
}
/**
 * Returns a String representation of the Shipment's state, token delimeted (=).
 * @return java.lang.String
 */
public String toString()
{
	StringBuffer objXml = new StringBuffer();
	objXml.append("[");
	objXml.append("Description=" + description);
	objXml.append(" ShimentIdentificationNumber=" + shipmentID);
	objXml.append(" Documents=" + documents);
	objXml.append(" DeliveryZone=" + deliveryZone);
	objXml.append(" AlternateDeliveryDate=" + alternateDeliveryDate);
	objXml.append(" AlternateDeliveryTime=" + alternateDeliveryTime);
	objXml.append(" HandlingCharge=" + handlingCharge);
	objXml.append(" InvoiceLineCurrencyCode=" + invoiceCurrencyCode);
	objXml.append(" InvoiceLineMonetaryValue=" + invoiceMonetaryValue);
	objXml.append(" PaymentInformation=" + paymentInfo);
	objXml.append(" PickupDate=" + pickupDate);
	java.util.Enumeration enumRef = referenceNumbers.elements();
	if (enumRef != null)
	{
		int i = 1;
		while (enumRef.hasMoreElements())
		{
			objXml.append(" ReferenceNumber" + i + "=" + ((com.ups.xmlsdk.xpci.ReferenceNumber) enumRef.nextElement()).toString());
			i++;
		}
	}
	objXml.append(" ScheduledDeliveryDate=" + scheduledDeliveryDate);
	objXml.append(" ScheduledDeliveryTime=" + scheduledDeliveryTime);
	objXml.append(" ServiceCode=" + serviceCode);
	objXml.append(" ServiceDescription=" + serviceDescription);
	objXml.append(" Shipper=" + shipper);
	objXml.append(" ShipTo=" + shipTo);
	objXml.append(" ShipFrom=" + shipFrom);
	objXml.append(" ShipmentServiceOptions=" + shipmentServiceOptions);
	objXml.append(" ShipmentWeight=" + shipmentWeight);
	objXml.append(" ShipmentWeightCode=" + shipmentWeightCode);
	objXml.append(" ShipmentWeightDescription=" + shipmentWeightDescription);
	java.util.Enumeration enumPack = packages.elements();
	if (enumPack != null)
	{
		int j = 1;
		while (enumPack.hasMoreElements())
		{
			objXml.append(" Package" + j + "=" + ((com.ups.xmlsdk.xpci.Package) enumPack.nextElement()).toString());
			j++;
		}
	}
	objXml.append("]");
	return objXml.toString();
}
}
