package com.ups.xmlsdk.util.logging;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 2000 United Parcel Service of America, Inc.  All Rights Reserved.
*/

import java.util.*;


/**
 * Formatter with no formatting whatssoever (no additional info is added to the message).
 */
public class NoFormattingLogFormatter implements LogFormatter
{
   int maxRecLen = 256;

   public NoFormattingLogFormatter()
   {
   }         
	public void format(StringBuffer buf, Date time, String facility,
		               int priority, String id, String msg, long code) throws LogException
   {
	   // Do not add any information to the message
	   buf.setLength(0);
	   buf.append(msg);
   }         
	public int getMaxRecLen()
   {
	   return (maxRecLen);
   }         
	public void setMaxRecLen(int m)
   {
	   maxRecLen = m;
   }         
}
