package com.ups.xmlsdk.util.logging;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/

/**
 * Provide external system timing strings for log entries.  Also define
 * timeable systems here.
 */
public class LogTiming
{
	public static final String RAVE = "01";
	public static final String ADDRESS_VALIDATOR = "02";
	public static final String PLD_UPLOAD = "03";
	public static final String ODS = "04";
	public static final String CC_AUTH = "05";
	public static final String TIME_TRAN = "06";
	public static final String VOID = "07";
	public static final String PLD_PLAYBACK_SUM = "08";
	public static final String PLD_PLAYBACK_DETAIL = "09";
	public static final String PING_HISTORY = "10";
	public static final String IMS = "11";


	public static final String START_STR = "ENTER_EXTERNAL_SYSTEM";
	public static final String STOP_STR  = "EXIT_EXTERNAL_SYSTEM";


	public static String start(String msg)
	{
		return START_STR + ", " + msg;
	}
	public static String stop(String msg)
	{
		return STOP_STR + ", " + msg;
	}
}
