package com.ups.xmlsdk.util.logging;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/

import java.io.IOException;

/**
 * Test the logging package
 */
public class LogTest implements LogDefs
{
public static void main(String[] argv)
{
	// set up a basic file logger
	try
	{
		LogFactory lf = DefaultLogFactory.instance();
		lf.setDefaultLogger(new LogFile("ISS", "test.log", false));
		Logger l = lf.getDefaultLogger();
		l.getFormatter().setMaxRecLen(128);
		l.log("message 1");
		l.setLevel(LOG_DEBUG);
		l.log("message 2");
		l.log(LOG_DEBUG, "message 3", 3);
		l.log("message 4");
		l.log(LOG_DEBUG, "message 5", 5);
		l.log(LOG_ERROR, "oh no");

		// set up delegating loggers for specific facilities
		lf.addLogger(new Logger("AVL", l));
		lf.addLogger(new Logger("RAV", l));
		lf.addLogger(new Logger("PLD", l));
		lf.getLogger("AVL").log("message 6");
		lf.getLogger("RAV").log(LOG_ERROR, "message 7", 7777);
		lf.getLogger("PLD").log("message 8");

		// test special case of non-printing characters
		l.log(LOG_ERROR, "Some nonprinting chars: " + "\u000f\u0000\u0080\u00a6");

		// test special case of message greater than max rec length
		StringBuffer b = new StringBuffer();
		for (int i = 0; i < 500; i++)
		{
			b.append((char) (i % 256));
		}
		l.log(LOG_ERROR, "A large message: " + b.toString());

		// set up a syslog logger
		l.close();
		lf.setDefaultLogger(new LogSyslog("localhost", 7, "ISS"));
		l = lf.getDefaultLogger();
		l.setLevel(LOG_DEBUG);
		lf.addLogger(new Logger("CC", l));
		lf.getLogger("CC").log(LOG_ERROR, "message 9", 99);
		lf.getLogger("CC").log(LOG_CRITICAL, "hosed", 12345);
		l.close();
	} catch (IOException e)
	{
		e.printStackTrace();
		System.exit(1);
	} catch (Exception e2)
	{
		e2.printStackTrace();
		System.exit(1);
	}
	System.exit(0);
}
}
