package com.ups.xmlsdk.util.logging;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/

import com.ups.common.util.logging.syslog.*;
import java.io.*;
import java.util.Date;

/**
 * UNIX Syslog logging class
 */
public class LogSyslog extends Logger
{
	Syslog syslog;
	int recsize = 1024;
	int sysLogFacility;

	/**
	 * Construct a Syslog logger on the specified host, facility, and name.
	 * Syslog requires a local facility identifier from 0 to 7 which it uses
	 * to direct the message via its current config file (syslog.conf). It
	 * prefixes each record with a header that should contain an application
	 * name corresponding to the local facility.  Note that Syslog's 
	 * idea of a facility name is not necessarily our facility string,
	 * although by default we use it to initialize our base class facility.
	 */
	public LogSyslog(String host, int localFacility, String name)
		throws IOException
	{
		super(name);
		try
		{
			syslog = new Syslog(host, SyslogDefs.DEFAULT_PORT, name, 0);
		}
		catch(SyslogException e)
		{
			throw new IOException("Error opening syslog: " + e.getMessage());
		}
		if (localFacility < 0 || localFacility > 7)
		{
			throw new IOException(
				"syslog local facility code must be from 0-7");
		}
		this.sysLogFacility = localFacility + SyslogDefs.LOG_LOCAL0;
	}
	public void close() throws IOException
	{
		syslog.close();
		syslog = null;
	}
	public final int log(LogContext context, String facility, int priority,
		String msg, long code) throws LogException
	{	
		if (priority > level) return level;
		try
		{
			StringBuffer cb = context.getBuffer();
			synchronized(cb)
			{
				formatter.format(cb, new Date(), facility, priority,
					context.getId(), msg, code);
				syslog.syslog(sysLogFacility, priority, cb.toString());
			}
		}
		catch(Exception e)
		{
			throw new LogException(e.getMessage());
		}
		return level;
	}
}
