package com.ups.xmlsdk.util.logging;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/

import java.io.*;

/**
 * Constants for classes that use the logging interface.
 */
public interface LogDefs
{
	// Logging priority codes.  Adapted from UNIX syslog.

	// A panic condition.  This is normally broadcast to all users.
	// Implies that the sender is shutting down immediately.
	public static final int LOG_EMERGENCY = 0;

	// A condition that should be corrected immediately, such as a
	// corrupted system database.  The sender will continue to run but
	// will likely fail on the next and succeeding transactions.
	public static final int LOG_ALERT = 1;

	// Critical conditions, such as a lost transaction due to a queue overflow.
	// The sender will continue to run but no prediction can be made as to the
	// success of failure of the next transaction.
	public static final int LOG_CRITICAL = 2;

	// Error messages.  Something has gone wrong but the transaction is not
	// completely lost, for example a status query with some information
	// missing.
	public static final int LOG_ERROR = 3;

	// Warning messages.  The transaction is correct but some other condition
	// warrants attention, such as a remote function call taking too long.
	public static final int LOG_WARNING = 4;

	// Conditions that are not error or warning conditions, but that may
	// require special handling.
	public static final int LOG_NOTICE = 5;

	// Informational messages
	public static final int LOG_INFO = 6;

	// Messages that contain information normally of use only when
	// debugging a program.
	public static final int LOG_DEBUG = 7;

	// Messages indicating function-calling sequence.  Also a synonym for
	// the maximum logging level (log everything).
	public static final int LOG_TRACE = 8;    
	public static final int LOG_ALL   = 8;    

	// Default logging code value.
	public static final long CODE_UNSET = -1;

	// Special codes used for real-time performance measurement
	// No message is logged, but counts are maintained
	public static final int LOG_START_SESSION = 1000;
	public static final int LOG_PACKAGE_COUNT = 1001;
	public static final int LOG_PRINT_LABEL = 1002;
}
