package com.ups.xmlsdk.util.logging;


/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/

import java.util.Hashtable;
import java.io.File;
import org.w3c.dom.Node;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import com.ibm.xml.parser.Parser;
import java.io.FileInputStream;
import com.ups.xmlsdk.util.config.ConfigValueNotFoundException;

/**
 * Default log factory.  Default logger logs to console.
 */
public class DefaultLogFactory implements LogFactory
{
	// Location of configuration file
	protected static final String defaultConfigFile = "D:" + File.separator + "xmlsdk" + File.separator + "conf" + File.separator + "sdkConfig.xml";
	Logger defLogger = new LogConsole("DefaultLogFactory");
	protected static Hashtable optionsTable = null;
	private static boolean firstConfig = true;
	Hashtable t = new Hashtable();
	static DefaultLogFactory instance;
	static
	{
		instance = new DefaultLogFactory();
	}
private DefaultLogFactory()
{
	try
	{
		optionsTable = new Hashtable();

		// configure logger
		LogFile log = new LogFile("LogFactory Init", "D:" + File.separator + "xmlsdk" + File.separator + "logs" + File.separator + "sdk.log", true);
		loadOptions();
		log.setLevel(new Integer(getValueFromOptions("LogLevel")).intValue());
		defLogger = new Logger("LogFactory Init", log);
		log.audit("Default Logger Configured at Level " + log.getLevel());
	} catch (Exception e)
	{
		// do not log this it is a system configuration error
		System.out.println("DefaultLogFactory: " + e.getMessage());
	}
}
	/**
	 * Add a logger, indexed by its facility.
	 */
	public void addLogger(Logger l)
	{
		t.put(l.getFacility(), l);
	}
/**
 * Given a parent node and the child name, returns the child node.
 * @return org.w3c.dom.Node
 * @param nodeName java.lang.String
 */


protected static Node getChildNode(org.w3c.dom.Node parent, String nodeName)
{
	if (parent == null)
		return null;
	Node child = null;
	for (child = parent.getFirstChild(); child != null; child = child.getNextSibling())
	{
		if (child.getNodeName().equals(nodeName))
			return child;
	}
	return null;
}
/**
 * Given a parent node and the child node name returns the child node value.
 * @return java.lang.String
 * @param node org.w3c.dom.Node
 * @param fieldName java.lang.String
 */


protected static String getChildNodeValue(Node node, String fieldName)
{
	if (node == null)
		return "";
	String value = "";
	for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling())
	{
		if (child.getNodeName().equals(fieldName))
		{
			value = getNodeValue(child);
		}
	}
	return value;
}
	/**
	 * Get the default logger for the application.
	 */
	public Logger getDefaultLogger()
	{
		return defLogger;
	}
	/**
	 * Get the logger for the given facility, or null if there is none.
	 */
	public Logger getLogger(String facility)
	{
		return (Logger) t.get(facility);
	}
protected final static String getNodeValue(Node node)
{
	if (node == null)
		return "";
	NodeList nl = node.getChildNodes();
	if (nl == null)
	{
		return new String("");
	}
	Node value = nl.item(0);
	return value.getNodeValue();
}
	/**
	 * Get the logger for the given facility, and if null, create one
	 * that delegates to the default logger.
	 */
	public Logger getOrAddLogger(String facility)
	{
		Logger l = (Logger) t.get(facility);
		if (l == null)
		{
			addLogger(l = new Logger(facility, defLogger));
		}
		return l;
	}
	//-------------------------------------------------------
	// Reads value from app options file
	//-------------------------------------------------------

	protected String getValueFromOptions(String theKey) throws Exception,
		ConfigValueNotFoundException
	{

		String theValue = (String) optionsTable.get(theKey);
		if ( theValue == null )
		{
			throw (new ConfigValueNotFoundException(theKey));
		}

		return theValue;
	}
/**
 * Get the single instance of this factory
 */
public static DefaultLogFactory instance() throws Exception
{
	return instance;
}
protected static void loadOptions() throws Exception
{
	try
	{
		// get file
		FileInputStream fis = new FileInputStream(defaultConfigFile);

		// com.ibm.xml.parser.Parser
		System.out.println("Begin Parse");
		Parser parser = new Parser(defaultConfigFile);
		parser.parse(new org.xml.sax.InputSource(fis));
		if (parser.getNumberOfErrors() > 0)
		{
			System.out.println(parser.getNumberOfErrors() + " Errors Found in SDKConfig.xml");
		}

		//	load hash from the xml stream
		Document doc = parser.getDocument();
		Node root = doc.getLastChild();
		Node logging = getChildNode(root, "Logging");
		if (logging != null)
		{
			optionsTable.put("LogLevel", getChildNodeValue(logging, "LogLevel"));
			optionsTable.put("ShowLogType", getChildNodeValue(logging, "ShowLogType"));
			Node temp = getChildNode(logging, "LogFlushImmediate");
			if (temp != null)
				optionsTable.put("LogFlushImmediate", "true");
			temp = getChildNode(logging, "LogShowDebug");
			if (temp != null)
				optionsTable.put("LogShowDebug", "true");
		}
		fis.close(); // close the InputStream
	} catch (Exception e)
	{
		System.out.println("Exception occured in loadOptions(): " + e.getMessage());
	}
}
	/**
	 * Set the default logger for the application
	 */
	public void setDefaultLogger(Logger l)
	{
		defLogger = l;
	}
}
