package com.ups.xmlsdk.util.formatter;

/*
**
** The use, disclosure, reproduction, modification, transfer, or transmittal
** of this work for any purpose in any form or by any means without the
** written permission of United Parcel Service is strictly prohibited.
**
** Confidential, Unpublished Property of United Parcel Service.
** Use and Distribution Limited Solely to Authorized Personnel.
**
** Copyright 2000 United Parcel Service of America, Inc.  All Rights Reserved.
**
**
** Package     : com.ups.xml.util.formatter
**
** Classes     : SyncSimpleDateFormat
**
** Description : Class to Compensate for SimpleDateFormatter not being thread-safe. User must call release() after use.
**
** Usage       :
**
** Notes       :
**
*/


import java.text.*;
import java.util.Locale;
import java.lang.Thread;
/**
 *  Use in place of SimpleDataFormat - avoids thread-safe problems
 *  Never save reference as an instance or class variable.
 *  Only use as temporary.
 *  User MUST call release() when done.
 *
 *  Example:<br>
 *          SyncSimpleDateFormat df = new SyncSimpleDateFormat(dateFormatString, locale);<br>
 *          df.setTimeZone(timeZone);<br>
 *          dateString = df.format(calendar.getTime());<br>
 *          df.release();<br>
 *
 * @see java.text.SimpleDateFormat
 */
public class SyncSimpleDateFormat extends SimpleDateFormat
{
  private static String syncString = "";
  private static boolean locked = false;
  private boolean IveGotLock = false;

  public SyncSimpleDateFormat()
  {
	  super();
	  lock();
  }        
  public SyncSimpleDateFormat(String s)
  {
	  super(s);
	  lock();
  }        
  public SyncSimpleDateFormat(String s, DateFormatSymbols dfs)
  {
	  super(s,dfs);
	  lock();
  }        
  public SyncSimpleDateFormat(String s, Locale l)
  {
	  super(s,l);
	  lock();
  }        
  public void lock()
  {
	if (IveGotLock)return;

	boolean done = false;
	boolean stolen = false;
	long timer = System.currentTimeMillis();
 //   if (locked)System.out.println("SyncSimpleDateFormat lock() true");else System.out.println("SyncSimpleDateFormat lock() false");
	while(true)
	{
	  synchronized(syncString)
	  {
				if(locked)
		{
		  if (System.currentTimeMillis() - timer > 5000)      // wait 5 secs, then steal lock (somebody died).
		  {
			 done = true;
			 stolen = true;
		  }
		}else{
		  locked = true;
		  done = true;
		}
	  }
	  if (done)break;
	  java.lang.Thread.currentThread().yield();
	}
	if (stolen)System.out.println("SyncSimpleDateFormat lock stolen");
	IveGotLock = true;
  }        
  /**
  *  When finished, user must call this method to release the lock.
  */
  public void release()
  {
		locked = false;
		IveGotLock = false;
  }        
}
