package com.ups.xmlsdk.tracking;

import com.ups.xmlsdk.util.XmlTransmitter;
import com.ups.xmlsdk.xpci.Access;
import com.ups.xmlsdk.la.AccessAdapter;
/*
 *
 *
 *
 */


import java.io.*;
import com.ups.xmlsdk.SDKFactory;
import com.ups.xmlsdk.util.logging.*;
import com.ups.xmlsdk.util.SDKException;

/*
 *
 *
 */

public class TrackingController extends com.ups.xmlsdk.ServiceController
{
	private com.ups.xmlsdk.util.logging.Logger logger;
	private String TRACKING_FACILITY = "TrackingAdapter";

	// transmitter stuff
	private java.lang.String hostname;
	private java.lang.String prot;
	private java.lang.String URLPrefix;
	private java.lang.String keyring;
	private java.lang.String debug;
	private java.lang.String[] proxy = null;
/**
 * TrackingController constructor comment.
 */
public TrackingController()
{
	super();
	try
	{
		init();
		logger = DefaultLogFactory.instance().getOrAddLogger(TRACKING_FACILITY);
	} catch (Exception e)
	{
		logger.error(" Construction Error: TrackingController()::" + e.getMessage());
	}
}
/**
 * execute method takes a ServiceRequest and Returns a ServiceResponse.  Allows a simple access to working adapters and Transmitters.
 * You must implement your own Controller, Adapter, and Transmitter if any of these do not fit your specific needs.
 * this method looks for a number of values in the Properties File for the SDK:
 *		Protocol, Hostname, URLPrefix, KeyRing & proxyHost, proxyPort, proxyUser, proxyPass.
 *
 */
public com.ups.xmlsdk.ServiceResponse execute(com.ups.xmlsdk.ServiceRequest req) throws Exception, com.ups.xmlsdk.util.SDKException
{
	try
	{
		// build response containers
		com.ups.xmlsdk.ServiceResponse servResp = new com.ups.xmlsdk.ServiceResponse();
		com.ups.xmlsdk.tracking.TrackingResponse tr = new com.ups.xmlsdk.tracking.TrackingResponse();

		// get adapter
		TrackingAdapter ta = (TrackingAdapter) SDKFactory.getInstance().getAdapter("com.ups.xmlsdk.tracking.TrackingAdapter");
		// build request
		logger.log("Service = " + req.getType());
		AccessAdapter aa = (AccessAdapter) SDKFactory.getInstance().getAdapter("com.ups.xmlsdk.la.AccessAdapter");
		StringBuffer xmlIn = aa.adaptFromObject((Access) req.getAccess());

		// content
		TrackingRequest tReq = (TrackingRequest) req.getContent();
		StringBuffer sbData = ta.adaptFromObject(tReq);
		xmlIn.append(sbData.toString());

		// build transmitter
		XmlTransmitter xTrans = null;
		if (proxy == null)
		{
			xTrans = new XmlTransmitter(prot, hostname, keyring);
		} else
		{
			xTrans = new XmlTransmitter(prot, hostname, keyring, proxy[0], proxy[1], proxy[2], proxy[3]);
		}
		xTrans.setXml(xmlIn);

		// transmit to server
		xTrans.contactService("Track", URLPrefix);

		// get response
		StringBuffer xmlOut = xTrans.getXml();

		// return the container
		servResp.setType("com.ups.xmlsdk.tracking.TrackingResponse");
		servResp.setContent(ta.adaptFromXml(xmlOut));
		return servResp;
	} catch (Exception e)
	{
		logger.error("TrackingController->execute() " + e.getMessage());
		throw e;
	}
}
/**
 * Given a parent node and the child name, returns the child node.
 * @return org.w3c.dom.Node
 * @param nodeName java.lang.String
 */


private static org.w3c.dom.Node getChildNode(org.w3c.dom.Node parent, String nodeName)
{
	if (parent == null)
		return null;
	org.w3c.dom.Node child = null;
	for (child = parent.getFirstChild(); child != null; child = child.getNextSibling())
	{
		if (child.getNodeName().equals(nodeName))
			return child;
	}
	return null;
}
/**
 * Given a parent node and the child node name returns the child node value.
 * @return java.lang.String
 * @param node org.w3c.dom.Node
 * @param fieldName java.lang.String
 */


private static String getChildNodeValue(org.w3c.dom.Node node, String fieldName)
{
	if (node == null)
		return "";
	String value = "";
	for (org.w3c.dom.Node child = node.getFirstChild(); child != null; child = child.getNextSibling())
	{
		if (child.getNodeName().equals(fieldName))
		{
			value = getNodeValue(child);
		}
	}
	return value;
}
private final static String getNodeValue(org.w3c.dom.Node node)
{
	if (node == null)
		return "";
	org.w3c.dom.NodeList nl = node.getChildNodes();
	if (nl == null)
	{
		return new String("");
	}
	org.w3c.dom.Node value = nl.item(0);
	return value.getNodeValue();
}
/**
 * 
 * read configuration paramaters from config file
 * 
 */
private void init() throws Exception
{
	try
	{
		String defaultConfigFile = "D:" + File.separator + "xmlsdk" + File.separator + "conf" + File.separator + "SDKConfig.xml";
		// Load a configuration file
		FileInputStream is = new FileInputStream(defaultConfigFile);

		// com.ibm.xml.parser.Parser
		logger.log("Parsing Tracking Configuration");
		com.ibm.xml.parser.Parser parser = new com.ibm.xml.parser.Parser(defaultConfigFile);
		parser.parse(new org.xml.sax.InputSource(is));
		if (parser.getNumberOfErrors() > 0)
		{
			logger.error(parser.getNumberOfErrors() + " Errors Found in SDKConfig.xml");
		}

		//	load hash from the xml stream
		org.w3c.dom.Document doc = parser.getDocument();
		org.w3c.dom.Node root = doc.getLastChild();
		org.w3c.dom.Node services = getChildNode(root, "Services");
		if (services != null)
		{
			org.w3c.dom.Node shipping = getChildNode(services, "Tracking");
			if (shipping != null)
			{
				org.w3c.dom.Node trans = getChildNode(shipping, "Transmitter");
				if (trans != null)
				{
					prot = getChildNodeValue(trans, "Protocol");
					hostname = getChildNodeValue(trans, "Hostname");
					URLPrefix = getChildNodeValue(trans, "Prefix");
					keyring = getChildNodeValue(trans, "KeyRing");
					org.w3c.dom.Node proxyNode = getChildNode(trans, "Proxy");
					if (proxyNode != null)
					{
						proxy = new String[4];
						proxy[0] = getChildNodeValue(proxyNode, "ProxyHost");
						proxy[1] = getChildNodeValue(proxyNode, "ProxyPort");
						proxy[2] = getChildNodeValue(proxyNode, "ProxyUser");
						proxy[3] = getChildNodeValue(proxyNode, "ProxyPassword");
					}
					logger.log("Transmitter Settings:" + prot + "://" + hostname + "/" + URLPrefix + "/" + " | " + keyring);
				} else
				{
					logger.error("Transmitter Node is not present!");
					throw new SDKException(SDKException.CONFIGURATION_ERROR, "Transmitter Node is not present!");
				}
			} else
			{
				logger.error("Tracking Node is not present!");
				throw new SDKException(SDKException.CONFIGURATION_ERROR, "Tracking Node is not present!");
			}
		} else
		{
			logger.error("Services Node is not present!");
			throw new SDKException(SDKException.CONFIGURATION_ERROR, "Services Node is not present!");
		}
		is.close(); // close the InputStream
	} catch (SDKException sdk)
	{
		throw sdk;
	} catch (Exception e)
	{
		SDKException sdk = new SDKException("Failed to read configuration File" + e.getMessage(), "999");
		logger.error(sdk.getMessage());
		throw sdk;
	}
}
}
