package com.ups.xmlsdk.shipping;

import com.ups.xmlsdk.xpci.Access;
import java.util.Properties;
import java.io.FileInputStream;
import java.io.File;
import com.ups.xmlsdk.la.AccessAdapter;
import com.ups.xmlsdk.util.*;
import com.ups.xmlsdk.ServiceResponse;
import com.ups.xmlsdk.*;
import com.ups.xmlsdk.util.logging.DefaultLogFactory;
/*
 *
 *
 */
public class ShippingController extends com.ups.xmlsdk.ServiceController
{
	private com.ups.xmlsdk.util.logging.Logger logger;
	private java.lang.String hostname;
	private java.lang.String prot;
	private java.lang.String URLPrefix;
	private java.lang.String keyring;
	private java.lang.String[] proxy = null;
/**
 * ShippingController constructor comment.
 */
public ShippingController()
{
	super();
	try
	{
		init();
		logger = DefaultLogFactory.instance().getOrAddLogger("ShippingController");
	} catch (Exception e)
	{
		logger.error("Controller Constructor::" + e.getMessage());
	}
}
/**
 * execute method takes a ServiceRequest and Returns a ServiceResponse.  Allows a simple access to working adapters and Transmitters.
 * You must implement your own Controller, Adapter, and Transmitter if any of these do not fit your specific needs.
 * this method looks for a number of values in the Properties File for the SDK:
 *		Protocol, Hostname, URLPrefix, KeyRing.
 *
 */
public com.ups.xmlsdk.ServiceResponse execute(com.ups.xmlsdk.ServiceRequest req) throws Exception
{
	try
	{
		ServiceResponse servResp = new ServiceResponse();

		// get a transmitter
		XmlTransmitter xTrans = null;
		if (proxy == null)
		{
			xTrans = new XmlTransmitter(prot, hostname, keyring);
		} else
		{
			xTrans = new XmlTransmitter(prot, hostname, keyring, proxy[0], proxy[1], proxy[2], proxy[3]);
		}

		// get an adapter
		ShipmentAdapter adapter = (ShipmentAdapter) SDKFactory.getInstance().getAdapter("com.ups.xmlsdk.shipping.ShipmentAdapter");
		logger.log("Service = " + req.getType());
		AccessAdapter aa = (com.ups.xmlsdk.la.AccessAdapter) SDKFactory.getInstance().getAdapter("com.ups.xmlsdk.la.AccessAdapter");
		StringBuffer sb = aa.adaptFromObject((Access) req.getAccess());
		if (req.getType().equalsIgnoreCase("ShipConfirm"))
		{

			// build the request document
			ShipmentConfirmRequest scr = (ShipmentConfirmRequest) req.getContent();
			StringBuffer sbData = adapter.adaptFromObject(scr);
			xTrans.setXml(sb.append(sbData.toString()));

			// transmit the request
			xTrans.contactService("ShipConfirm", URLPrefix);

			// build response
			servResp.setContent((ShipmentConfirmResponse) adapter.adaptFromXml(xTrans.getXml()));
		}
		if (req.getType().equalsIgnoreCase("ShipAccept"))
		{

			// build the Request document
			xTrans.setXml(sb.append(adapter.adaptFromObject((ShipmentAcceptRequest) req.getContent())));

			// transmit the request
			xTrans.contactService("ShipAccept", URLPrefix);

			// build response
			servResp.setContent(adapter.adaptFromXml(xTrans.getXml()));
		}

		// return the Response
		return servResp;
	} catch (Exception e)
	{
		logger.error("Controller ->execute(): " + e.getMessage());
		throw e;
	}
}
/**
 * Given a parent node and the child name, returns the child node.
 * @return org.w3c.dom.Node
 * @param nodeName java.lang.String
 */


private static org.w3c.dom.Node getChildNode(org.w3c.dom.Node parent, String nodeName)
{
	if (parent == null)
		return null;
	org.w3c.dom.Node child = null;
	for (child = parent.getFirstChild(); child != null; child = child.getNextSibling())
	{
		if (child.getNodeName().equals(nodeName))
			return child;
	}
	return null;
}
/**
 * Given a parent node and the child node name returns the child node value.
 * @return java.lang.String
 * @param node org.w3c.dom.Node
 * @param fieldName java.lang.String
 */


private static String getChildNodeValue(org.w3c.dom.Node node, String fieldName)
{
	if (node == null)
		return "";
	String value = "";
	for (org.w3c.dom.Node child = node.getFirstChild(); child != null; child = child.getNextSibling())
	{
		if (child.getNodeName().equals(fieldName))
		{
			value = getNodeValue(child);
		}
	}
	return value;
}
private final static String getNodeValue(org.w3c.dom.Node node)
{
	if (node == null)
		return "";
	org.w3c.dom.NodeList nl = node.getChildNodes();
	if (nl == null)
	{
		return new String("");
	}
	org.w3c.dom.Node value = nl.item(0);
	return value.getNodeValue();
}
/**
 * 
 * read configuration paramaters from config file
 * 
 */
private void init() throws Exception
{
	try
	{
		String defaultConfigFile = "D:" + File.separator + "xmlsdk" + File.separator + "conf" + File.separator + "SDKConfig.xml";
		// Load a configuration file
		FileInputStream is = new FileInputStream(defaultConfigFile);

		// com.ibm.xml.parser.Parser
		logger.log("Parsing Shipping Configuration");
		com.ibm.xml.parser.Parser parser = new com.ibm.xml.parser.Parser(defaultConfigFile);
		parser.parse(new org.xml.sax.InputSource(is));
		if (parser.getNumberOfErrors() > 0)
		{
			logger.error(parser.getNumberOfErrors() + " Errors Found in SDKConfig.xml");
		}

		//	load hash from the xml stream
		org.w3c.dom.Document doc = parser.getDocument();
		org.w3c.dom.Node root = doc.getLastChild();
		org.w3c.dom.Node services = getChildNode(root, "Services");
		if (services != null)
		{
			org.w3c.dom.Node shipping = getChildNode(services, "Shipping");
			if (shipping != null)
			{
				org.w3c.dom.Node trans = getChildNode(shipping, "Transmitter");
				if (trans != null)
				{
					prot = getChildNodeValue(trans, "Protocol");
					hostname = getChildNodeValue(trans, "Hostname");
					URLPrefix = getChildNodeValue(trans, "Prefix");
					keyring = getChildNodeValue(trans, "KeyRing");
					org.w3c.dom.Node proxyNode = getChildNode(trans, "Proxy");
					if (proxyNode != null)
					{
						proxy = new String[4];
						proxy[0] = getChildNodeValue(proxyNode, "ProxyHost");
						proxy[1] = getChildNodeValue(proxyNode, "ProxyPort");
						proxy[2] = getChildNodeValue(proxyNode, "ProxyUser");
						proxy[3] = getChildNodeValue(proxyNode, "ProxyPassword");
					}
					logger.log("Transmitter Settings:" + prot + "://" + hostname + "/" + URLPrefix + "/" + " | " + keyring + " | " + proxy);
				} else
				{
					logger.error("Transmitter Node is not present!");
				}
			} else
			{
				logger.error("Shipping Node is not present!");
			}
		} else
		{
			logger.error("Services Node is not present!");
		}
		is.close(); // close the InputStream
	} catch (Exception e)
	{
		SDKException sdk = new SDKException("Failed to read configuration File" + e.getMessage(), "999");
		logger.error(sdk.getMessage());
		throw sdk;
	}
}
}
