package com.ups.xmlsdk.shipping;

import com.ups.xmlsdk.util.SDKException;
import com.ups.xmlsdk.*;
import org.w3c.dom.Element;
import org.w3c.dom.Document;
import com.ups.xmlsdk.xpci.*;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Node;
import com.ibm.xml.parser.*;
/**
 * The ShipmentAdapter will construct a ShipmentConfirmRequest/Response or ShipmentAcceptRequest/Response
 * XML Document from the data provided to the bean through it's setters.
 */
public class ShipmentAdapter extends Adapter
{
	private java.lang.String acceptRoot = XML_ShipmentAcceptRequest;
	private java.lang.String confirmRoot = XML_ShipmentConfirmRequest;
	private boolean shipFromIsPresent;
	private boolean international;
/**
 * ShipmentRequest constructor.
 */
public ShipmentAdapter()
{
	super();
}
/**
 * This method will construct a ShipmentConfirmRequest based on the Beans data.
 * @return java.lang.StringBuffer
 */
public StringBuffer adaptFromObject(ServiceRequestContainer sReq) throws java.lang.Exception
{
	servReqCont = sReq;
	StringBuffer xmlBuf = new StringBuffer();
	try
	{
		if (sReq instanceof ShipmentAcceptRequest)
			xmlBuf = buildAcceptXml(((ShipmentAcceptRequest) sReq).getDigest(), sReq.getRequest());
		if (sReq instanceof ShipmentConfirmRequest)
		{
			international = ((ShipmentConfirmRequest) sReq).isInternational();
			xmlBuf = buildConfirmDocument(sReq);
		}
	} catch (LibraryException le)
	{
		String errMsg = "Library Exception";
		throw new SDKException(errMsg, SDKException.UNDETERMINED);
	} catch (java.io.IOException ie)
	{
		String errMsg = "IOException";
		throw new SDKException(errMsg, SDKException.UNDETERMINED);
	} catch (Exception e)
	{
		String errMsg = "Probably caused by insufficient data-" + e.getMessage();
		throw new SDKException(errMsg, SDKException.XML_PROCESSING_ERROR);
	}
	return xmlBuf;
}
/**
 * 
 * 
 * 
 * @return com.ups.xmlsdk.ServiceResponseContainer
 * @param anXmlStream java.lang.StringBuffer
 * @exception java.lang.Exception The exception description.
 */
public ServiceResponseContainer adaptFromXml(StringBuffer anXmlStream) throws java.lang.Exception
{
	servRespCont = (ServiceResponseContainer) factory.getServiceContainer("com.ups.xmlsdk.ServiceResponseContainer");
	String myString = anXmlStream.toString();
	if (myString.indexOf("Confirm") != -1)
	{
		parseConfirmDocument(anXmlStream);
	} else
		if (myString.indexOf("Accept") != -1)
		{
			parseAcceptDocument(anXmlStream);
		} else
		{
			throw new SDKException("Root Node not found!", SDKException.XML_PROCESSING_ERROR);
		}
	return servRespCont;
}
/**
 * 
 * Builds a list of numbers returned from the Fax vector
 * 
 * @param doc org.w3c.dom.Document
 */
private void addFax(Document doc, String parent, java.util.Vector faxVec)
{
	Enumeration enum = faxVec.elements();
	while (enum.hasMoreElements())
	{
		Phone phone = (Phone) enum.nextElement();
		// build phone number
		if (phone instanceof StructuredPhoneNumber)
		{
			StructuredPhoneNumber phoneNum = (StructuredPhoneNumber) phone;
			Vector strucPhoneNum = new Vector();
			AdapterUtility.addNode(doc, parent, XML_FaxNumber, null, null, null);
			AdapterUtility.addNode(doc, XML_FaxNumber, XML_StructuredPhoneNumber, null, null, null);
			String phoneLineNum = phoneNum.getPhoneLineNumber();
			String extension = phoneNum.getPhoneExtension();
			String dialPlan = phoneNum.getPhoneDialPlanNumber();
			String phoneCC = phoneNum.getPhoneCountryCode();
			if (phoneCC != null)
			{
				if (phoneCC.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneCountryCode, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneCountryCode, phoneCC, null, null);
				}
			}
			if (dialPlan != null)
			{
				if (dialPlan.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneDialPlanNumber, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneDialPlanNumber, dialPlan, null, null);
				}
			}
			if (phoneLineNum != null)
			{
				if (phoneLineNum.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, phoneLineNum, null, null);
				}
			}
			if (extension != null)
			{
				if (extension.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneExtension, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, extension, null, null);
				}
			}
		}
	}
}
private void addPackage(Document doc, Package pack) throws Exception
{
	AdapterUtility.addNode(doc, XML_Shipment, XML_Package, null, null, null);
	String packType = pack.getPackagingTypeCode();
	if (packType != null)
	{
		AdapterUtility.addNode(doc, XML_Package, XML_PackagingType, null, null, null);
		if (packType.equals("#RM"))
		{
			AdapterUtility.addNode(doc, XML_PackagingType, XML_Code, "", null, null);
		} else
		{
			AdapterUtility.addNode(doc, XML_PackagingType, XML_Code, packType, null, null);
		}
		String packTypeDesc = pack.getPackagingTypeDesc();
		if (packTypeDesc != null)
		{
			if (packTypeDesc.equals("#RM"))
			{
				AdapterUtility.addNode(doc, XML_PackagingType, XML_Description, "", null, null);
			} else
			{
				AdapterUtility.addNode(doc, XML_PackagingType, XML_Description, packTypeDesc, null, null);
			}
		}
	}
	String packageDesc = pack.getDescription();
	if (packageDesc != null)
	{
		if (packageDesc.equals("#RM"))
		{
			AdapterUtility.addNode(doc, XML_Package, XML_Description, "", null, null);
		} else
		{
			AdapterUtility.addNode(doc, XML_Package, XML_Description, packageDesc, null, null);
		}
	}
	String len = pack.getLength();
	if ((len != null) && !(len.startsWith("#RM")))
	{
		AdapterUtility.addNode(doc, XML_Package, XML_Dimensions, null, null, null);
		addUnitOfMeasure(doc, XML_Dimensions, pack.getDimensionsUOMCode(), pack.getDimensionsUOMDesc());
		AdapterUtility.addNode(doc, XML_Dimensions, XML_Length, len, null, null);
		AdapterUtility.addNode(doc, XML_Dimensions, XML_Width, pack.getWidth(), null, null);
		AdapterUtility.addNode(doc, XML_Dimensions, XML_Height, pack.getHeight(), null, null);
	}
	AdapterUtility.addNode(doc, XML_Package, XML_PackageWeight, null, null, null);
	addUnitOfMeasure(doc, XML_PackageWeight, pack.getDimensionalWeightUOMCode(), pack.getDimensionalWeightUOMDesc());
	AdapterUtility.addNode(doc, XML_PackageWeight, XML_Weight, pack.getPackageWeight(), null, null);

	//Oversize Package
	String OSValue = pack.getOversizePackage();
	if (OSValue != null)
	{
		if (OSValue.equals("#RM"))
		{
			AdapterUtility.addNode(doc, XML_Package, XML_OversizePackage, "", null, null);
		} else
		{
			AdapterUtility.addNode(doc, XML_Package, XML_OversizePackage, OSValue, null, null);
		}
	}
	//Additional Handling
	boolean AH = pack.isAdditionalHandling();
	if (AH)
	{
		AdapterUtility.addNode(doc, XML_Package, XML_AdditionalHandling, "", null, null);
	}


	//PACKAGE REFERENCES
	if (international)
	{
		Enumeration enum = pack.getReferenceNumbers().elements();
		while (enum.hasMoreElements())
		{
			ReferenceNumber ref = (ReferenceNumber) enum.nextElement();
			addReference(doc, XML_Package, ref.getCode(), ref.getValue());
		}
	}

	// PACKAGE SERVICE OPTIONS
	PackageServiceOptions pso = pack.getPackageServiceOptions();
	if (pso != null)
	{
		Vector master = new Vector();
		Vector declaredIns = new Vector();
		String insCurr = pso.getInsuredValueCode();
		String insValue = pso.getInsuredValue();
		if (insCurr != null)
		{
			if (insCurr.equals("#RM"))
			{
				declaredIns.addElement(AdapterUtility.buildVector(XML_CurrencyCode, ""));
			} else
			{
				declaredIns.addElement(AdapterUtility.buildVector(XML_CurrencyCode, insCurr));
			}
		}
		if (insValue != null)
		{
			if (insValue.equals("#RM"))
			{
				declaredIns.addElement(AdapterUtility.buildVector(XML_MonetaryValue, ""));
			} else
			{
				declaredIns.addElement(AdapterUtility.buildVector(XML_MonetaryValue, insValue));
			}
		}
		master.addElement(AdapterUtility.buildVector(XML_InsuredValue, declaredIns));
		AdapterUtility.buildNode(doc, XML_Package, XML_PackageServiceOptions, master);
		String contactName = pso.getVerbalContactName();
		if (contactName != null)
		{
			// STRUCTURED PHONE NUMBER
			addPhone(doc, XML_VerbalConfirmation, (Phone) pso.getVerbalContactPhone());
		}
		Enumeration shNo = pso.getShipmentNotification().elements();
		while (shNo.hasMoreElements())
		{
			ShipmentNotification shipNot = (ShipmentNotification) shNo.nextElement();
			addShipmentNotification(doc, shipNot, XML_PackageServiceOptions);
		}
	}
}
/**
 * 
 * 
 * 
 * @param doc org.w3c.dom.Document
 */
private void addPhone(Document doc, String parent, com.ups.xmlsdk.xpci.Phone phone)
{
	// build phone number
	if (phone instanceof StructuredPhoneNumber)
	{
		StructuredPhoneNumber phoneNum = (StructuredPhoneNumber) phone;
		Vector strucPhoneNum = new Vector();
		AdapterUtility.addNode(doc, parent, XML_PhoneNumber, null, null, null);
		AdapterUtility.addNode(doc, XML_PhoneNumber, XML_StructuredPhoneNumber, null, null, null);
		String phoneLineNum = phoneNum.getPhoneLineNumber();
		String extension = phoneNum.getPhoneExtension();
		String dialPlan = phoneNum.getPhoneDialPlanNumber();
		String phoneCC = phoneNum.getPhoneCountryCode();
		if (phoneCC != null)
		{
			if (phoneCC.equals("#RM"))
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneCountryCode, null, null, null);
			} else
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneCountryCode, phoneCC, null, null);
			}
		}
		if (dialPlan != null)
		{
			if (dialPlan.equals("#RM"))
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneDialPlanNumber, null, null, null);
			} else
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneDialPlanNumber, dialPlan, null, null);
			}
		}
		if (phoneLineNum != null)
		{
			if (phoneLineNum.equals("#RM"))
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, null, null, null);
			} else
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, phoneLineNum, null, null);
			}
		}
		if (extension != null)
		{
			if (extension.equals("#RM"))
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneExtension, null, null, null);
			} else
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, extension, null, null);
			}
		}
	}
}
/**
 * 
 * Builds a list of numbers returned from the phone vector
 * 
 * @param doc org.w3c.dom.Document
 */
private void addPhone(Document doc, String parent, java.util.Vector phoneVec)
{
	Enumeration enum = phoneVec.elements();
	while (enum.hasMoreElements())
	{
		Phone phone = (Phone) enum.nextElement();
		// build phone number
		if (phone instanceof StructuredPhoneNumber)
		{
			StructuredPhoneNumber phoneNum = (StructuredPhoneNumber) phone;
			Vector strucPhoneNum = new Vector();
			AdapterUtility.addNode(doc, parent, XML_PhoneNumber, null, null, null);
			AdapterUtility.addNode(doc, XML_PhoneNumber, XML_StructuredPhoneNumber, null, null, null);
			String phoneLineNum = phoneNum.getPhoneLineNumber();
			String extension = phoneNum.getPhoneExtension();
			String dialPlan = phoneNum.getPhoneDialPlanNumber();
			String phoneCC = phoneNum.getPhoneCountryCode();
			if (phoneCC != null)
			{
				if (phoneCC.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneCountryCode, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneCountryCode, phoneCC, null, null);
				}
			}
			if (dialPlan != null)
			{
				if (dialPlan.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneDialPlanNumber, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneDialPlanNumber, dialPlan, null, null);
				}
			}
			if (phoneLineNum != null)
			{
				if (phoneLineNum.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, phoneLineNum, null, null);
				}
			}
			if (extension != null)
			{
				if (extension.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneExtension, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneExtension, extension, null, null);
				}
			}
		}
	}
}
/**
 * 
 * 
 * 
 * @param doc org.w3c.dom.Document
 * @param shipper com.ups.xmlsdk.xpci.Prepaid
 */
private void addPrepaid(Document doc, com.ups.xmlsdk.xpci.Prepaid shipper)
{
	Vector billShipperVector = new Vector();
	// shipper is an istance of PrepaidBillShipper
	if (shipper instanceof PrepaidBillShipper)
	{
		PrepaidBillShipper billShipper = (PrepaidBillShipper) shipper;
		String accountNumber = billShipper.getAccountNumber();
		if (accountNumber != null)
		{
			if (!(accountNumber.startsWith("#RM")))
			{
				billShipperVector.addElement(AdapterUtility.buildVector(XML_AccountNumber, accountNumber));
			}
		}
		String CCN = billShipper.getCreditCardNumber();
		if (CCN != null)
		{
			if (!(CCN.startsWith("#RM")))
			{
				Vector ccVector = new Vector();
				ccVector.addElement(AdapterUtility.buildVector(XML_Type, billShipper.getCreditCardType()));
				ccVector.addElement(AdapterUtility.buildVector(XML_Number, CCN));
				ccVector.addElement(AdapterUtility.buildVector(XML_ExpirationDate, billShipper.getCreditCardExpiration()));
				billShipperVector.addElement(AdapterUtility.buildVector(XML_CreditCard, ccVector));
			}
		}
		AdapterUtility.addNode(doc, XML_Shipment, XML_PaymentInformation, null, null, null);
		AdapterUtility.addNode(doc, XML_PaymentInformation, XML_Prepaid, null, null, null);
		AdapterUtility.buildNode(doc, XML_Prepaid, XML_BillShipper, billShipperVector);
	}
	if (shipper instanceof PrepaidBillThirdShipper)
	{
		PrepaidBillThirdShipper billShipper = (PrepaidBillThirdShipper) shipper;
		String accountNumber = billShipper.getAccountNumber();
		if (accountNumber != null)
		{
			if (!(accountNumber.startsWith("#RM")))
			{
				billShipperVector.addElement(AdapterUtility.buildVector(XML_AccountNumber, accountNumber));
			}
		}
		CorpAgent thirdParty = billShipper.getThirdParty();
		if (thirdParty != null)
		{
			// build corpAgent stuff here

		}
		AdapterUtility.addNode(doc, XML_Shipment, XML_PaymentInformation, null, null, null);
		AdapterUtility.addNode(doc, XML_PaymentInformation, XML_Prepaid, null, null, null);
		AdapterUtility.buildNode(doc, XML_Prepaid, XML_BillThirdPartyShipper, billShipperVector);
	}
}
private void addReference(Document doc, String parent, String code, String value)
{
	AdapterUtility.addNode(doc, parent, XML_ReferenceNumber, null, null, null);
	AdapterUtility.addNode(doc, XML_ReferenceNumber, XML_Code, code, null, null);
	AdapterUtility.addNode(doc, XML_ReferenceNumber, XML_Value, value, null, null);
}
/**
 * 
 * Creation date: (8/8/00 10:12:18 AM)
 */
private void addShipmentNotification(Document doc, ShipmentNotification shipNot, String parent) throws Exception
{
	AdapterUtility.addNode(doc, parent, XML_ShipmentNotification, null, null, null);
	String NotificationCode = shipNot.getNotificationCode();
	if (NotificationCode != null)
	{
		if (NotificationCode.equals("#RM"))
		{
			AdapterUtility.addNode(doc, XML_ShipmentNotification, XML_NotificationCode, null, null, null);
		} else
		{
			AdapterUtility.addNode(doc, XML_ShipmentNotification, XML_NotificationCode, NotificationCode, null, null);
		}
	}
	// build Attention Name
	String AttentionName = shipNot.getAttentionName();
	if (AttentionName != null)
	{
		if (AttentionName.equals("#RM"))
		{
			AdapterUtility.addNode(doc, XML_ShipmentNotification, XML_AttentionName, null, null, null);
		} else
		{
			AdapterUtility.addNode(doc, XML_ShipmentNotification, XML_AttentionName, AttentionName, null, null);
		}
	}
	// build Company Name
	String CompanyName = shipNot.getCompanyName();
	if (CompanyName != null)
	{
		if (CompanyName.equals("#RM"))
		{
			AdapterUtility.addNode(doc, XML_ShipmentNotification, XML_CompanyName, null, null, null);
		} else
		{
			AdapterUtility.addNode(doc, XML_ShipmentNotification, XML_CompanyName, CompanyName, null, null);
		}
	}
	// build fax destination
	String faxDestNum = shipNot.getFaxDestinationNumber();
	if (faxDestNum != null)
	{
		Vector faxDest = new Vector();
		String Indicator = shipNot.getFaxDestinationIndicator();
		if (Indicator != null)
		{
			if (Indicator.equals("#RM"))
			{
				faxDest.addElement(AdapterUtility.buildVector(XML_FaxDestinationIndicator, null));
			} else
			{
				faxDest.addElement(AdapterUtility.buildVector(XML_FaxDestinationIndicator, null));
			}
		}
		if (faxDestNum.equals("#RM"))
		{
			faxDest.addElement(AdapterUtility.buildVector(XML_FaxNumber, null));
		} else
		{
			faxDest.addElement(AdapterUtility.buildVector(XML_FaxNumber, faxDestNum));
		}
		AdapterUtility.buildNode(doc, XML_ShipmentNotification, XML_FaxDestination, faxDest);
	}
	// build email message
	EmailMessage message = shipNot.getEmailMessage();
	if (message != null)
	{
		Vector emailMessage = new Vector();
		String[] emailAdd = message.getEmailAddress();
		int em = emailAdd.length;
		for (int k = em; k <= em; k++)
		{
			if (emailAdd.equals("#RM"))
			{
				emailMessage.addElement(AdapterUtility.buildVector(XML_EmailAddress, null));
			} else
			{
				emailMessage.addElement(AdapterUtility.buildVector(XML_EmailAddress, emailAdd));
			}
		}
		String memo = message.getMemo();
		if (memo != null)
		{
			if (memo.equals("#RM"))
			{
				emailMessage.addElement(AdapterUtility.buildVector(XML_Memo, null));
			} else
			{
				emailMessage.addElement(AdapterUtility.buildVector(XML_Memo, memo));
			}
		}
		Enumeration imEnum = message.getImage().elements();
		while (imEnum.hasMoreElements())
		{
			Image im = (Image) imEnum.nextElement();
			Vector image = new Vector();
			Vector imageFormat = new Vector();
			String code = im.getImageFormatCode();
			if (code != null)
			{
				if (code.equals("#RM"))
				{
					imageFormat.addElement(AdapterUtility.buildVector(XML_Code, null));
				} else
				{
					imageFormat.addElement(AdapterUtility.buildVector(XML_Code, code));
				}
			}
			String desc = im.getImageFormatDesc();
			if (desc != null)
			{
				if (desc.equals("#RM"))
				{
					imageFormat.addElement(AdapterUtility.buildVector(XML_Description, null));
				} else
				{
					imageFormat.addElement(AdapterUtility.buildVector(XML_Description, desc));
				}
			}
			image.addElement(AdapterUtility.buildVector(XML_ImageFormat, imageFormat));
			String graphic = im.getGraphicImage();
			if (graphic != null)
			{
				if (graphic.equals("#RM"))
				{
					image.addElement(AdapterUtility.buildVector(XML_GraphicImage, null));
				} else
				{
					image.addElement(AdapterUtility.buildVector(XML_GraphicImage, graphic));
				}
			}
			emailMessage.addElement(AdapterUtility.buildVector(XML_Image, image));
		}
		AdapterUtility.buildNode(doc, XML_ShipmentNotification, XML_EmailMessage, emailMessage);
	}
	// PHONE NUMBER 
	Phone phoneNum = (Phone) shipNot.getPhoneNumber();
	addPhone(doc, XML_ShipmentNotification, phoneNum);

	// END SHIPMENT NOTIFICATION

}
private void addUnitOfMeasure(Document doc, String parent, String code, String desc)
{
	if ((code != null) && !(code.equals("#RM")))
	{
		AdapterUtility.addNode(doc, parent, XML_UnitOfMeasurement, null, null, null);
		AdapterUtility.addNode(doc, XML_UnitOfMeasurement, XML_Code, code, null, null);
		AdapterUtility.addNode(doc, XML_UnitOfMeasurement, XML_Description, desc, null, null);
	}
}
/**
 * This method will construct a ShipmentAcceptRequest based on the Beans data.
 * @return java.lang.StringBuffer
 */
private StringBuffer buildAcceptXml(String digest, com.ups.xmlsdk.xpci.Request request) throws Exception
{
	StringBuffer xmlBuf = new StringBuffer();
	Document doc = createXMLDocument(acceptRoot);
	Element root = doc.getDocumentElement();
	root.setAttribute("xml:lang", "en-US");
	buildRequest(doc, acceptRoot);
	AdapterUtility.addNode(doc, acceptRoot, XML_ShipmentDigest, digest, null, null);
	xmlBuf = docToBuffer(doc);
	return xmlBuf;
}
/**
 *  This method builds either the Shipper, Ship To, or ShipFrom node and their children
 *	depending on the 'type' entered.  'type' also corresponds to the node name.
 *	If 'type' is not one of (Shipper,ShipTo,ShipFrom) only an address node is built
 */

private void buildAgent(Document doc, Agent agent, String type) throws Exception
{
	Vector ccVector = new Vector();
	Vector phoneExt = new Vector();
	Vector phone = agent.getPhoneNumber();
	AdapterUtility.addNode(doc, XML_Shipment, type, null, null, null);
	if (type.equals(XML_Shipper))
	{
		//Name is required - if name is empty use the company name
		String name = agent.getName();
		if (name == null)
			name = agent.getCompanyName();
		AdapterUtility.addNode(doc, type, XML_Name, name, null, null);
		String shipperNum = agent.getShipperNumber();
		if (international == true)
		{
			AdapterUtility.addNode(doc, type, XML_AttentionName, name, null, null);
		}
		AdapterUtility.addNode(doc, type, XML_ShipperNumber, shipperNum, null, null);
		AdapterUtility.addNode(doc, type, XML_EmailAddress, agent.getEmailAddress(), null, null); //  email address node added  on 08-07-2000 for A2A release testing
	}
	if (type.equals(XML_ShipTo))
	{
		//Company Name is required 
		String coName = agent.getCompanyName();
		String attName = agent.getName();
		if (coName == null)
			coName = attName;
		AdapterUtility.addNode(doc, type, XML_CompanyName, coName, null, null);
		String taxId = agent.getTaxID();
		String emailAdd = agent.getEmailAddress();


		//for international shipments attention Name is also required
		if (international)
		{
			if ((attName == null) || (attName.equals("#RM")))
			{
				attName = coName;
			}
		}
		AdapterUtility.addNode(doc, type, XML_AttentionName, attName, null, null);
		AdapterUtility.addNode(doc, type, XML_TaxIdentificationNumber, taxId, null, null);
		if (agent.getFaxNumber() != null)
			addFax(doc, type, agent.getFaxNumber());
		AdapterUtility.addNode(doc, type, XML_EmailAddress, emailAdd, null, null); //  email address node added  on 08-07-2000 for A2A release testing

	}
	if (type.equals(XML_ShipFrom))
	{
		//Company Name is required 
		String coName = agent.getCompanyName();
		String name = agent.getName();
		String emailAdd = agent.getEmailAddress();
		if (coName == null)
			coName = name;
		AdapterUtility.addNode(doc, type, XML_CompanyName, coName, null, null);
		AdapterUtility.addNode(doc, type, XML_AttentionName, name, null, null);
		if (agent.getFaxNumber() != null)
			addFax(doc, type, agent.getFaxNumber());
		AdapterUtility.addNode(doc, type, XML_EmailAddress, emailAdd, null, null); //  email address node added  on 08-07-2000 for A2A release testing

	}
	// phone
	addPhone(doc, type, phone);
	//ADDRESS
	AddressAbstract add = agent.getAddress();
	AdapterUtility.buildAddress(doc, type, add);
}
private StringBuffer buildConfirmDocument(ServiceRequestContainer sc) throws Exception
{
	Document doc = createXMLDocument(confirmRoot);
	Element root = doc.getDocumentElement();
	root.setAttribute("xml:lang", "en-US");
	try
	{
		buildRequest(doc, confirmRoot);
		buildLabelSpec(doc, confirmRoot, ((ShipmentConfirmRequest) sc).getLabelSpecification());

		// get the shipment from the service container
		Shipment shipment = ((ShipmentConfirmRequest) sc).getShipment();
		//SHIPMENT

		AdapterUtility.addNode(doc, confirmRoot, XML_Shipment, null, null, null);
		String shipmentID = shipment.getShipmentID();
		AdapterUtility.addNode(doc, XML_Shipment, XML_Description, shipment.getDescription(), null, null);
		shipFromIsPresent = true;
		//SHIPPER
		Agent shipper = shipment.getShipper();
		buildAgent(doc, shipper, XML_Shipper);
		//SHIP TO
		Agent shipTo = shipment.getShipTo();
		buildAgent(doc, shipTo, XML_ShipTo);
		//SHIP FROM
		Agent shipFrom = shipment.getShipFrom();
		if (shipFrom == null)
		{
			shipFromIsPresent = false;
		} else
		{
			buildAgent(doc, shipFrom, XML_ShipFrom);
		}

		// No Commercial Value Indicator  - added for A2A testing on 08-07-2000
		boolean comValue = shipment.getDocuments();
		if (comValue)
			AdapterUtility.addNode(doc, XML_Shipment, XML_DocumentsOnly, null, null, null);

		// Scheduled Delivery Time - added for A2A testing on 08-07-2000
		String scheduledDeliveryDate = shipment.getScheduledDeliveryDate();
		String scheduledDeliveryTime = shipment.getScheduledDeliveryTime();
		if (scheduledDeliveryDate != null)
			AdapterUtility.addNode(doc, XML_Shipment, XML_ScheduledDeliveryDate, scheduledDeliveryDate, null, null);
		if (scheduledDeliveryTime != null)
			AdapterUtility.addNode(doc, XML_Shipment, XML_ScheduledDeliveryTime, scheduledDeliveryTime, null, null);



		//PAYMENT INFO - ASSUMES PREPAYMENT
		Object payInfo = shipment.getPaymentInfo();
		if (payInfo instanceof Prepaid)
		{
			addPrepaid(doc, (Prepaid) payInfo);
		}



		//SHIPMENT REFERENCE NUMBERS
		if (international == true)
		{
			Enumeration refEnum = shipment.getReferenceNumbers().elements();
			while (refEnum.hasMoreElements())
			{
				ReferenceNumber ref = (ReferenceNumber) refEnum.nextElement();
				addReference(doc, XML_Shipment, ref.getCode(), ref.getValue());
			}
		}
		//SERVICE
		AdapterUtility.addNode(doc, XML_Shipment, XML_Service, null, null, null);
		AdapterUtility.addNode(doc, XML_Service, XML_Code, shipment.getServiceCode(), null, null);
		AdapterUtility.addNode(doc, XML_Service, XML_Description, shipment.getServiceDescription(), null, null);

		// INVOICE
		if (shipment.getInvoiceMonetaryValue() != null)
		{
			Vector invoiceLineTotal = new Vector();
			invoiceLineTotal.addElement(AdapterUtility.buildVector(XML_CurrencyCode, shipment.getInvoiceCurrencyCode()));
			invoiceLineTotal.addElement(AdapterUtility.buildVector(XML_MonetaryValue, shipment.getInvoiceMonetaryValue()));
			AdapterUtility.buildNode(doc, XML_Shipment, XML_InvoiceLineTotal, invoiceLineTotal);
		}


		//SHIPMENT SERVICE OPTIONS
		ShipmentServiceOptions sso = shipment.getShipmentServiceOptions();
		if (sso != null)
		{
			Vector master = new Vector();
			boolean satPickup = sso.isSaturdayPickup();
			if (satPickup)
				master.addElement(AdapterUtility.buildVector(XML_SaturdayPickup, null));
			boolean satDelivery = sso.isSaturdayDelivery();
			if (satDelivery)
				master.addElement(AdapterUtility.buildVector(XML_SaturdayDelivery, null));
			if (international == true)
			{
				Vector declaredIns = new Vector();
				String insCurr = sso.getInsuredValueCode();
				String insValue = sso.getInsuredValue();
				if (insCurr != null)
				{
					if (insCurr.equals("#RM"))
					{
						declaredIns.addElement(AdapterUtility.buildVector(XML_CurrencyCode, ""));
					} else
					{
						declaredIns.addElement(AdapterUtility.buildVector(XML_CurrencyCode, insCurr));
					}
				}
				if (insValue != null)
				{
					if (insValue.equals("#RM"))
					{
						declaredIns.addElement(AdapterUtility.buildVector(XML_MonetaryValue, ""));
					} else
					{
						declaredIns.addElement(AdapterUtility.buildVector(XML_MonetaryValue, insValue));
					}
				}
				master.addElement(AdapterUtility.buildVector(XML_InsuredValue, declaredIns));
			}
			AdapterUtility.buildNode(doc, XML_Shipment, XML_ShipmentServiceOptions, master);
			Enumeration notEnum = sso.getShipmentNotification().elements();
			while (notEnum.hasMoreElements())
			{
				ShipmentNotification shipmentNot = (ShipmentNotification) notEnum.nextElement();
				addShipmentNotification(doc, shipmentNot, XML_ShipmentServiceOptions);
			}
		}
		//PACKAGES
		Enumeration packEnum = shipment.getPackages().elements();
		while (packEnum.hasMoreElements())
		{
			Package pack = (Package) packEnum.nextElement();
			addPackage(doc, pack);
		}
		return docToBuffer(doc);
	} catch (Exception e)
	{
		throw e;
	}
}
private void buildLabelSpec(Document doc, String rootname, LabelSpecification labelSpec)
{
	//This method builds the label specification node and all its children

	String s1 = labelSpec.getPrintMethodCode();
	AdapterUtility.addNode(doc, rootname, XML_LabelSpecification, null, null, null);
	AdapterUtility.addNode(doc, XML_LabelSpecification, XML_LabelPrintMethod, null, null, null);
	AdapterUtility.addNode(doc, XML_LabelPrintMethod, XML_Code, s1, null, null);
	AdapterUtility.addNode(doc, XML_LabelPrintMethod, XML_Description, labelSpec.getPrintMethodDesc(), null, null);
	if (s1.equalsIgnoreCase("GIF"))
	{
		AdapterUtility.addNode(doc, XML_LabelSpecification, XML_HTTPUserAgent, labelSpec.getHttpUserAgent(), null, null);
		AdapterUtility.addNode(doc, XML_LabelSpecification, XML_LabelImageFormat, null, null, null);
		AdapterUtility.addNode(doc, XML_LabelImageFormat, XML_Code, labelSpec.getImageFormatCode(), null, null);
		AdapterUtility.addNode(doc, XML_LabelImageFormat, XML_Description, labelSpec.getImageFormatDescription(), null, null);
	}
	if (s1.equalsIgnoreCase("EPL"))
	{
		AdapterUtility.addNode(doc, XML_LabelSpecification, XML_LabelStockSize, null, null, null);
		addUnitOfMeasure(doc, XML_LabelStockSize, labelSpec.getStockSizeCode(), labelSpec.getStockSizeDesc());
		AdapterUtility.addNode(doc, XML_LabelStockSize, XML_Height, labelSpec.getStockSizeHeight(), null, null);
		AdapterUtility.addNode(doc, XML_LabelStockSize, XML_Width, labelSpec.getStockSizeWidth(), null, null);
	}
}
/**
 * 
 * 
 * 
 * @param xmlIn java.lang.StringBuffer
 * @exception com.ups.xml.util.SDKException The exception description.
 */
private void parseAcceptDocument(StringBuffer xmlIn) throws Exception
{
	try
	{
		ShipmentAcceptResponse sar = (ShipmentAcceptResponse) factory.getServiceContainer("com.ups.xmlsdk.shipping.ShipmentAcceptResponse");
		ShipmentResults sr = (ShipmentResults) factory.getXPCIContainer("ShipmentResults");
		Document doc = getDocument(xmlIn.toString());
		org.w3c.dom.Node root = doc.getFirstChild();

		// get reponse
		buildResponse(root);
		sar.setResponse(servRespCont.getResponse());

		// walk and retrieve the data
		Node shipmentResult = getChildNode(root, XML_ShipmentResults);
		if (shipmentResult != null)
		{
			sr.setShipmentIdentificationNumber(getChildNodeValue(shipmentResult, XML_ShipmentIdentificationNumber));
			Node billingNode = getChildNode(shipmentResult, XML_BillingWeight);
			if (billingNode != null)
			{
				BillingWeight billingWeight = (BillingWeight) factory.getXPCIContainer("BillingWeight");
				billingWeight.setWeight(getChildNodeValue(billingNode, XML_Weight));
				Node UOM = getChildNode(billingNode, XML_UnitOfMeasurement);
				if (UOM != null)
				{
					UnitOfMeasurement uom = (UnitOfMeasurement) factory.getXPCIContainer("UnitOfMeasurement");
					uom.setCode(getChildNodeValue(UOM, XML_Code));
					uom.setValue(getChildNodeValue(UOM, XML_Value));
					billingWeight.setUnitOfMeasurement(uom);
				}
				sr.setBillingWeight(billingWeight);
			}
			Node shipmentChargesNode = getChildNode(shipmentResult, XML_ShipmentCharges);
			if (shipmentChargesNode != null)
			{
				ShipmentCharges sc = (ShipmentCharges) factory.getXPCIContainer("ShipmentCharges");
				Node transNode = getChildNode(shipmentChargesNode, XML_TransportationCharges);
				if (transNode != null)
				{
					sc.setTransportationCurrencyCode(getChildNodeValue(transNode, XML_CurrencyCode));
					sc.setTransportationValue(getChildNodeValue(transNode, XML_MonetaryValue));
				}
				Node optionNode = getChildNode(shipmentChargesNode, XML_ShipmentServiceOptions);
				if (optionNode != null)
				{
					sc.setServiceOptionsCurrencyCode(getChildNodeValue(optionNode, XML_CurrencyCode));
					sc.setServiceOptionsValue(getChildNodeValue(optionNode, XML_MonetaryValue));
				}
				Node handNode = getChildNode(shipmentChargesNode, XML_HandlingCharges);
				if (handNode != null)
				{
					sc.setHandlingChargeCurrencyCode(getChildNodeValue(handNode, XML_CurrencyCode));
					sc.setHandlingChargeValue(getChildNodeValue(handNode, XML_MonetaryValue));
				}
				Node totalNode = getChildNode(shipmentChargesNode, XML_TotalCharges);
				if (totalNode != null)
				{
					sc.setTotalCurrencyCode(getChildNodeValue(totalNode, XML_CurrencyCode));
					sc.setTotalValue(getChildNodeValue(totalNode, XML_MonetaryValue));
				}
				sr.setShipmentCharges(sc);
			}
			sr.setDeliveryZone(getChildNodeValue(shipmentResult, XML_DeliveryZone));
			Node packageResult = null;
			Vector packVec = new Vector();
			for (packageResult = getChildNode(shipmentResult, XML_PackageResults); packageResult != null; packageResult = packageResult.getNextSibling())
			{
				if (packageResult.getNodeName().equals(XML_PackageResults))
				{
					PackageResult packRes = (PackageResult) factory.getXPCIContainer("PackageResult");
					packRes.setTrackingNumber(getChildNodeValue(packageResult, XML_TrackingNumber));
					packRes.setOversizePackage(getChildNodeValue(packageResult, XML_OversizePackage));
					Node transPNode = getChildNode(shipmentChargesNode, XML_TransportationCharges);
					if (transPNode != null)
					{
						packRes.setTransportationCurrencyCode(getChildNodeValue(transPNode, XML_CurrencyCode));
						packRes.setTransportationValue(getChildNodeValue(transPNode, XML_MonetaryValue));
					}
					Node optionPNode = getChildNode(shipmentChargesNode, XML_ShipmentServiceOptions);
					if (optionPNode != null)
					{
						packRes.setServiceOptionsCurrencyCode(getChildNodeValue(optionPNode, XML_CurrencyCode));
						packRes.setServiceOptionsValue(getChildNodeValue(optionPNode, XML_MonetaryValue));
					}
					Node handPNode = getChildNode(shipmentChargesNode, XML_HandlingCharges);
					if (handPNode != null)
					{
						packRes.setHandlingChargeCurrencyCode(getChildNodeValue(handPNode, XML_CurrencyCode));
						packRes.setHandlingChargeValue(getChildNodeValue(handPNode, XML_MonetaryValue));
					}
					Node totalPNode = getChildNode(shipmentChargesNode, XML_TotalCharges);
					if (totalPNode != null)
					{
						packRes.setTotalPackageCurrencyCode(getChildNodeValue(totalPNode, XML_CurrencyCode));
						packRes.setTotalPackageValue(getChildNodeValue(totalPNode, XML_MonetaryValue));
					}
					Node im = getChildNode(packageResult, XML_LabelImage);
					if (im != null)
					{
						LabelImage li = (LabelImage) factory.getXPCIContainer("LabelImage");
						li.setGraphicImage(getChildNodeValue(im, XML_GraphicImage));
						li.setHTMLImage(getChildNodeValue(im, XML_HTMLImage));
						Node imf = getChildNode(im, XML_LabelImageFormat);
						if (imf != null)
						{
							li.setImageFormatCode(getChildNodeValue(imf, XML_Code));
							li.setImageFormatDesc(getChildNodeValue(imf, XML_Description));
						}
						packRes.setLabel(li);
					}
					packVec.addElement(packRes);
				}
			}
			sr.setPackageResults(packVec);
		}
		sar.setShipmentResults(sr);
		servRespCont = sar;
	} catch (Exception e)
	{
		String errMsg = e.getClass().getName() + ": " + e.getMessage();
		throw new SDKException(errMsg, SDKException.XML_PROCESSING_ERROR);
	}
}
/**
 * 
 * 
 * 
 * @param xmlIn java.lang.StringBuffer
 * @exception com.ups.xml.util.SDKException The exception description.
 */
private void parseConfirmDocument(StringBuffer xmlIn) throws Exception
{
	try
	{
		ShipmentConfirmResponse scr = (ShipmentConfirmResponse) factory.getServiceContainer("com.ups.xmlsdk.shipping.ShipmentConfirmResponse");
		Document doc = getDocument(xmlIn.toString());
		org.w3c.dom.Node root = doc.getFirstChild();
		// get reponse
		buildResponse(root);
		scr.setResponse(servRespCont.getResponse());

		// walk and retrieve the data
		scr.setShipmentDigest(getChildNodeValue(root, XML_ShipmentDigest));
		scr.setShipmentID(getChildNodeValue(root, XML_ShipmentIdentificationNumber));
		Node billingNode = getChildNode(root, XML_BillingWeight);
		if (billingNode != null)
		{
			BillingWeight billingWeight = (BillingWeight) factory.getXPCIContainer("BillingWeight");
			billingWeight.setWeight(getChildNodeValue(billingNode, XML_Weight));
			Node UOM = getChildNode(billingNode, XML_UnitOfMeasurement);
			if (UOM != null)
			{
				UnitOfMeasurement uom = (UnitOfMeasurement) factory.getXPCIContainer("UnitOfMeasurement");
				uom.setCode(getChildNodeValue(UOM, XML_Code));
				uom.setValue(getChildNodeValue(UOM, XML_Value));
				billingWeight.setUnitOfMeasurement(uom);
			}
			scr.setBillingWeight(billingWeight);
		}
		Node shipmentChargesNode = getChildNode(root, XML_ShipmentCharges);
		if (shipmentChargesNode != null)
		{
			ShipmentCharges sc = (ShipmentCharges) factory.getXPCIContainer("ShipmentCharges");
			Node transNode = getChildNode(shipmentChargesNode, XML_TransportationCharges);
			if (transNode != null)
			{
				sc.setTransportationCurrencyCode(getChildNodeValue(transNode, XML_CurrencyCode));
				sc.setTransportationValue(getChildNodeValue(transNode, XML_MonetaryValue));
			}
			Node optionNode = getChildNode(shipmentChargesNode, XML_ShipmentServiceOptions);
			if (optionNode != null)
			{
				sc.setServiceOptionsCurrencyCode(getChildNodeValue(optionNode, XML_CurrencyCode));
				sc.setServiceOptionsValue(getChildNodeValue(optionNode, XML_MonetaryValue));
			}
			Node handNode = getChildNode(shipmentChargesNode, XML_HandlingCharges);
			if (handNode != null)
			{
				sc.setHandlingChargeCurrencyCode(getChildNodeValue(handNode, XML_CurrencyCode));
				sc.setHandlingChargeValue(getChildNodeValue(handNode, XML_MonetaryValue));
			}
			Node totalNode = getChildNode(shipmentChargesNode, XML_TotalCharges);
			if (totalNode != null)
			{
				sc.setTotalCurrencyCode(getChildNodeValue(totalNode, XML_CurrencyCode));
				sc.setTotalValue(getChildNodeValue(totalNode, XML_MonetaryValue));
			}
			scr.setShipmentCharges(sc);
		}
		servRespCont = scr;
	} catch (Exception e)
	{
		String errMsg = e.getClass().getName() + ": " + e.getMessage();
		throw new SDKException(errMsg, SDKException.XML_PROCESSING_ERROR);
	}
}
}
