package com.ups.xmlsdk.servlet;

/*
**
** The use, disclosure, reproduction, modification, transfer, or transmittal
** of this work for any purpose in any form or by any means without the
** written permission of United Parcel Service is strictly prohibited.
**
** Confidential, Unpublished Property of United Parcel Service.
** Use and Distribution Limited Solely to Authorized Personnel.
**
** Copyright 1997,1998 United Parcel Service of America, Inc.  All Rights Reserved.
**
**
** File        : HandyShip.java
** 
**
** Class      : HandyShip
**
**
** Description : The HandyShip class is a prototypical shipping client it is not exhaustively tested
**               or idealy robust, it works.
**
** Notes       : 
**
**
** Usage       : Prototype Shipping Client
**
*/

import java.sql.*;
import java.io.*;
import java.lang.*;
import java.net.*;
import java.util.*;
import java.util.Date;
import java.text.*;
import javax.servlet.http.*;
import javax.servlet.*;

// import sdk
import com.ups.xmlsdk.*;
import com.ups.xmlsdk.xpci.*;
import com.ups.xmlsdk.xpci.LabelSpecification;
import com.ups.xmlsdk.xpci.Error;
import com.ups.xmlsdk.shipping.*;
import com.ups.xmlsdk.tracking.*;
import com.ups.xmlsdk.rating.*;
import com.ups.xmlsdk.util.MarkUp;

/*
 *
 *
 *
 */
public class HandyShip extends HttpServlet
{
	//servlet related variables
	HttpServletResponse response;
	HttpServletRequest request;
	private PrintWriter out;

	// sdk variables
	SDKFactory factory;
	private java.sql.Connection connection;
/**
 * 
 * 
 * 
 * @return java.lang.String
 * @param pageName java.lang.String
 */
private String applyHtmlFooter()
{
	StringBuffer sb = new StringBuffer();
	sb.append("</BODY>");
	sb.append("</HTML>");
	return sb.toString();
}
/**
 * 
 * 
 * 
 * @return java.lang.String
 * @param pageName java.lang.String
 */
private String applyHtmlHeader(String pageName)
{
	StringBuffer sb = new StringBuffer();
	sb.append("<HTML>");
	sb.append("<TITLE>HandyShip | " + pageName + "</TITLE>");
	sb.append("<BODY BGCOLOR=\"#FFFFCC\" TEXT=\"#333333\" LINK=\"#0033CC\" ALINK=\"#3399FF\" VLINK=\"#990000\" >");
	sb.append("<TABLE>");
	sb.append("<TR><TD><IMG SRC=\"/_images/ups_logo.gif\"></TD><TD><IMG SRC=\"/_images/ups_banner.gif\"></TD></TR>");
	sb.append("</TABLE>");
	sb.append("<TABLE>");
	sb.append("<TR><TD ALIGN=center><A href=/servlet/HandyShip?Page=Shipping>Shipping</A></TD><TD ALIGN=Left><A href=/servlet/HandyShip?Page=Rating>Rating</A></TD><TD ALIGN=Left><A href=/servlet/HandyShip?Page=Tracking>Tracking</A></TD></TR>");
	sb.append("</TABLE>");
	return sb.toString();
}
/**
 * 
 * 
 * 
 * @return java.lang.String
 */
private String applyShipmentInfoForm(HttpSession session, String pageFrom) throws SQLException
{
	StringBuffer sb = new StringBuffer();

	// Form Begin
	sb.append("<FORM ACTION=\"/servlet/HandyShip/\" METHOD=POST>");
	String name = "";
	String company = "";
	String phone = "";
	String fax = "";
	String street = "";
	String city = "";
	String state = "";
	String zip = "";
	String userName = (String) session.getValue("login.isDone");
	try
	{
		// display users profile for use as shipfrom

		Statement stmt = connection.createStatement();
		ResultSet rs = stmt.executeQuery("SELECT * FROM Users WHERE UserId = \'" + userName + "\'");
		rs.next();
		name = rs.getString("Name");
		company = rs.getString("Company");
		phone = rs.getString("Phone");
		fax = rs.getString("Fax");
		street = rs.getString("Street");
		city = rs.getString("City");
		state = rs.getString("State");
		zip = rs.getString("Zip");
	} catch (SQLException sql)
	{
		System.out.println("applyShipmentInfo -> " + sql.getMessage());
		throw sql;
	}
	sb.append("<TABLE WIDTH=300>");
	sb.append("<TR><TD><B>" + userName + ":</B></TD><TD>&nbsp;</TD><TD>&nbsp;</TD></TR>");
	sb.append("<TR><TD><I>Name:</I></TD><TD>" + name + "</TD><TD>&nbsp;</TD></TR>");
	sb.append("<TR><TD><I>Company Name:</I></TD><TD COLSPAN=2>" + company + "</TD><TD>&nbsp;</TD></TR>");
	sb.append("<TR><TD><I>Phone Number:</I></TD><TD COLSPAN=2>" + phone + "</TD><TD>&nbsp;</TD></TR>");
	sb.append("<TR><TD><I>Fax Number:</I></TD><TD COLSPAN=2>" + fax + "</TD><TD>&nbsp;</TD></TR>");
	sb.append("<TR><TD><I>Address:</I></TD><TD COLSPAN=2>" + street + "</TD><TD>&nbsp;</TD></TR>");
	sb.append("<TR><TD>&nbsp;</TD><TD COLSPAN=2>" + city + ", " + state + " " + zip + "</TD><TD>&nbsp;</TD></TR>");
	sb.append("<TR><TD COLSPAN=3><I>Use Above Information for ShipFrom?</I><INPUT TYPE=checkbox NAME=useShipFrom></TD><TD>&nbsp;</TD><TD>&nbsp;</TD></TR>");
	sb.append("</TABLE>");

	// format outer table	
	sb.append("<TABLE WIDTH=600><TR><TD WIDTH=50%>");
	// get the shipFrom

	sb.append("<TABLE>");
	sb.append("<TR><TD><B>ShipFrom:</B></TD></TR>");
	sb.append("<TR><TD>Name</TD><TD><INPUT TYPE=TEXT NAME=ShipFromName></TD></TR>");
	sb.append("<TR><TD>Phone</TD><TD><INPUT TYPE=TEXT NAME=ShiFromPhone></TD></TR>");
	sb.append("<TR><TD>Address Line 1</TD><TD><INPUT TYPE=TEXT NAME=ShipFromLine1></TD></TR>");
	sb.append("<TR><TD>Address Line 2</TD><TD><INPUT TYPE=TEXT NAME=ShipFromLine2></TD></TR>");
	sb.append("<TR><TD>City</TD><TD><INPUT TYPE=TEXT NAME=ShipFromCity></TD></TR>");
	sb.append("<TR><TD>State</TD><TD><INPUT TYPE=TEXT NAME=ShipFromState></TD></TR>");
	sb.append("<TR><TD>Zip</TD><TD><INPUT TYPE=TEXT NAME=ShipFromZip></TD></TR>");
	sb.append("</TABLE></TD><TD WIDTH=50%>");

	// get consignee
	sb.append("<TABLE>");
	sb.append("<TR><TD><B>Ship To:</B></TD></TR>");
	sb.append("<TR><TD>Name</TD><TD><INPUT TYPE=TEXT NAME=ShipToName></TD></TR>");
	sb.append("<TR><TD>Phone</TD><TD><INPUT TYPE=TEXT NAME=ShipToPhone></TD></TR>");
	sb.append("<TR><TD>Address Line 1</TD><TD><INPUT TYPE=TEXT NAME=ShipToLine1></TD></TR>");
	sb.append("<TR><TD>Address Line 2</TD><TD><INPUT TYPE=TEXT NAME=ShipToLine2></TD></TR>");
	sb.append("<TR><TD>City</TD><TD><INPUT TYPE=TEXT NAME=ShipToCity></TD></TR>");
	sb.append("<TR><TD>State</TD><TD><INPUT TYPE=TEXT NAME=ShipToState></TD></TR>");
	sb.append("<TR><TD>Zip</TD><TD><INPUT TYPE=TEXT NAME=ShipToZip></TD></TR>");
	sb.append("<TR><TD>&nbsp;</TD></TR>");
	sb.append("</TABLE></TD></TR>");
	sb.append("</TABLE>");

	// service and package
	sb.append("<TABLE WIDTH=600><TR><TD WIDTH=50%>");
	sb.append("<TABLE>");
	sb.append("<TR><TD><B>Packages:</B></TD></TR>");
	for (int i = 1; i < 6; i++)
	{
		sb.append("<TR><TD ALIGN=left><B>" + i + "</B></TD><TD>&nbsp;</TD></TR>");
		sb.append("<TR><TD>Type</TD><TD><SELECT NAME=PackageType" + i + "><OPTION>02</OPTION><OPTION>01</OPTION><OPTION>03</OPTION><OPTION>04</OPTION></SELECT></TD></TR>");
		sb.append("<TR><TD>Weight</TD><TD><INPUT TYPE=TEXT NAME=PackageWeight" + i + "></TD></TR>");
		sb.append("<TR><TD>Description</TD><TD><INPUT TYPE=TEXT NAME=PackageDesc" + i + "></TD></TR>");
	}
	sb.append("</TABLE></TD><TD WIDTH=50%>");
	sb.append("<TABLE>");
	sb.append("<TR><TD><B>Service:</B></TD></TR>");
	sb.append("<TR><TD><SELECT NAME=ServiceType><OPTION>03</OPTION><OPTION>01</OPTION><OPTION>02</OPTION></SELECT></TD></TR>");
	sb.append("<TR><TD>&nbsp;</TD></TR>");
	sb.append("</TABLE></TD></TR>");
	sb.append("</TABLE>");
	sb.append("<TABLE>");
	// submit control
	sb.append("<TR><TD>&nbsp;</TD></TR>");
	sb.append("<TR><TD>&nbsp;</TD><TD>&nbsp;</TD><TD>&nbsp;</TD><TD>&nbsp;</TD><TD><INPUT TYPE=submit VALUE=\" SUBMIT \"></TD></TR>");
	sb.append("</TABLE>");
	sb.append("<INPUT TYPE=hidden NAME=Page VALUE=\"" + pageFrom + "\">");
	sb.append("</FORM>");
	return sb.toString();
}
/**
 * 
 * 
 * 
 * @return boolean
 * @param userid java.lang.String
 * @param password java.lang.String
 */
private boolean authenticate(String userid, String password)
{
	try
	{
		boolean val = false;
		// check for userid
		Statement stmt = connection.createStatement();
		ResultSet rs = stmt.executeQuery("SELECT * from Users WHERE UserId = \'" + userid + "\' AND Password = \'" + password + "\'");
		rs.next();
		if (rs.getString("UserId").equalsIgnoreCase(userid) && rs.getString("Password").equalsIgnoreCase(password))
		{
			rs.close();
			val = true;
		}
		return val;
	} catch (Exception e)
	{
		System.out.println("Exception Occured in authenticate()" + e.getMessage());
		return false;
	}
}
/**
 * 
 * 
 * 
 * @return com.ups.xmlsdk.xpci.Agent
 */
private Agent buildShipper()
{
	Agent shipper = new Agent();
	shipper.setName("Bubba Forester");
	shipper.setAttentionName("Bubba");
	shipper.setCompanyName("Bubba's Auto Bonding");
	shipper.setShipperNumber("F00100");
	Vector phoneVec = new Vector();
	StructuredPhoneNumber phone = new StructuredPhoneNumber();
	phone.setPhoneLineNumber("6785851172");
	phone.setPhoneExtension("");
	phone.setPhoneDialPlanNumber("");
	phoneVec.addElement(phone);
	shipper.setPhoneNumber(phoneVec);
	Vector faxVec = new Vector();
	StructuredPhoneNumber fax = new StructuredPhoneNumber();
	fax.setPhoneLineNumber("6785851178");
	phone.setPhoneExtension("");
	phone.setPhoneDialPlanNumber("");
	faxVec.addElement(fax);
	shipper.setFaxNumber(faxVec);
	Address add = new Address();
	add.setAddressLine1("1000 Mansell Road");
	add.setCity("Roswell");
	add.setStateProvinceCode("GA");
	add.setPostalCode("30078");
	add.setCountryCode("US");
	shipper.setAddress(add);
	return shipper;
}
/**
 * 
 * 
 * 
 * @param res javax.servlet.http.HttpServletResponse
 */
private void displayAuthenticatedScreen(HttpServletResponse res, String type)
{
	try
	{
		out = res.getWriter();
		if (type.equals("Register"))
		{
			out.println("<head><title>HandyShip | Registration Completed</title><meta name=\"robots content=\"noindex\"><meta http-equiv=\"refresh\" content=\"15;");
			out.println(" url=<a href=\"/servlet/HandyShip/\">\"<http://servlet/HandyShip\"></a>");
			out.println("</head>");
			out.println("<BODY BGCOLOR=\"#FFFFCC\" TEXT=\"#333333\" LINK=\"#0033CC\" ALINK=\"#3399FF\" VLINK=\"#990000\" >");
			out.println("<STRONG>Please Login to use the services</STRONG>");
			out.println("<BR><BR>Login will load in 15 seconds...");
			out.println("or Click <A HREF=\"/servlet/HandyShip\">Here</A>");
		}
		if (type.equals("Login"))
		{
			out.println(applyHtmlHeader("Login Authenticated"));
			out.println("<BR>");
			out.println("<FONT SIZE=+1>Welcome to the easy world of Shipping!</FONT>");

			// get welcome messages
			Statement stmt = connection.createStatement();
			int day = (new Date()).getDay();
			ResultSet rs = stmt.executeQuery("SELECT * FROM Messages WHERE ID = " + day);
			rs.next();
			out.println("<BR><FONT SIZE=+2><B>Message of the Day:</B><BR></FONT>");
			out.println("<BR><BR><FONT ALIGN=Center SIZE=+1>" + rs.getString("Message") + "</FONT>");
			out.println("<BR><BR>");
			// info stuff
			out.println("Select a service you wish to use");
		}
		out.println(applyHtmlFooter());
	} catch (Exception e)
	{
		System.out.println("displayAuthenticatedScreen -> Exception Occured" + e.getMessage());
		displayInitialScreenWithError(res, "Exception during Authentication!");
	}
}
/**
 * 
 * 
 * 
 */
private void displayInitialScreen(HttpServletResponse response)
{
	out.println(applyHtmlHeader("Authentication"));
	out.println("<A><FONT SIZE=+1><B>Welcome to HandyShip your eveything in XML Tools !</FONT></B></A>");
	out.println("<BR><BR>");
	out.println("Please provide your HandyShip access information to use one of the Services.");
	out.println("<P><FORM ACTION=\"/servlet/HandyShip/\" METHOD=POST><TABLE>");
	out.println("<TR><TD>User Name:</TD><TD><INPUT TYPE=text NAME=UserId></TD></TR>");
	out.println("<TR><TD>Password:</TD><TD><INPUT TYPE=password NAME=Password></TD></TR>");
	out.println("<TR><TD>&nbsp;</TD><TD ALIGN=Right><INPUT TYPE=submit VALUE=\" LOGIN \"></TD></TR>");
	out.println("<TR><TD><A HREF=\"/servlet/HandyShip?Page=Register\">New User?</A></TD><TD>&nbsp;</TD></TR>");
	out.println("</TABLE>");
	out.println("<INPUT TYPE=hidden NAME=Page VALUE=\"Initial\">");
	out.println("</FORM></P>");
	out.println(applyHtmlFooter());
}
/**
 * 
 * 
 * 
 */
private void displayInitialScreenWithError(HttpServletResponse response, String message)
{
	try
	{
		out = response.getWriter();
		out.println(applyHtmlHeader("Authentication"));
		out.println("<A><FONT SIZE=+1><B>Welcome to HandyShip your eveything in XML Tools !</FONT></B></A>");
		out.println("<BR><BR>");
		out.println("Please provide your HandyShip access information to use one of the Services.");
		out.println("<BR><FONT COLOR=Red SIZE=+1>" + message + "</FONT><BR>");
		out.println("<P><FORM ACTION=\"/servlet/HandyShip\" METHOD=POST><TABLE>");
		out.println("<TR><TD>User Name:</TD><TD><INPUT TYPE=text NAME=UserId></TD></TR>");
		out.println("<TR><TD>Password:</TD><TD><INPUT TYPE=password NAME=Password></TD></TR>");
		out.println("<TR><TD>&nbsp;</TD><TD ALIGN=Right><INPUT TYPE=submit VALUE=\" LOGIN \"></TD></TR>");
		out.println("<TR><TD><A HREF=\"/servlet/HandyShip?Page=Register\">New User?</A></TD><TD>&nbsp;</TD></TR>");
		out.println("</TABLE>");
		out.println("<INPUT TYPE=hidden NAME=Page VALUE=\"Initial\">");
		out.println("</FORM></P>");
		out.println(applyHtmlFooter());
	} catch (Exception e)
	{
		System.out.println("Ooops!");
	}
}
/**
 * 
 * 
 * 
 */
private void displayRateRequest(HttpServletRequest req, HttpServletResponse response)
{
	try
	{
		out = response.getWriter();
		out.println(applyHtmlHeader("Rating Information"));
		out.println("<FONT SIZE=+3>Rating is not currently Enabled</FONT>");
		out.println(applyShipmentInfoForm(req.getSession(true), "RatingRequest"));
		out.println(applyHtmlFooter());
	} catch (Exception e)
	{
	}
}
/**
 * 
 * 
 * 
 * @param res javax.servlet.http.HttpServletResponse
 */
private void displayRegistrationPage(HttpServletResponse res, String message)
{
	out.println("<HTML>");
	out.println("<TITLE>HandyShip | Registration Information</TITLE>");
	out.println("<BODY BGCOLOR=\"#FFFFCC\" TEXT=\"#333333\" LINK=\"#0033CC\" ALINK=\"#3399FF\" VLINK=\"#990000\" >");
	out.println("<TABLE>");
	out.println("<TR><TD><IMG SRC=\"/_images/ups_logo.gif\"></TD><TD><IMG SRC=\"/_images/ups_banner.gif\"></TD></TR>");
	out.println("</TABLE>");
	out.println("<A><FONT SIZE=+1><B>Please enter your information and press Register.</FONT></B></A>");
	if (message != null)
		out.println("<FONT SIZE=+1 COLOR=red>" + message + "</FONT>");
	out.println("<BR><BR>");
	out.println("Please provide your HandyShip access information to use one of the Services.");
	out.println("<P><FORM ACTION=\"/servlet/HandyShip/\" METHOD=POST><TABLE>");
	out.println("<TR><TD>Name:</TD><TD><INPUT TYPE=text NAME=Name></TD></TR>");
	out.println("<TR><TD>Company Name:</TD><TD><INPUT TYPE=text NAME=Company></TD></TR>");
	out.println("<TR><TD>Phone:</TD><TD><INPUT TYPE=text NAME=Phone></TD></TR>");
	out.println("<TR><TD>Fax:</TD><TD><INPUT TYPE=text NAME=Fax></TD></TR>");
	out.println("<TR><TD>Street:</TD><TD><INPUT TYPE=text NAME=Street></TD></TR>");
	out.println("<TR><TD>City:</TD><TD><INPUT TYPE=text NAME=City></TD></TR>");
	out.println("<TR><TD>State:</TD><TD><INPUT TYPE=text NAME=State></TD></TR>");
	out.println("<TR><TD>Zip Code:</TD><TD><INPUT TYPE=text NAME=Zip></TD></TR>");
	out.println("</TABLE><BR><BR><TABLE>");
	out.println("<TR><TD COLSPAN=2>Please provide a Userid and password combination:</TD></TR>");
	out.println("<TR><TD>User Name:</TD><TD><INPUT TYPE=text NAME=UserId></TD></TR>");
	out.println("<TR><TD>Password:</TD><TD><INPUT TYPE=password NAME=Password></TD></TR>");
	out.println("<TR><TD> Re-Type Password:</TD><TD><INPUT TYPE=password NAME=secPassword></TD></TR>");
	out.println("<TR><TD>&nbsp;</TD><TD ALIGN=center><INPUT TYPE=submit VALUE=\" REGISTER \"></TD></TR>");
	out.println("</TABLE>");
	out.println("<INPUT TYPE=hidden NAME=Page VALUE=\"Register\">");
	out.println("</FORM></P>");
	out.println(applyHtmlFooter());
}
/**
 * 
 * 
 * 
 * @param res javax.servlet.http.HttpServletResponse
 * @param serResp com.ups.xmlsdk.ServiceResponse
 */
private void displayShipAcceptResponse(HttpServletResponse res, ServiceResponse serResp)
{
	try
	{
		ShipmentAcceptResponse sar = (ShipmentAcceptResponse) serResp.getContent();
		out = res.getWriter();
		Response resp = sar.getResponse();
		out.println(applyHtmlHeader("Shipment is complete"));
		out.println("<FONT SIZE=+3>ShipmentAcceptResponse</FONT>");
		out.println("<BR><FONT SIZE=+1><I>Status is " + sar.getResponse().getResponseStatusDescription() + "</I></FONT>");
		if (resp.getResponseStatusDescription().equalsIgnoreCase("success"))
		{
			ShipmentResults sr = sar.getShipmentResults();
			ShipmentCharges sc = sr.getShipmentCharges();
			BillingWeight bw = sr.getBillingWeight();
			String shipID = sr.getShipmentIdentificationNumber();
			out.println("<BR><STRONG>Shipment:</STRONG>");
			out.println("<BR>Shipment Identification Number &nbsp;&nbsp;&nbsp;" + shipID);
			out.println("<BR>Shipment Charges = " + sc.getTotalValue());
			out.println("<TABLE>");
			out.println("<TR><TD><B><I>Packages:</B></I></TD><TD>&nbsp;</TD><TD>&nbsp;</TD></TR>");
			// packages enumeration
			Enumeration packEnum = sr.getPackageResults().elements();
			String directory = "D:\\IBMVJava\\IDE\\project_resources\\IBM WebSphere Test Environment\\hosts\\default_host\\default_app\\web\\_labels\\";
			int i = 1;
			while (packEnum.hasMoreElements())
			{
				PackageResult prs = (PackageResult) packEnum.nextElement();
				String packTrack = prs.getTrackingNumber();
				out.println("<TR><TD>" + i + "</TD><TD>" + packTrack + "</TD><TD><A HREF=\\_labels\\" + packTrack + ".html TARGET=_blank>View Label</A></TD></TR>");
				LabelImage li = prs.getLabel();
				String gifString = li.getGraphicImage();
				String htmlString = li.getHTMLImage();
				byte[] gifimage = MarkUp.base64Decode(gifString.getBytes());
				byte[] html = MarkUp.base64Decode(htmlString.getBytes());
				if (html != null)
				{
					FileOutputStream fileOut = new FileOutputStream(new String(directory + packTrack + ".html"));
					fileOut.write(html);
				}
				if (gifimage != null)
				{
					FileOutputStream gifOut = new FileOutputStream(new String(directory + "label" + packTrack + ".gif"));
					gifOut.write(gifimage);
				}
				i++;
			}
			out.println("</TABLE>");
		} else
		{
			Enumeration errEnum = resp.getError().elements();
			while (errEnum.hasMoreElements())
			{
				Error err = (Error) errEnum.nextElement();
				out.println("<BR>Error Code = " + err.getErrorCode());
				out.println("<BR>Error Description = " + err.getErrorDescription());
				Enumeration digEnum = err.getErrorDigest().elements();
				while (digEnum.hasMoreElements())
				{
					out.println("<BR>Digest = " + (String) digEnum.nextElement());
				}
				Enumeration locEnum = err.getErrorLocation().elements();
				while (locEnum.hasMoreElements())
				{
					ErrorLocation errLoc = (ErrorLocation) locEnum.nextElement();
					out.println("<BR>Location of Element = " + errLoc.getErrorLocationElementName());
				}
			}
			out.println("<BR><FONT SIZE = +1 COLOR = Red> Please go back correct this and try again </FONT>");
		}
		out.println(applyHtmlFooter());
	} catch (Exception e)
	{
		displayShippingErrorScreen(res, " displayAcceptResponse " + e.getMessage());
	}
}
/**
 * 
 * 
 * 
 */
private void displayShipConfirmRequest(HttpServletRequest req, HttpServletResponse response)
{
	try
	{
		out = response.getWriter();
		response.setContentType("text/html");
		out.println(applyHtmlHeader("Shipment Information"));
		out.println("<FONT SIZE=+1>Enter your shipping data and select the Submit button:</FONT>");
		out.println(applyShipmentInfoForm(req.getSession(true), "ShipConfirmRequest"));
		out.println(applyHtmlFooter());
	} catch (Exception e)
	{
		displayShippingErrorScreen(response, e.getMessage());
	}
}
/**
 * 
 * 
 * 
 * @param res javax.servlet.http.HttpServletResponse
 * @param serResp com.ups.xmlsdk.ServiceResponse
 */
private void displayShipConfirmResponse(HttpServletResponse res, ServiceResponse serResp)
{
	try
	{
		ShipmentConfirmResponse scr = (ShipmentConfirmResponse) serResp.getContent();
		out = res.getWriter();
		Response resp = scr.getResponse();
		out.println(applyHtmlHeader("Shipment Charges and Digest -- do you Agree?"));
		out.println("<FONT SIZE=+3>ShipmentConfirmResponse</FONT>");
		out.println("<BR>Status is " + scr.getResponse().getResponseStatusDescription());
		out.println("<BR><FORM ACTION=\"/servlet/HandyShip/\" METHOD=POST>");
		out.println("<INPUT TYPE=hidden NAME=Page VALUE=\"ShipConfirmResponse\">");
		if (resp.getResponseStatusDescription().equalsIgnoreCase("success"))
		{
			ShipmentCharges sc = scr.getShipmentCharges();
			out.println("Shipment Charges= " + sc.getTotalValue());
			out.println("<INPUT TYPE=hidden NAME=Digest VALUE=" + scr.getShipmentDigest() + ">");
			out.println("<BR><INPUT TYPE=submit VALUE=\" Looks Good! \">");
		} else
		{
			Enumeration errEnum = resp.getError().elements();
			while (errEnum.hasMoreElements())
			{
				Error err = (Error) errEnum.nextElement();
				out.println("<BR> Error Code= " + err.getErrorCode());
				out.println("<BR> Error Description= " + err.getErrorDescription());
				Enumeration digEnum = err.getErrorDigest().elements();
				while (digEnum.hasMoreElements())
				{
					out.println("<BR> Digest= " + (String) digEnum.nextElement());
				}
				Enumeration locEnum = err.getErrorLocation().elements();
				while (locEnum.hasMoreElements())
				{
					ErrorLocation errLoc = (ErrorLocation) locEnum.nextElement();
					out.println("<BR> Location of Element= " + errLoc.getErrorLocationElementName());
				}
			}
			out.println("<BR><FONT SIZE=+1 COLOR=Red>Please go back correct this and try again</FONT>");
		}
		out.println("</FORM>");
		out.println(applyHtmlFooter());
	} catch (Exception e)
	{
		displayShippingErrorScreen(res, "displayConfirmRespnse " + e.getMessage());
	}
}
/**
 * 
 * 
 * 
 * @param res javax.servlet.http.HttpServletResponse
 */
private void displayShippingErrorScreen(HttpServletResponse res, String message)
{
	try
	{
		out = res.getWriter();
		out.println(applyHtmlHeader(message));
		out.println("<FONT SIZE=+2 COLOR=BLACK>" + message + "</FONT><BR><BR>");
		out.println("<FONT SIZE=+1>The Party Crashes!</FONT>");
		out.println(applyHtmlFooter());
	} catch (Exception e)
	{
		System.out.println("displayAuthenticatedScreen -> Exception Occured" + e.getMessage());
	}
}
/**
 * 
 * 
 * 
 * @param res javax.servlet.http.HttpServletResponse
 * @param message java.lang.String
 */
private void displayTrackingErrorScreen(HttpServletResponse res, String message) {}
/**
 * 
 * 
 * 
 */
private void displayTrackRequest(HttpServletRequest request, HttpServletResponse response)
{
	try
	{
		out = response.getWriter();
		out.println(applyHtmlHeader("Tracking Information"));
		out.println("<FONT SIZE=+3>Tracking is now Enabled!</FONT>");
		out.println("<TABLE WIDTH=\"420\">");
		out.println("<TR><TD>Date Shipped:</TD><TD>Shipment ID:</TD><TD>&nbsp;</TD></TR>");
		Statement stmt = connection.createStatement();
		String user = (String) request.getSession(true).getValue("login.isDone");
		ResultSet rs = stmt.executeQuery("SELECT * FROM Shipments WHERE UserID = '" + user + "'");
		while (rs.next())
		{
			out.println("<FORM ACTION=\"/servlet/HandyShip/\" METHOD=Post>");
			String shipID = rs.getString("ShipmentID");
			out.println("<TR><TD>" + rs.getString("Date") + "</TD><TD><INPUT TYPE=hidden NAME=Shipment VALUE=" + shipID + ">" + shipID + "</TD><TD><INPUT TYPE=submit VALUE=\" Track Me? \"></TD></TR>");
			out.println("</FORM>");
		}
		out.println("</TABLE>");
		out.println("<BR><BR>");
		out.println("<TABLE WIDTH=\"420\">");
		out.println("<FORM METHOD=Post ACTION=\"/servlet/HandyShip/\">");
		out.println("<TR><TD>Enter another Tracking Number:</TD><TD><INPUT TYPE=hidden NAME=type VALUE=\"TrackingNumber\"></TD></TR>");
		out.println("<TR><TD><INPUT TYPE=text NAME=TrackNum><TD></TD><INPUT TYPE=submit VALUE=\" Track It \"></TD></TR>");
		out.println("</FORM>");
		out.println("</TABLE>");
		out.println(applyHtmlFooter());
	} catch (Exception e)
	{
		displayTrackingErrorScreen(response, e.toString());
	}
}
public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
{
	this.request = request;
	this.response = response;
	response.setContentType("text/html");
	HttpSession ses = request.getSession(true);
	this.out = response.getWriter();
	try
	{
		String page = request.getParameter("Page");
		if (page != null)
		{
			if (page.equals("Register"))
			{
				displayRegistrationPage(response, null);
			} else
			{
				Object done = ses.getValue("login.isDone");
				if (done == null)
				{
					displayInitialScreenWithError(response, "You are not logged in to use " + page + "!");
				} else
				{
					if (page.equals("Shipping"))
						displayShipConfirmRequest(request, response);
					if (page.equals("Rating"))
						displayRateRequest(request, response);
					if (page.equals("Tracking"))
						displayTrackRequest(request, response);
				}
			}
		} else
		{
			displayInitialScreen(response);
		}
	} catch (Exception e)
	{
	}
}
/**
 *   Method for Post data
 */
public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
{
	// get the past page for redirection
	String page = request.getParameter("Page");

	// process Registration
	if (page.equals("Register"))
	{
		processRegistrationInformation(request, response);
	} else
	{
		// process initial Screen
		if (page.equals("Initial"))
		{
			if (authenticate(request.getParameter("UserId"), request.getParameter("Password")))
			{
				// username and password are good
				HttpSession session = request.getSession(true);
				session.putValue("login.isDone", request.getParameter("UserId"));

				// direct to authentication screen
				displayAuthenticatedScreen(response, "Login");
			} else
			{
				// redirect to initial screen with authentication message
				displayInitialScreenWithError(response, "UserId and Password Not Found!");
			}
		} else
		{



			// process secure pages
			HttpSession ses = request.getSession(true);
			Object done = ses.getValue("login.isDone");
			if (done == null)
			{
				// store the target page
				ses.putValue("login.target", HttpUtils.getRequestURL(request).toString());

				// redirect the user
				displayInitialScreenWithError(response, "Your session has expired, Please Login?");
			} else
			{
				// process Shipment Data
				if (page.equals("ShipConfirmRequest"))
				{
					processShipConfirm(request, response);
				}
				// process Acceptance
				if (page.equals("ShipConfirmResponse"))
				{
					processShipAccept(request, response);
				}
				// process Rating
				if (page.equals("RatingRequest"))
				{
					// add method for rating process
				}
				if (page.equals("TrackingRequest"))
				{
					// add method for Tracking process
				}
			}
		}
	}
}
public void init(ServletConfig config) throws ServletException
{
	try
	{
		super.init(config);
		factory = SDKFactory.getInstance();

		// initialize JDBC connection
		Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
		connection = java.sql.DriverManager.getConnection("jdbc:odbc:HandyShip");
	} catch (Exception e)
	{
		System.out.println("HandyShip Initialization error" + e.getMessage());
	}
}
/**
 * 
 * 
 * 
 * @param shipment com.ups.xmlsdk.shipping.ShipmentConfirmRequest
 */
private void processAcceptRequest(ShipmentAcceptRequest sar)
{
	Request req = new Request();
	req.setCustomerContext("HandyShipShipment");
	req.setRequestAction("ShipAccept");
	String[] options = new String[1];
	options[0] = "nonvalidate";
	req.setRequestOption(options);
	req.setXpciVersion("1.0001");
	sar.setRequest(req);
}
/**
 * 
 * 
 * 
 * @return com.ups.xmlsdk.xpci.Access
 */
private Access processAccess() throws Exception
{
	Access aa = new Access();
	aa.setLicenseNumber("9B530C154D84892C");
	aa.setPassword("antigua");
	aa.setUserId("antigua");
	return aa;
}
/**
 * 
 * 
 * 
 * @param shipment com.ups.xmlsdk.shipping.ShipmentConfirmRequest
 */
private void processConfirmRequest(ShipmentConfirmRequest scr)
{
	Request req = new Request();
	req.setCustomerContext("HandyShipShipment");
	req.setRequestAction("ShipConfirm");
	String[] options = new String[1];
	options[0] = "nonvalidate";
	req.setRequestOption(options);
	req.setXpciVersion("1.0001");
	scr.setRequest(req);
}
/**
 * 
 * 
 * 
 * @param servReq com.ups.xmlsdk.ServiceRequest
 */
private void processLabelSpecs(ShipmentConfirmRequest scr)
{
	LabelSpecification ls = new LabelSpecification();
	ls.setHttpUserAgent("Mozilla/4.5");
	ls.setImageFormatCode("GIF");
	ls.setPrintMethodCode("GIF");
	scr.setLabelSpec(ls);
}
/**
 * 
 * 
 * 
 * @param req javax.servlet.http.HttpServletRequest
 * @param res javax.servlet.http.HttpServletResponse
 */
private void processRegistrationInformation(HttpServletRequest req, HttpServletResponse res)
{
	try
	{
		Statement stmt = connection.createStatement();
		// check UserName
		ResultSet rs = stmt.executeQuery("SELECT * FROM Users WHERE UserId = \'" + req.getParameter("UserId") + "\'");
		if (rs == null)
			displayRegistrationPage(res, "UserId is already Taken, please try again?");
		// check passwords =
		if (!req.getParameter("Password").equalsIgnoreCase(req.getParameter("secPassword")))
			displayRegistrationPage(res, "Passwords do not match!");

		// update database
		StringBuffer sb = new StringBuffer();
		sb.append("\'" + req.getParameter("UserId") + "\', ");
		sb.append("\'" + req.getParameter("Password") + "\', ");
		sb.append("\'" + req.getParameter("Name") + "\', ");
		sb.append("\'" + req.getParameter("Company") + "\', ");
		sb.append("\'" + req.getParameter("Phone") + "\', ");
		sb.append("\'" + req.getParameter("Fax") + "\', ");
		sb.append("\'" + req.getParameter("Street") + "\', ");
		sb.append("\'" + req.getParameter("City") + "\', ");
		sb.append("\'" + req.getParameter("State") + "\', ");
		sb.append("\'" + req.getParameter("Zip") + "\'");
		stmt.executeUpdate("INSERT INTO Users VALUES(" + sb.toString() + ") ");

		// display results to user
		displayAuthenticatedScreen(res, "Register");
	} catch (Exception e)
	{
		System.out.println("processRegistrationInformation() -> Exception Occured" + e.getMessage());
	}
}
/**
 * 
 * 
 * 
 * @param req javax.servlet.http.HttpServletRequest
 * @param res javax.servlet.http.HttpServletResponse
 */
private void processShipAccept(HttpServletRequest req, HttpServletResponse res)
{
	try
	{
		System.out.println("In processShipAccept");
		ShipmentAcceptRequest sar = new ShipmentAcceptRequest();
		ShippingController shipController = new ShippingController(); // get a Service Controller
		ServiceRequest servReq = new ServiceRequest();
		servReq.setAccess(processAccess());

		// request
		processAcceptRequest(sar);
		// set the digest
		sar.setDigest(req.getParameter("Digest"));

		//
		servReq.setContent(sar);

		// execute()
		servReq.setType("ShipAccept");
		ServiceResponse serResp = shipController.execute(servReq);

		// insert shipment into database
		Statement stmt = connection.createStatement();
		String UserId = (String) req.getSession(true).getValue("UserId");
		ShipmentResults sr = ((ShipmentAcceptResponse) serResp.getContent()).getShipmentResults();
		String shipId = sr.getShipmentIdentificationNumber();
		int k = stmt.executeUpdate("INSERT INTO Shipments (UserID, ShipmentID) VALUES('" + UserId + "', '" + shipId + "')");

		// display response
		displayShipAcceptResponse(res, serResp);
	} catch (Exception e)
	{
		displayShippingErrorScreen(res, e.getMessage());
	}
}
/**
 * 
 * 
 * 
 * @param req javax.servlet.http.HttpServletRequest
 * @param res javax.servlet.http.HttpServletResponse
 */
private void processShipConfirm(HttpServletRequest req, HttpServletResponse res)
{
	try
	{
		System.out.println("In processShipConfirm");
		ShipmentConfirmRequest scr = new ShipmentConfirmRequest();
		System.out.println("after scr=" + scr);
		ShippingController shipController = new ShippingController(); // get a Service Controller
		ServiceRequest servReq = new ServiceRequest(); // get a serviceRequestObject
		System.out.println("servReq=" + servReq);
		// get access object
		servReq.setAccess(processAccess());
		System.out.println("after Access");
		// build and fill the Shipment Objects
		Shipment shipment = new Shipment();

		// set shipper values
		shipment.setShipper(buildShipper());

		// ShipFrom
		Agent shipFrom = new Agent();
		Vector shipFromPhoneVec = new Vector();
		StructuredPhoneNumber shipFromPhone = new StructuredPhoneNumber();
		Address shipFromAdd = new Address();
		if (req.getParameter("useShipFrom").equalsIgnoreCase("on"))
		{
			Statement stmt = connection.createStatement();
			HttpSession session = req.getSession(true);
			String userName = (String) session.getValue("login.isDone");
			ResultSet rs = stmt.executeQuery("SELECT * FROM Users WHERE UserId = \'" + userName + "\'");
			rs.next();
			shipFrom.setName(rs.getString("Name"));
			shipFromPhone.setPhoneDialPlanNumber(rs.getString("Phone").trim());
			shipFromPhone.setPhoneLineNumber("");
			shipFromPhone.setPhoneExtension("");
			shipFromAdd.setAddressLine1(rs.getString("Street"));
			shipFromAdd.setCity(rs.getString("City"));
			shipFromAdd.setStateProvinceCode(rs.getString("State"));
			shipFromAdd.setPostalCode(rs.getString("Zip"));
		} else
		{
			shipFrom.setName(req.getParameter("ShipFromName"));
			shipFromPhone.setPhoneDialPlanNumber(req.getParameter("ShipFromPhone").trim());
			shipFromPhone.setPhoneLineNumber("");
			shipFromPhone.setPhoneExtension("");
			shipFromAdd.setAddressLine1(req.getParameter("ShipFromLine1"));
			shipFromAdd.setAddressLine2(req.getParameter("ShipFromLine2"));
			shipFromAdd.setCity(req.getParameter("ShipFromCity"));
			shipFromAdd.setStateProvinceCode(req.getParameter("ShipFromState"));
			shipFromAdd.setPostalCode(req.getParameter("ShipFromZip"));
		}
		shipFromAdd.setCountryCode("US"); // us only
		shipFrom.setAddress(shipFromAdd);
		shipFromPhoneVec.addElement(shipFromPhone);
		shipFrom.setPhoneNumber(shipFromPhoneVec);

		// set the shipper object to the shipment
		shipment.setShipFrom(shipFrom);

		// Ship To
		Agent shipTo = new Agent();
		shipTo.setName(req.getParameter("ShipToName"));
		StructuredPhoneNumber toPhone = new StructuredPhoneNumber();
		toPhone.setPhoneDialPlanNumber(req.getParameter("ShipToPhone").trim());
		toPhone.setPhoneExtension("");
		toPhone.setPhoneLineNumber("");
		Vector toVec = new Vector();
		toVec.addElement(toPhone);
		shipTo.setPhoneNumber(toVec);
		Address toAdd = new Address();
		toAdd.setAddressLine1(req.getParameter("ShipToLine1"));
		toAdd.setAddressLine2(req.getParameter("ShipToLine2"));
		toAdd.setCity(req.getParameter("ShipToCity"));
		toAdd.setStateProvinceCode(req.getParameter("ShipToState"));
		toAdd.setPostalCode(req.getParameter("ShipToZip"));
		toAdd.setCountryCode("US");
		shipTo.setAddress(toAdd);

		// set the consignee
		shipment.setShipTo(shipTo);
		// Packages

		Vector packVec = new Vector();
		//1
		if (!req.getParameter("PackageWeight1").equals(""))
		{
			Package pack1 = new Package();
			pack1.setPackageWeight(req.getParameter("PackageWeight1"));
			pack1.setPackagingTypeCode(req.getParameter("PackageType1"));
			packVec.addElement(pack1);
		}
		//2
		if (!req.getParameter("PackageWeight2").equals(""))
		{
			Package pack2 = new Package();
			pack2.setPackageWeight(req.getParameter("PackageWeight2"));
			pack2.setPackagingTypeCode(req.getParameter("PackageType2"));
			packVec.addElement(pack2);
		}
		//3
		if (!req.getParameter("PackageWeight3").equals(""))
		{
			Package pack3 = new Package();
			pack3.setPackageWeight(req.getParameter("PackageWeight3"));
			pack3.setPackagingTypeCode(req.getParameter("PackageType3"));
			packVec.addElement(pack3);
		}
		//4
		if (!req.getParameter("PackageWeight4").equals(""))
		{
			Package pack4 = new Package();
			pack4.setPackageWeight(req.getParameter("PackageWeight4"));
			pack4.setPackagingTypeCode(req.getParameter("PackageType4"));
			packVec.addElement(pack4);
		}
		//5
		if (!req.getParameter("PackageWeight5").equals(""))
		{
			Package pack5 = new Package();
			pack5.setPackageWeight(req.getParameter("PackageWeight5"));
			pack5.setPackagingTypeCode(req.getParameter("PackageType5"));
			packVec.addElement(pack5);
		}
		if (packVec.isEmpty())
		{
			displayShippingErrorScreen(res, "You must supply at least one package!<BR>Go back and try again!");
		}
		// add packages to shipment
		shipment.setPackages(packVec);

		// Service
		shipment.setServiceCode(req.getParameter("ServiceType"));


		// set the payment Method
		PrepaidBillShipper pbs = new PrepaidBillShipper();
		pbs.setAccountNumber("F00100");
		shipment.setPaymentInfo(pbs);

		// complete the data objects
		scr.setShipment(shipment);

		// set Label Spec
		System.out.println("setting Label specs");
		processLabelSpecs(scr);

		// set request
		processConfirmRequest(scr);

		// set content
		System.out.println("about to setContent()");
		servReq.setContent(scr);


		// use the controller
		System.out.println("about to call execute()");
		servReq.setType("ShipConfirm");
		ServiceResponse serResp = shipController.execute(servReq);

		// display response
		displayShipConfirmResponse(res, serResp);
	} catch (Exception e)
	{
		System.out.println(e.getMessage());
		displayShippingErrorScreen(res, e.getMessage());
	}
}
/**
 * 
 * 
 * 
 * @param req javax.servlet.http.HttpServletRequest
 * @param res javax.servlet.http.HttpServletResponse
 */
private void processTracking(HttpServletRequest req, HttpServletResponse res)
{
	try
	{
		System.out.println("In processTracking");
		// get request objects
		TrackingRequest tr = new TrackingRequest();
		ServiceRequest servReq = new ServiceRequest();

		// set data elements
		processTrackRequest(tr);

		
		// Tracking number track
		tr.setType(TrackingRequest.TRACKING_NUMBER_TRACK);
		// Shipment Id Track
		tr.setType(TrackingRequest.SHIPMENT_TRACK);
		// Reference Number Track
		tr.setType(TrackingRequest.REFERENCE_TRACK);

		// set Service Request info
		servReq.setType("Track");
		servReq.setContent(tr);

		// get controller
		TrackingController tc = new TrackingController();
		tc.execute(servReq);
	} catch (Exception e)
	{
		displayTrackingErrorScreen(res, e.getMessage());
	}
}
/**
 * 
 * 
 * 
 * @param com.ups.xmlsdk.tracking.TrackingRequest
 */
private void processTrackRequest(TrackingRequest tr)
{
	Request req = new Request();
	req.setCustomerContext("HandyShipTracking");
	req.setRequestAction("Track");
	/*
	String[] options = new String[1];
	 options[0] = "nonvalidate";
	req.setRequestOption(options);
	*/
	req.setXpciVersion("1.0001");
	tr.setRequest(req);
}
}
