package com.ups.xmlsdk.row;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/
import com.ups.xmlsdk.*;
import com.ups.xmlsdk.xpci.*;
import com.ups.xmlsdk.util.*;
import com.ups.xmlsdk.util.logging.*;

/**
 * Insert the type's description here.
 * Creation date: (11/29/00 11:24:35 AM)
 * @author: James C. Bragg
 */
public class ReturnLabelController extends RequestLabelController {
	private ReturnLabelAdapter labelAdapter;
/**
 * ReturnLabelController constructor comment.
 */
public ReturnLabelController() {
	try {
		// initialize adapter
		init();
		
	} catch (Exception e){
		labelAdapter = null;
	}


}
/**
 * getReturnLabel: Purpose is to send the request object and receive the response object.
 * This is done by converting the Request object into XML and transmit it via the 
 * XmlTransmitter and then convert the XML Response from the transmitter into a response
 * object.
 * <BR><BR>Creation date: (11/30/00 9:40:49 AM)
 * @param returnLabelRequest com.ups.xmlsdk.row.ReturnLabelRequest
 * @return com.ups.xmlsdk.row.ReturnLabelResponse
 * @exception java.lang.Exception The exception description.
 * @exception com.ups.xmlsdk.util.SDKException The exception description.
 */
public ReturnLabelResponse execute(ReturnLabelRequest returnLabelRequest) throws java.lang.Exception, com.ups.xmlsdk.util.SDKException {
	
	// create Request XML document (StringBuffer)
	StringBuffer xmlBuff = new StringBuffer();
		
	// configure XmlTransmitter
	logger.debug("Configure transmitter..");
	configureXmlTransmitter("ReturnLabel");

	// add AccessRequest XML document to Request XML document
	xmlBuff.append(accessRequest.buildAccessXml());
	logger.debug(xmlBuff.toString());
	
	// add LabelRequest XML document to Request XML document
	xmlBuff.append(labelAdapter.buildConfirmDocument("digest", returnLabelRequest));
	logger.debug(xmlBuff.toString());

	
	xmlBuff.append(labelAdapter.buildAcceptDocument("digest"));
	logger.debug(xmlBuff.toString());

	// Set request xml on the transmitter engine
	logger.debug("Set request XML on transmitter..");
	xmlTransmitter.setXml(xmlBuff);

	// contact UPS History Servlet 
	logger.log("Transmit XML to UPS History Servlet..");
	xmlTransmitter.contactService(service, prefix, debug);

	// parse Response xml from transmitter into labelResponse object
	logger.log("Parse Response xml from transmitter into labelResponse object..");
	ReturnLabelResponse confirmResponse = labelAdapter.parseConfirmDocument(xmlTransmitter.getXml());
	ReturnLabelResponse accpetResponse = labelAdapter.parseAcceptDocument(xmlTransmitter.getXml());

	return confirmResponse;
}
/**
 * init: Purpose is to creates the factory.
 * <br><br>Creation date: (11/29/00 5:58:54 PM)
 * @exception java.lang.Exception The exception description.
 */
private void init() throws java.lang.Exception {
	labelAdapter = (ReturnLabelAdapter)factory.getAdapter("ReturnLabelAdapter");
}
}
