package com.ups.xmlsdk.row;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/
import java.io.*;
import java.util.*;
import com.ups.xmlsdk.*;
import com.ups.xmlsdk.la.*;
import com.ups.xmlsdk.util.*;
import com.ups.xmlsdk.util.logging.*;

/**
 * RequestLabelController: Ancestor object used to provide services to descendants
 * for request labels from client to UPS.
 * Creation date: (11/29/00 11:18:49 AM)
 * @since ROW SDK 1.0
 * @author: James C. Bragg
 */
public class RequestLabelController {
	private static final String ROWConfigFile = "row.properties";

	protected SDKFactory factory;
	protected XmlTransmitter xmlTransmitter;
	protected AccessAdapter accessRequest;

	protected Properties props;
	protected Logger logger;
	
	protected String service;
	protected String prefix;
	protected String debug;
/**
 * ReturnLabelController constructor creates logger object.
 */
public RequestLabelController() {
	try {

		// setup logger
		logger = DefaultLogFactory.instance().getOrAddLogger("Controller");

		// create AccessRequest Object for Licensing and Access
		accessRequest = (AccessAdapter)factory.getAdapter("com.ups.xmlsdk.la.AccessAdapter");

		// Read the Properties
		props = new Properties();
		FileInputStream propsInput = new FileInputStream(ROWConfigFile);

		// Read properties from properties file
		props.load(propsInput);
		propsInput.close();

	} catch (Exception e) {
		logger.log("Error loading properties file..");
	}
}
/**
 * configureXmlTransmitter: Purpose is to allow the controller object 
 * to read configuration file so that it can set its properties.
 * <br><br>Creation date: (11/30/00 9:54:38 AM)
 * @param requestType java.lang.String
 * @exception com.ups.xml.util.SDKException The exception description.
 */
protected void configureXmlTransmitter(String requestType) throws com.ups.xmlsdk.util.SDKException {

	try {
		// Get URL
		service = props.getProperty(requestType+".url");
			
		// Get serlvet
		prefix = props.getProperty(requestType+".service");
			
		// get debug 
		debug = props.getProperty("debug");
		
	} catch (Exception e){
		throw new SDKException("General Exception: ", e.getMessage());
	}	
}
/**
 * setUserId: Purpose provide the ability to the user to set his/her 
 * UserId used from logining into UPS.
 * <br><br>Creation date: (12/18/00 9:43:12 AM)
 * @param value com.ups.xmlsdk.la.AccessAdapter
 */
public void setAccessRequest(AccessAdapter value) {
	accessRequest = value;	
}
}
