package com.ups.xmlsdk.row;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/
import java.io.*;
import com.ups.xmlsdk.*;
import com.ups.xmlsdk.xpci.*;
import com.ups.xmlsdk.util.*;
import com.ups.xmlsdk.util.logging.*;
 
/**
 * LabelHistoryController: Request Controller object used for requesting a previous 
 * requested label from UPS.  The initial version will only be used to request label
 * and expect either a LabelResults or an Error Vector Object back to the client.
 * <br><br>Creation date: (11/29/00 11:41:21 AM)
 * @since ROW SDK 1.0
 * @author: James C. Bragg
 */
public class HistoryLabelController extends RequestLabelController {
	private HistoryLabelAdapter labelAdapter;		// LabelHistoryAdapter Object
/**
 * HistoryLabelController calls init method to create request and Response adapter objects
 */
public HistoryLabelController() {
	super();

	try {
		// initialize adapter
		init();
		
	} catch (Exception e){
		labelAdapter = null;
	}

}
/**
 * getReturnLabel: Purpose is to send the request object and receive the response object.
 * This is done by converting the Request object into XML and transmit it via the 
 * XmlTransmitter and then convert the XML Response from the transmitter into a response
 * object.
 * <BR><BR>Creation date: (11/30/00 9:40:49 AM)
 * @param histroyLabelRequest com.ups.xmlsdk.row.HistoryLabelRequest
 * @return com.ups.xmlsdk.row.HistoryLabelResponse
 * @exception java.lang.Exception The exception description.
 * @exception com.ups.xmlsdk.util.SDKException The exception description.
 */
public HistoryLabelResponse execute(HistoryLabelRequest histroyLabelRequest) throws java.lang.Exception, com.ups.xmlsdk.util.SDKException {

	// create Request XML document (StringBuffer)
	StringBuffer xmlBuff = new StringBuffer();
		
	// configure XmlTransmitter
	logger.debug("Configure transmitter..");
	configureXmlTransmitter("HistoryLabel");

	// add AccessRequest XML document to Request XML document
	xmlBuff.append(accessRequest.buildAccessXml());
	logger.debug(xmlBuff.toString());
	
	// add LabelRequest XML document to Request XML document
	xmlBuff.append(labelAdapter.buildRequestDocument(histroyLabelRequest));
	logger.debug(xmlBuff.toString());

	// Set request xml on the transmitter engine
	logger.debug("Set request XML on transmitter..");
	xmlTransmitter.setXml(xmlBuff);

	// contact UPS History Servlet 
	logger.log("Transmit XML to UPS History Servlet..");
	xmlTransmitter.contactService(service, prefix, debug);

	// parse Response xml from transmitter into labelResponse object
	logger.log("Parse Response xml from transmitter into labelResponse object..");
	HistoryLabelResponse response = labelAdapter.parseResponseDocument(xmlTransmitter.getXml());

	return response;

}
/**
 * init: Purpose is to creates the Request and Response objects.
 * <BR><BR>Creation date: (11/29/00 11:49:47 AM)
 * @exception com.ups.xml.util.SDKException The exception description.
 */
private void init() throws SDKException {
	try {

		// Get a Label History Request object from the factory
		logger.log("Get a Label History Request object from the factory..");
		labelAdapter = (HistoryLabelAdapter)factory.getAdapter("HistoryLabelAdapter");

	} catch (Exception e){
		throw new SDKException("Error Creating Request and/or Response Objects: ", e.getMessage());
	}
}
}
