package com.ups.xmlsdk.row;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/
import com.ibm.xml.parser.*;
import com.ups.xmlsdk.*;
import com.ups.xmlsdk.util.*;
import com.ups.xmlsdk.xpci.*;
import java.io.*;
import java.util.*;
import org.w3c.dom.*;

/**
 * Insert the type's description here.
 * Creation date: (11/15/00 5:04:04 PM)
 * @version 1.00 November 27, 2000
 * @since ROW SDK 1.0
 * @author: James C. Bragg
 */
public class HistoryLabelAdapter extends Adapter {
/**
 * LabelHistoryRequest constructor calls consructor of parent object.
 */
public HistoryLabelAdapter() {
	super();
}
private void addUnitOfMeasure(Document doc, String parent, String code, String desc)
{
	if ((code != null) && !(code.equals("#RM")))
	{
		AdapterUtility.addNode(doc, parent, XML_UnitOfMeasurement, null, null, null);
		AdapterUtility.addNode(doc, XML_UnitOfMeasurement, XML_Code, code, null, null);
		AdapterUtility.addNode(doc, XML_UnitOfMeasurement, XML_Description, desc, null, null);
	}
}
private void buildLabelSpec(Document doc, String rootname, LabelSpecification labelSpec)
{
	//This method builds the label specification node and all its children

	String s1 = labelSpec.getPrintMethodCode();
	AdapterUtility.addNode(doc, rootname, XML_LabelSpecification, null, null, null);
	AdapterUtility.addNode(doc, XML_LabelSpecification, XML_LabelPrintMethod, null, null, null);
	AdapterUtility.addNode(doc, XML_LabelPrintMethod, XML_Code, s1, null, null);
	AdapterUtility.addNode(doc, XML_LabelPrintMethod, XML_Description, labelSpec.getPrintMethodDesc(), null, null);
	if (s1.equalsIgnoreCase("GIF"))
	{
		AdapterUtility.addNode(doc, XML_LabelSpecification, XML_HTTPUserAgent, labelSpec.getHttpUserAgent(), null, null);
		AdapterUtility.addNode(doc, XML_LabelSpecification, XML_LabelImageFormat, null, null, null);
		AdapterUtility.addNode(doc, XML_LabelImageFormat, XML_Code, labelSpec.getImageFormatCode(), null, null);
		AdapterUtility.addNode(doc, XML_LabelImageFormat, XML_Description, labelSpec.getImageFormatDescription(), null, null);
	}
	if (s1.equalsIgnoreCase("EPL"))
	{
		AdapterUtility.addNode(doc, XML_LabelSpecification, XML_LabelStockSize, null, null, null);
		addUnitOfMeasure(doc, XML_LabelStockSize, labelSpec.getStockSizeCode(), labelSpec.getStockSizeDesc());
		AdapterUtility.addNode(doc, XML_LabelStockSize, XML_Height, labelSpec.getStockSizeHeight(), null, null);
		AdapterUtility.addNode(doc, XML_LabelStockSize, XML_Width, labelSpec.getStockSizeWidth(), null, null);
	}
}
/**
 * buildRequestDocument: Purpose is to create DOM Request object from the element that have 
 * been defined from the client/user.
 * <BR><BR>Creation date: (11/15/00 5:20:25 PM)
 * @param historyLabelRequest com.ups.xmlsdk.row.HistoryLabelRequest
 * @return java.lang.StringBuffer
 * @exception com.ups.xmlsdk.util.SDKException The exception description.
 */
public StringBuffer buildRequestDocument(HistoryLabelRequest historyLabelRequest) throws com.ups.xmlsdk.util.SDKException {
	Document doc = createXMLDocument(XML_LabelHistoryRequest);
	Element root = doc.getDocumentElement();
	root.setAttribute("xml:lang", "en-US");
	
	try {
		
		buildRequest(doc, XML_LabelHistoryRequest);

		// Get request information
		LabelSpecification labelSpec = historyLabelRequest.getLabelSpecification();
		if (labelSpec != null) {
			buildLabelSpec(doc, XML_LabelHistoryRequest, labelSpec);
		}
		
		String referenceNumber = historyLabelRequest.getReferenceNumber();
		String shipperNumber = historyLabelRequest.getShipperNumber();
		String trackingNumber = historyLabelRequest.getTrackingNumber();

		
		if ((trackingNumber == null) && (shipperNumber == null || referenceNumber == null)){
			String errMsg = "Insufficient information provided";
			throw new Exception(errMsg);
		}
		
		// Check if Tracking Number is available
		if (trackingNumber != null) {
			AdapterUtility.addNode(doc, XML_LabelHistoryRequest, XML_TrackingNumber, trackingNumber, null, null);
		}
		
		// Check if Shipper Number is available
		if (shipperNumber != null) {
			AdapterUtility.addNode(doc, XML_LabelHistoryRequest, XML_ShipperNumber, shipperNumber, null, null);
		}

		// Check if ReferenceNumber is available
		if (referenceNumber != null) {
				AdapterUtility.addNode(doc, XML_LabelHistoryRequest, XML_ReferenceNumber, referenceNumber, null, null);

		}

		return docToBuffer(doc);
		
	} catch (SDKException sdke){
		throw (sdke);
	} catch (Exception e) {
		throw new SDKException("General Exception: ", e.getMessage());
	}

}
/**
 * parseDocument: Purpose is to parse through the response XML Document 
 * and sets the values of the LabelResults Object.
 * <br><br>Creation date: (11/15/00 6:34:08 PM)
 * @param xmlIn java.lang.StringBuffer
 * @return com.ups.xmlsdk.row.HistoryLabelResponse
 * @exception com.ups.xmlsdk.util.SDKException The exception description.
 */
public HistoryLabelResponse parseResponseDocument(StringBuffer xmlIn) throws com.ups.xmlsdk.util.SDKException {
	try { 

		HistoryLabelResponse labelResponse = (HistoryLabelResponse)factory.getServiceContainer("com.ups.xmlsdk.row.HistoryLabelResponse");
		LabelResults labelResults = (LabelResults)factory.getXPCIContainer("LabelResults");
		
		// create document from Xml StringBuffer
		Document doc = getDocument(xmlIn.toString());

		// get root Node
		Node root = doc.getFirstChild();
		// create response object passing root node
		buildResponse(root);
		labelResponse.setResponse(response);

		// walk and retrieve the data
		Node results = getChildNode(root, XML_LabelResults);
		if (results != null){

			// get Tracking Number from document
			String trackingNumber = getChildNodeValue(results, XML_TrackingNumber);
			if (trackingNumber != null){
				labelResults.setTrackingNumber(trackingNumber);	
			}
 
			// get Label Image from document
			Node labelImageNode = getChildNode(results, XML_LabelImage);
			if (labelImageNode != null){
				LabelImage labelImage = (LabelImage)factory.getXPCIContainer("LabelImage");

				// Get LabelImageFormat Node from document
				Node labelImageFormatNode = getChildNode(labelImageNode, XML_LabelImageFormat);
				if (labelImageFormatNode != null){
					
					// Get & Check Format Code					
					String code = getChildNodeValue(labelImageFormatNode, XML_Code);
					if (code != null) {
						labelImage.setImageFormatCode(code);
					}

					// Get & Check Format Description
					String desc = getChildNodeValue(labelImageFormatNode, XML_Description);
					if (desc != null) {
						labelImage.setImageFormatDesc(desc);
					}
				}

				// Get & Check Graphic Image
				String graphicImage = getChildNodeValue(labelImageNode, XML_GraphicImage);
				if ( graphicImage != null ) { 
					labelImage.setGraphicImage(graphicImage);
				}

				// Get & Check HTMLImage
				String htmlImage = getChildNodeValue(labelImageNode, XML_HTMLImage);
				if ( htmlImage != null ) {
					labelImage.setHTMLImage(htmlImage);
				}

				// Add LabelImage to Label Results Object
				labelResults.setLabelImage(labelImage);
				
				labelResponse.setLabelResults(labelResults);
			}
		}

		return labelResponse;

	} catch (Exception e) {
		
		// get Name of the class that caused the error
		String errMsg = e.getClass().getName() + ": "+ e.getMessage();
		throw new SDKException(errMsg, SDKException.XML_PROCESSING_ERROR);
	}		
}
}
