package com.ups.xmlsdk.register;

import com.ups.xmlsdk.ServiceRequestContainer;
import com.ups.xmlsdk.ServiceResponseContainer;
import org.w3c.dom.Node;
import com.ups.xmlsdk.xpci.Address;
import com.ups.xmlsdk.xpci.RegistrationInformation;
import com.ups.xmlsdk.AdapterUtility;
import java.util.Vector;
import com.ibm.xml.parser.LibraryException;
import org.w3c.dom.Element;
import org.w3c.dom.Document;
import com.ups.xmlsdk.util.SDKException;
public class RegistrationAdapter extends com.ups.xmlsdk.Adapter
{

/**
 * RegistrationRequest constructor comment.
 */
public RegistrationAdapter() {
	super();
}
/**
 * 
 * 
 * 
 * @return java.lang.StringBuffer
 */
public StringBuffer adaptFromObject(ServiceRequestContainer src) throws SDKException
{
	RegistrationRequest rr = (RegistrationRequest) src;
	StringBuffer xmlBuf = new StringBuffer();
	Document doc = createXMLDocument(XML_RegistrationRequest);
	Element root = doc.getDocumentElement();
	root.setAttribute("xml:lang", "en-US");
	try
	{
		RegistrationInformation registrationInformation = rr.getRegistrationInformation();
		// build Request node
		buildRequest(doc, XML_RegistrationRequest);

		// add registration information
		AdapterUtility.addNode(doc, XML_RegistrationRequest, XML_RegistrationInformation, null, null, null);
		// add username
		AdapterUtility.addNode(doc, XML_RegistrationInformation, XML_UserName, registrationInformation.getUserName(), null, null);
		// add company
		AdapterUtility.addNode(doc, XML_RegistrationInformation, XML_CompanyName, registrationInformation.getCompanyName(), null, null);
		// add title
		AdapterUtility.addNode(doc, XML_RegistrationInformation, XML_Title, registrationInformation.getTitle(), null, null);
		// add address
		Vector addressVector = new Vector();
		Address add = registrationInformation.getAddress();
		String addr1 = add.getAddressLine1();
		String addr2 = add.getAddressLine2();
		String addr3 = add.getAddressLine3();
		String city = add.getCity();
		String state = add.getStateProvinceCode();
		String postal = add.getPostalCode();
		String country = add.getCountryCode();
		boolean res = add.isResidentialAddress();
		addressVector = AdapterUtility.buildAddressVector(addr1, addr2, addr3, city, state, postal, country, res);
		AdapterUtility.buildNode(doc, XML_RegistrationInformation, XML_Address, addressVector);
		// add phonenumber

		// add email address
		AdapterUtility.addNode(doc, XML_RegistrationInformation, XML_EmailAddress, registrationInformation.getEmailAddress(), null, null);
		// add shipper number
		AdapterUtility.addNode(doc, XML_RegistrationInformation, XML_ShipperNumber, registrationInformation.getShipperNumber(), null, null);
		// add pickup postal 
		AdapterUtility.addNode(doc, XML_RegistrationInformation, XML_PickupPostalCode, registrationInformation.getPickupPostalCode(), null, null);
		// add pickup country
		AdapterUtility.addNode(doc, XML_RegistrationInformation, XML_PickupCountryCode, registrationInformation.getPickupCountryCode(), null, null);
		// add userid
		AdapterUtility.addNode(doc, XML_RegistrationRequest, XML_UserId, rr.getUserid(), null, null);
		// add password
		AdapterUtility.addNode(doc, XML_RegistrationRequest, XML_Password, rr.getPassword(), null, null);
		// convert Document to StringBuffer
		xmlBuf = docToBuffer(doc);
	} catch (LibraryException le)
	{
		String errMsg = "Library Exception";
		throw new SDKException(errMsg, SDKException.UNDETERMINED);
	} catch (java.io.IOException ie)
	{
		String errMsg = "IOException";
		throw new SDKException(errMsg, SDKException.UNDETERMINED);
	} catch (Exception e)
	{
		String errMsg = "Probably caused by insufficient data-" + e.getMessage();
		throw new SDKException(errMsg, SDKException.XML_PROCESSING_ERROR);
	}
	return xmlBuf;
}
/**
 * 
 * 
 * 
 * @param xmlIn java.lang.StringBuffer
 * @exception com.ups.xmlsdk.util.SDKException The exception description.
 */
public ServiceResponseContainer adaptFromXml(StringBuffer xmlIn) throws SDKException
{
	try
	{
		RegistrationResponse rr = new RegistrationResponse();
		Document doc = getDocument(xmlIn.toString());
		Node root = doc.getFirstChild();
		// get reponse
		buildResponse(root);
		rr.setResponse(servRespCont.getResponse());
		// walk and retrieve the data
		rr.setUserId(getChildNodeValue(root, XML_UserId));
		return rr;
	} catch (Exception e)
	{
		String errMsg = e.getClass().getName() + ": " + e.getMessage();
		throw new SDKException(errMsg, SDKException.XML_PROCESSING_ERROR);
	}
}
}
