package com.ups.xmlsdk.rating;

/*
 *
 *
 */
import java.util.Vector;
import java.util.Enumeration;
import com.ibm.xml.parser.LibraryException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Document;
import com.ups.xmlsdk.*;
import com.ups.xmlsdk.xpci.*;
import com.ups.xmlsdk.util.SDKException;


// adapter
public class RatingAdapter extends Adapter implements XMLDefinitions
{
	private java.util.Vector ratedShipment;
	private java.lang.String rateRoot = XML_RatingRequest;
	private boolean shipFromIsPresent;
	private boolean international;
/**
 * RatingResponse constructor comment.
 */
public RatingAdapter()
{
	super();
}
/**
 * This method will construct a ShipmentConfirmRequest based on the Beans data.
 * @return java.lang.StringBuffer
 */
public StringBuffer adaptFromObject(ServiceRequestContainer sReq) throws java.lang.Exception
{
	servReqCont = sReq;
	StringBuffer xmlBuf = new StringBuffer();
	try
	{
		international = ((RatingRequest) sReq).isInternational();
		xmlBuf = buildRatingDocument(sReq);
	} catch (LibraryException le)
	{
		String errMsg = "Library Exception";
		throw new SDKException(errMsg, SDKException.UNDETERMINED);
	} catch (java.io.IOException ie)
	{
		String errMsg = "IOException";
		throw new SDKException(errMsg, SDKException.UNDETERMINED);
	} catch (Exception e)
	{
		String errMsg = "Probably caused by insufficient data-" + e.getMessage();
		throw new SDKException(errMsg, SDKException.XML_PROCESSING_ERROR);
	}
	return xmlBuf;
}
/**
 * 
 * 
 * 
 * @return com.ups.xmlsdk.ServiceResponseContainer
 * @param anXmlStream java.lang.StringBuffer
 * @exception java.lang.Exception The exception description.
 */
public ServiceResponseContainer adaptFromXml(StringBuffer anXmlStream) throws java.lang.Exception
{
	servRespCont = new ServiceResponseContainer();
	parseDocument(anXmlStream);
	return servRespCont;
}
/**
 * 
 * Builds a list of numbers returned from the Fax vector
 * 
 * @param doc org.w3c.dom.Document
 */
private void addFax(Document doc, String parent, java.util.Vector faxVec)
{
	Enumeration enum = faxVec.elements();
	while (enum.hasMoreElements())
	{
		Phone phone = (Phone) enum.nextElement();
		// build phone number
		if (phone instanceof StructuredPhoneNumber)
		{
			StructuredPhoneNumber phoneNum = (StructuredPhoneNumber) phone;
			Vector strucPhoneNum = new Vector();
			AdapterUtility.addNode(doc, parent, XML_FaxNumber, null, null, null);
			AdapterUtility.addNode(doc, XML_FaxNumber, XML_StructuredPhoneNumber, null, null, null);
			String phoneLineNum = phoneNum.getPhoneLineNumber();
			String extension = phoneNum.getPhoneExtension();
			String dialPlan = phoneNum.getPhoneDialPlanNumber();
			String phoneCC = phoneNum.getPhoneCountryCode();
			if (phoneCC != null)
			{
				if (phoneCC.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneCountryCode, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneCountryCode, phoneCC, null, null);
				}
			}
			if (dialPlan != null)
			{
				if (dialPlan.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneDialPlanNumber, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneDialPlanNumber, dialPlan, null, null);
				}
			}
			if (phoneLineNum != null)
			{
				if (phoneLineNum.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, phoneLineNum, null, null);
				}
			}
			if (extension != null)
			{
				if (extension.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneExtension, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, extension, null, null);
				}
			}
		}
	}
}
private void addPackage(Document doc, Package pack) throws Exception
{
	AdapterUtility.addNode(doc, XML_Shipment, XML_Package, null, null, null);
	String packType = pack.getPackagingTypeCode();
	if (packType != null)
	{
		AdapterUtility.addNode(doc, XML_Package, XML_PackagingType, null, null, null);
		if (packType.equals("#RM"))
		{
			AdapterUtility.addNode(doc, XML_PackagingType, XML_Code, "", null, null);
		} else
		{
			AdapterUtility.addNode(doc, XML_PackagingType, XML_Code, packType, null, null);
		}
		String packTypeDesc = pack.getPackagingTypeDesc();
		if (packTypeDesc != null)
		{
			if (packTypeDesc.equals("#RM"))
			{
				AdapterUtility.addNode(doc, XML_PackagingType, XML_Description, "", null, null);
			} else
			{
				AdapterUtility.addNode(doc, XML_PackagingType, XML_Description, packTypeDesc, null, null);
			}
		}
	}
	String packageDesc = pack.getDescription();
	if (packageDesc != null)
	{
		if (packageDesc.equals("#RM"))
		{
			AdapterUtility.addNode(doc, XML_Package, XML_Description, "", null, null);
		} else
		{
			AdapterUtility.addNode(doc, XML_Package, XML_Description, packageDesc, null, null);
		}
	}
	String len = pack.getLength();
	if ((len != null) && !(len.startsWith("#RM")))
	{
		AdapterUtility.addNode(doc, XML_Package, XML_Dimensions, null, null, null);
		addUnitOfMeasure(doc, XML_Dimensions, pack.getDimensionsUOMCode(), pack.getDimensionsUOMDesc());
		AdapterUtility.addNode(doc, XML_Dimensions, XML_Length, len, null, null);
		AdapterUtility.addNode(doc, XML_Dimensions, XML_Width, pack.getWidth(), null, null);
		AdapterUtility.addNode(doc, XML_Dimensions, XML_Height, pack.getHeight(), null, null);
	}
	AdapterUtility.addNode(doc, XML_Package, XML_PackageWeight, null, null, null);
	addUnitOfMeasure(doc, XML_PackageWeight, pack.getDimensionalWeightUOMCode(), pack.getDimensionalWeightUOMDesc());
	AdapterUtility.addNode(doc, XML_PackageWeight, XML_Weight, pack.getPackageWeight(), null, null);

	//Oversize Package
	String OSValue = pack.getOversizePackage();
	if (OSValue != null)
	{
		if (OSValue.equals("#RM"))
		{
			AdapterUtility.addNode(doc, XML_Package, XML_OversizePackage, "", null, null);
		} else
		{
			AdapterUtility.addNode(doc, XML_Package, XML_OversizePackage, OSValue, null, null);
		}
	}
	//Additional Handling
	boolean AH = pack.isAdditionalHandling();
	if (AH)
	{
		AdapterUtility.addNode(doc, XML_Package, XML_AdditionalHandling, "", null, null);
	}


	//PACKAGE REFERENCES
	if (international)
	{
		Enumeration enum = pack.getReferenceNumbers().elements();
		while (enum.hasMoreElements())
		{
			ReferenceNumber ref = (ReferenceNumber) enum.nextElement();
			addReference(doc, XML_Package, ref.getCode(), ref.getValue());
		}
	}

	// PACKAGE SERVICE OPTIONS
	PackageServiceOptions pso = pack.getPackageServiceOptions();
	if (pso != null)
	{
		Vector master = new Vector();
		Vector declaredIns = new Vector();
		String insCurr = pso.getInsuredValueCode();
		String insValue = pso.getInsuredValue();
		if (insCurr != null)
		{
			if (insCurr.equals("#RM"))
			{
				declaredIns.addElement(AdapterUtility.buildVector(XML_CurrencyCode, ""));
			} else
			{
				declaredIns.addElement(AdapterUtility.buildVector(XML_CurrencyCode, insCurr));
			}
		}
		if (insValue != null)
		{
			if (insValue.equals("#RM"))
			{
				declaredIns.addElement(AdapterUtility.buildVector(XML_MonetaryValue, ""));
			} else
			{
				declaredIns.addElement(AdapterUtility.buildVector(XML_MonetaryValue, insValue));
			}
		}
		master.addElement(AdapterUtility.buildVector(XML_InsuredValue, declaredIns));
		AdapterUtility.buildNode(doc, XML_Package, XML_PackageServiceOptions, master);
		String contactName = pso.getVerbalContactName();
		if (contactName != null)
		{
			// STRUCTURED PHONE NUMBER
			addPhone(doc, XML_VerbalConfirmation, (Phone) pso.getVerbalContactPhone());
		}
		Enumeration shNo = pso.getShipmentNotification().elements();
		while (shNo.hasMoreElements())
		{
			ShipmentNotification shipNot = (ShipmentNotification) shNo.nextElement();
			addShipmentNotification(doc, shipNot, XML_PackageServiceOptions);
		}
	}
}
/**
 * 
 * 
 * 
 * @param doc org.w3c.dom.Document
 */
private void addPhone(Document doc, String parent, com.ups.xmlsdk.xpci.Phone phone)
{
	// build phone number
	if (phone instanceof StructuredPhoneNumber)
	{
		StructuredPhoneNumber phoneNum = (StructuredPhoneNumber) phone;
		Vector strucPhoneNum = new Vector();
		AdapterUtility.addNode(doc, parent, XML_PhoneNumber, null, null, null);
		AdapterUtility.addNode(doc, XML_PhoneNumber, XML_StructuredPhoneNumber, null, null, null);
		String phoneLineNum = phoneNum.getPhoneLineNumber();
		String extension = phoneNum.getPhoneExtension();
		String dialPlan = phoneNum.getPhoneDialPlanNumber();
		String phoneCC = phoneNum.getPhoneCountryCode();
		if (phoneCC != null)
		{
			if (phoneCC.equals("#RM"))
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneCountryCode, null, null, null);
			} else
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneCountryCode, phoneCC, null, null);
			}
		}
		if (dialPlan != null)
		{
			if (dialPlan.equals("#RM"))
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneDialPlanNumber, null, null, null);
			} else
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneDialPlanNumber, dialPlan, null, null);
			}
		}
		if (phoneLineNum != null)
		{
			if (phoneLineNum.equals("#RM"))
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, null, null, null);
			} else
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, phoneLineNum, null, null);
			}
		}
		if (extension != null)
		{
			if (extension.equals("#RM"))
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneExtension, null, null, null);
			} else
			{
				AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, extension, null, null);
			}
		}
	}
}
/**
 * 
 * Builds a list of numbers returned from the phone vector
 * 
 * @param doc org.w3c.dom.Document
 */
private void addPhone(Document doc, String parent, java.util.Vector phoneVec)
{
	Enumeration enum = phoneVec.elements();
	while (enum.hasMoreElements())
	{
		Phone phone = (Phone) enum.nextElement();
		// build phone number
		if (phone instanceof StructuredPhoneNumber)
		{
			StructuredPhoneNumber phoneNum = (StructuredPhoneNumber) phone;
			Vector strucPhoneNum = new Vector();
			AdapterUtility.addNode(doc, parent, XML_PhoneNumber, null, null, null);
			AdapterUtility.addNode(doc, XML_PhoneNumber, XML_StructuredPhoneNumber, null, null, null);
			String phoneLineNum = phoneNum.getPhoneLineNumber();
			String extension = phoneNum.getPhoneExtension();
			String dialPlan = phoneNum.getPhoneDialPlanNumber();
			String phoneCC = phoneNum.getPhoneCountryCode();
			if (phoneCC != null)
			{
				if (phoneCC.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneCountryCode, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneCountryCode, phoneCC, null, null);
				}
			}
			if (dialPlan != null)
			{
				if (dialPlan.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneDialPlanNumber, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneDialPlanNumber, dialPlan, null, null);
				}
			}
			if (phoneLineNum != null)
			{
				if (phoneLineNum.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, phoneLineNum, null, null);
				}
			}
			if (extension != null)
			{
				if (extension.equals("#RM"))
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneExtension, null, null, null);
				} else
				{
					AdapterUtility.addNode(doc, XML_StructuredPhoneNumber, XML_PhoneLineNumber, extension, null, null);
				}
			}
		}
	}
}
/**
 * 
 * 
 * 
 * @param doc org.w3c.dom.Document
 * @param shipper com.ups.xmlsdk.xpci.Prepaid
 */
private void addPrepaid(Document doc, com.ups.xmlsdk.xpci.Prepaid shipper)
{
	Vector billShipperVector = new Vector();
	// shipper is an istance of PrepaidBillShipper
	if (shipper instanceof PrepaidBillShipper)
	{
		PrepaidBillShipper billShipper = (PrepaidBillShipper) shipper;
		String accountNumber = billShipper.getAccountNumber();
		if (accountNumber != null)
		{
			if (!(accountNumber.startsWith("#RM")))
			{
				billShipperVector.addElement(AdapterUtility.buildVector(XML_AccountNumber, accountNumber));
			}
		}
		String CCN = billShipper.getCreditCardNumber();
		if (CCN != null)
		{
			if (!(CCN.startsWith("#RM")))
			{
				Vector ccVector = new Vector();
				ccVector.addElement(AdapterUtility.buildVector(XML_Type, billShipper.getCreditCardType()));
				ccVector.addElement(AdapterUtility.buildVector(XML_Number, CCN));
				ccVector.addElement(AdapterUtility.buildVector(XML_ExpirationDate, billShipper.getCreditCardExpiration()));
				billShipperVector.addElement(AdapterUtility.buildVector(XML_CreditCard, ccVector));
			}
		}
		AdapterUtility.addNode(doc, XML_Shipment, XML_PaymentInformation, null, null, null);
		AdapterUtility.addNode(doc, XML_PaymentInformation, XML_Prepaid, null, null, null);
		AdapterUtility.buildNode(doc, XML_Prepaid, XML_BillShipper, billShipperVector);
	}
	if (shipper instanceof PrepaidBillThirdShipper)
	{
		PrepaidBillThirdShipper billShipper = (PrepaidBillThirdShipper) shipper;
		String accountNumber = billShipper.getAccountNumber();
		if (accountNumber != null)
		{
			if (!(accountNumber.startsWith("#RM")))
			{
				billShipperVector.addElement(AdapterUtility.buildVector(XML_AccountNumber, accountNumber));
			}
		}
		CorpAgent thirdParty = billShipper.getThirdParty();
		if (thirdParty != null)
		{
			// build corpAgent stuff here

		}
		AdapterUtility.addNode(doc, XML_Shipment, XML_PaymentInformation, null, null, null);
		AdapterUtility.addNode(doc, XML_PaymentInformation, XML_Prepaid, null, null, null);
		AdapterUtility.buildNode(doc, XML_Prepaid, XML_BillThirdPartyShipper, billShipperVector);
	}
}
private void addReference(Document doc, String parent, String code, String value)
{
	AdapterUtility.addNode(doc, parent, XML_ReferenceNumber, null, null, null);
	AdapterUtility.addNode(doc, XML_ReferenceNumber, XML_Code, code, null, null);
	AdapterUtility.addNode(doc, XML_ReferenceNumber, XML_Value, value, null, null);
}
/**
 * 
 * Creation date: (8/8/00 10:12:18 AM)
 */
private void addShipmentNotification(Document doc, ShipmentNotification shipNot, String parent) throws Exception
{
	AdapterUtility.addNode(doc, parent, XML_ShipmentNotification, null, null, null);
	String NotificationCode = shipNot.getNotificationCode();
	if (NotificationCode != null)
	{
		if (NotificationCode.equals("#RM"))
		{
			AdapterUtility.addNode(doc, XML_ShipmentNotification, XML_NotificationCode, null, null, null);
		} else
		{
			AdapterUtility.addNode(doc, XML_ShipmentNotification, XML_NotificationCode, NotificationCode, null, null);
		}
	}
	// build Attention Name
	String AttentionName = shipNot.getAttentionName();
	if (AttentionName != null)
	{
		if (AttentionName.equals("#RM"))
		{
			AdapterUtility.addNode(doc, XML_ShipmentNotification, XML_AttentionName, null, null, null);
		} else
		{
			AdapterUtility.addNode(doc, XML_ShipmentNotification, XML_AttentionName, AttentionName, null, null);
		}
	}
	// build Company Name
	String CompanyName = shipNot.getCompanyName();
	if (CompanyName != null)
	{
		if (CompanyName.equals("#RM"))
		{
			AdapterUtility.addNode(doc, XML_ShipmentNotification, XML_CompanyName, null, null, null);
		} else
		{
			AdapterUtility.addNode(doc, XML_ShipmentNotification, XML_CompanyName, CompanyName, null, null);
		}
	}
	// build fax destination
	String faxDestNum = shipNot.getFaxDestinationNumber();
	if (faxDestNum != null)
	{
		Vector faxDest = new Vector();
		String Indicator = shipNot.getFaxDestinationIndicator();
		if (Indicator != null)
		{
			if (Indicator.equals("#RM"))
			{
				faxDest.addElement(AdapterUtility.buildVector(XML_FaxDestinationIndicator, null));
			} else
			{
				faxDest.addElement(AdapterUtility.buildVector(XML_FaxDestinationIndicator, null));
			}
		}
		if (faxDestNum.equals("#RM"))
		{
			faxDest.addElement(AdapterUtility.buildVector(XML_FaxNumber, null));
		} else
		{
			faxDest.addElement(AdapterUtility.buildVector(XML_FaxNumber, faxDestNum));
		}
		AdapterUtility.buildNode(doc, XML_ShipmentNotification, XML_FaxDestination, faxDest);
	}
	// build email message
	EmailMessage message = shipNot.getEmailMessage();
	if (message != null)
	{
		Vector emailMessage = new Vector();
		String[] emailAdd = message.getEmailAddress();
		int em = emailAdd.length;
		for (int k = em; k <= em; k++)
		{
			if (emailAdd.equals("#RM"))
			{
				emailMessage.addElement(AdapterUtility.buildVector(XML_EmailAddress, null));
			} else
			{
				emailMessage.addElement(AdapterUtility.buildVector(XML_EmailAddress, emailAdd));
			}
		}
		String memo = message.getMemo();
		if (memo != null)
		{
			if (memo.equals("#RM"))
			{
				emailMessage.addElement(AdapterUtility.buildVector(XML_Memo, null));
			} else
			{
				emailMessage.addElement(AdapterUtility.buildVector(XML_Memo, memo));
			}
		}
		Enumeration imEnum = message.getImage().elements();
		while (imEnum.hasMoreElements())
		{
			Image im = (Image) imEnum.nextElement();
			Vector image = new Vector();
			Vector imageFormat = new Vector();
			String code = im.getImageFormatCode();
			if (code != null)
			{
				if (code.equals("#RM"))
				{
					imageFormat.addElement(AdapterUtility.buildVector(XML_Code, null));
				} else
				{
					imageFormat.addElement(AdapterUtility.buildVector(XML_Code, code));
				}
			}
			String desc = im.getImageFormatDesc();
			if (desc != null)
			{
				if (desc.equals("#RM"))
				{
					imageFormat.addElement(AdapterUtility.buildVector(XML_Description, null));
				} else
				{
					imageFormat.addElement(AdapterUtility.buildVector(XML_Description, desc));
				}
			}
			image.addElement(AdapterUtility.buildVector(XML_ImageFormat, imageFormat));
			String graphic = im.getGraphicImage();
			if (graphic != null)
			{
				if (graphic.equals("#RM"))
				{
					image.addElement(AdapterUtility.buildVector(XML_GraphicImage, null));
				} else
				{
					image.addElement(AdapterUtility.buildVector(XML_GraphicImage, graphic));
				}
			}
			emailMessage.addElement(AdapterUtility.buildVector(XML_Image, image));
		}
		AdapterUtility.buildNode(doc, XML_ShipmentNotification, XML_EmailMessage, emailMessage);
	}
	// PHONE NUMBER 
	Phone phoneNum = (Phone) shipNot.getPhoneNumber();
	addPhone(doc, XML_ShipmentNotification, phoneNum);

	// END SHIPMENT NOTIFICATION

}
private void addUnitOfMeasure(Document doc, String parent, String code, String desc)
{
	if ((code != null) && !(code.equals("#RM")))
	{
		AdapterUtility.addNode(doc, parent, XML_UnitOfMeasurement, null, null, null);
		AdapterUtility.addNode(doc, XML_UnitOfMeasurement, XML_Code, code, null, null);
		AdapterUtility.addNode(doc, XML_UnitOfMeasurement, XML_Description, desc, null, null);
	}
}
/**
 *  This method builds either the Shipper, Ship To, or ShipFrom node and their children
 *	depending on the 'type' entered.  'type' also corresponds to the node name.
 *	If 'type' is not one of (Shipper,ShipTo,ShipFrom) only an address node is built
 */

private void buildAgent(Document doc, Agent agent, String type) throws Exception
{
	Vector ccVector = new Vector();
	Vector phoneExt = new Vector();
	Vector phone = agent.getPhoneNumber();
	AdapterUtility.addNode(doc, XML_Shipment, type, null, null, null);
	if (type.equals(XML_Shipper))
	{
		//Name is required - if name is empty use the company name
		String name = agent.getName();
		if (name == null)
			name = agent.getCompanyName();
		AdapterUtility.addNode(doc, type, XML_Name, name, null, null);
		String shipperNum = agent.getShipperNumber();
		if (international == true)
		{
			AdapterUtility.addNode(doc, type, XML_AttentionName, name, null, null);
		}
		AdapterUtility.addNode(doc, type, XML_ShipperNumber, shipperNum, null, null);
		AdapterUtility.addNode(doc, type, XML_EmailAddress, agent.getEmailAddress(), null, null); //  email address node added  on 08-07-2000 for A2A release testing
	}
	if (type.equals(XML_ShipTo))
	{
		//Company Name is required 
		String coName = agent.getCompanyName();
		String attName = agent.getName();
		if (coName == null)
			coName = attName;
		AdapterUtility.addNode(doc, type, XML_CompanyName, coName, null, null);
		String taxId = agent.getTaxID();
		String emailAdd = agent.getEmailAddress();


		//for international shipments attention Name is also required
		if (international)
		{
			if ((attName == null) || (attName.equals("#RM")))
			{
				attName = coName;
			}
		}
		AdapterUtility.addNode(doc, type, XML_AttentionName, attName, null, null);
		AdapterUtility.addNode(doc, type, XML_TaxIdentificationNumber, taxId, null, null);
		if (agent.getFaxNumber() != null)
			addFax(doc, type, agent.getFaxNumber());
		AdapterUtility.addNode(doc, type, XML_EmailAddress, emailAdd, null, null); //  email address node added  on 08-07-2000 for A2A release testing

	}
	if (type.equals(XML_ShipFrom))
	{
		//Company Name is required 
		String coName = agent.getCompanyName();
		String name = agent.getName();
		String emailAdd = agent.getEmailAddress();
		if (coName == null)
			coName = name;
		AdapterUtility.addNode(doc, type, XML_CompanyName, coName, null, null);
		AdapterUtility.addNode(doc, type, XML_AttentionName, name, null, null);
		addFax(doc, type, agent.getFaxNumber());
		AdapterUtility.addNode(doc, type, XML_EmailAddress, emailAdd, null, null); //  email address node added  on 08-07-2000 for A2A release testing

	}
	// phone
	addPhone(doc, type, phone);
	//ADDRESS
	AddressAbstract add = agent.getAddress();
	AdapterUtility.buildAddress(doc, type, add);
}
private StringBuffer buildRatingDocument(ServiceRequestContainer sc) throws Exception
{
	Document doc = createXMLDocument(rateRoot);
	Element root = doc.getDocumentElement();
	root.setAttribute("xml:lang", "en-US");
	try
	{
		buildRequest(doc, rateRoot);
		com.ups.xmlsdk.xpci.Shipment shipment = ((RatingRequest) sc).getShipment();
		//SHIPMENT
		AdapterUtility.addNode(doc, rateRoot, XML_Shipment, null, null, null);
		String shipmentID = shipment.getShipmentID();
		AdapterUtility.addNode(doc, XML_Shipment, XML_Description, shipment.getDescription(), null, null);
		shipFromIsPresent = true;
		//SHIPPER
		Agent shipper = shipment.getShipper();
		buildAgent(doc, shipper, XML_Shipper);
		//SHIP TO
		Agent shipTo = shipment.getShipTo();
		buildAgent(doc, shipTo, XML_ShipTo);
		//SHIP FROM
		Agent shipFrom = shipment.getShipFrom();
		if (shipFrom == null)
		{
			shipFromIsPresent = false;
		} else
		{
			buildAgent(doc, shipFrom, XML_ShipFrom);
		}

		// No Commercial Value Indicator  - added for A2A testing on 08-07-2000
		boolean comValue = shipment.getDocuments();
		if (comValue)
			AdapterUtility.addNode(doc, XML_Shipment, XML_DocumentsOnly, null, null, null);

		// Scheduled Delivery Time - added for A2A testing on 08-07-2000
		String scheduledDeliveryDate = shipment.getScheduledDeliveryDate();
		String scheduledDeliveryTime = shipment.getScheduledDeliveryTime();
		if (scheduledDeliveryDate != null)
			AdapterUtility.addNode(doc, XML_Shipment, XML_ScheduledDeliveryDate, scheduledDeliveryDate, null, null);
		if (scheduledDeliveryTime != null)
			AdapterUtility.addNode(doc, XML_Shipment, XML_ScheduledDeliveryTime, scheduledDeliveryTime, null, null);



		//PAYMENT INFO - ASSUMES PREPAYMENT
		Object payInfo = shipment.getPaymentInfo();
		if (payInfo instanceof Prepaid)
		{
			addPrepaid(doc, (Prepaid) payInfo);
		}



		//SHIPMENT REFERENCE NUMBERS
		if (international == true)
		{
			Enumeration refEnum = shipment.getReferenceNumbers().elements();
			while (refEnum.hasMoreElements())
			{
				ReferenceNumber ref = (ReferenceNumber) refEnum.nextElement();
				addReference(doc, XML_Shipment, ref.getCode(), ref.getValue());
			}
		}
		//SERVICE
		AdapterUtility.addNode(doc, XML_Shipment, XML_Service, null, null, null);
		AdapterUtility.addNode(doc, XML_Service, XML_Code, shipment.getServiceCode(), null, null);
		AdapterUtility.addNode(doc, XML_Service, XML_Description, shipment.getServiceDescription(), null, null);

		// INVOICE
		if (shipment.getInvoiceMonetaryValue() != null)
		{
			Vector invoiceLineTotal = new Vector();
			invoiceLineTotal.addElement(AdapterUtility.buildVector(XML_CurrencyCode, shipment.getInvoiceCurrencyCode()));
			invoiceLineTotal.addElement(AdapterUtility.buildVector(XML_MonetaryValue, shipment.getInvoiceMonetaryValue()));
			AdapterUtility.buildNode(doc, XML_Shipment, XML_InvoiceLineTotal, invoiceLineTotal);
		}


		//SHIPMENT SERVICE OPTIONS
		ShipmentServiceOptions sso = shipment.getShipmentServiceOptions();
		if (sso != null)
		{
			Vector master = new Vector();
			boolean satPickup = sso.isSaturdayPickup();
			if (satPickup)
				master.addElement(AdapterUtility.buildVector(XML_SaturdayPickup, null));
			boolean satDelivery = sso.isSaturdayDelivery();
			if (satDelivery)
				master.addElement(AdapterUtility.buildVector(XML_SaturdayDelivery, null));
			if (international == true)
			{
				Vector declaredIns = new Vector();
				String insCurr = sso.getInsuredValueCode();
				String insValue = sso.getInsuredValue();
				if (insCurr != null)
				{
					if (insCurr.equals("#RM"))
					{
						declaredIns.addElement(AdapterUtility.buildVector(XML_CurrencyCode, ""));
					} else
					{
						declaredIns.addElement(AdapterUtility.buildVector(XML_CurrencyCode, insCurr));
					}
				}
				if (insValue != null)
				{
					if (insValue.equals("#RM"))
					{
						declaredIns.addElement(AdapterUtility.buildVector(XML_MonetaryValue, ""));
					} else
					{
						declaredIns.addElement(AdapterUtility.buildVector(XML_MonetaryValue, insValue));
					}
				}
				master.addElement(AdapterUtility.buildVector(XML_InsuredValue, declaredIns));
			}
			AdapterUtility.buildNode(doc, XML_Shipment, XML_ShipmentServiceOptions, master);
			Enumeration notEnum = sso.getShipmentNotification().elements();
			while (notEnum.hasMoreElements())
			{
				ShipmentNotification shipmentNot = (ShipmentNotification) notEnum.nextElement();
				addShipmentNotification(doc, shipmentNot, XML_ShipmentServiceOptions);
			}
		}
		//PACKAGES
		Enumeration packEnum = shipment.getPackages().elements();
		while (packEnum.hasMoreElements())
		{
			Package pack = (Package) packEnum.nextElement();
			addPackage(doc, pack);
		}
		return docToBuffer(doc);
	} catch (Exception e)
	{
		throw e;
	}
}
/**
 * This method will construct a RatingRequest based on the Beans data.
 * @return java.lang.StringBuffer
 */
private StringBuffer buildRatingXml(ServiceRequestContainer sc) throws SDKException
{
	StringBuffer xmlBuf = new StringBuffer();
	try
	{
		xmlBuf = buildRatingDocument(sc);
	} catch (LibraryException le)
	{
		String errMsg = "Library Exception";
		throw new SDKException(errMsg, SDKException.UNDETERMINED);
	} catch (java.io.IOException ie)
	{
		String errMsg = "IOException";
		throw new SDKException(errMsg, SDKException.UNDETERMINED);
	} catch (Exception e)
	{
		String errMsg = "Probably caused by insufficient data-" + e.getMessage();
		throw new SDKException(errMsg, SDKException.XML_PROCESSING_ERROR);
	}
	return xmlBuf;
}
/**
 * 
 * 
 * 
 * @return java.util.Vector
 */
public java.util.Vector getRatedShipment() {
	return ratedShipment;
}
/**
 * 
 * 
 * 
 * @param xmlIn java.lang.StringBuffer
 * @exception com.ups.xml.util.SDKException The exception description.
 */
public void parseDocument(StringBuffer xmlIn) throws SDKException
{
	try
	{
		Document doc = getDocument(xmlIn.toString());
		Node root = doc.getFirstChild();
		// get reponse
		buildResponse(root);
		// walk and retrieve the data
		Vector rsVec = new Vector();
		Node ratedShipment = null;
		for (ratedShipment = getChildNode(root, XML_RatedShipment); ratedShipment != null; ratedShipment = ratedShipment.getNextSibling())
		{
			RatedShipment rs = (RatedShipment) factory.getXPCIContainer("RatedShipment");
			rs.setGuaranteedDaysToDelivery(getChildNodeValue(ratedShipment, XML_GuaranteedDaysToDelivery));
			rs.setScheduledDeliveryTime(getChildNodeValue(ratedShipment, XML_ScheduledDeliveryTime));
			// Service Node
			Node ser = getChildNode(ratedShipment, XML_Service);
			if (ser != null)
			{
				rs.setServiceCode(getChildNodeValue(ser, XML_Code));
				rs.setServiceDescription(getChildNodeValue(ser, XML_Description));
			}
			// Billing Weight Node
			Node bw = getChildNode(ratedShipment, XML_BillingWeight);
			if (bw != null)
			{
				rs.setBillingWeight(getChildNodeValue(bw, XML_Weight));
				Node UOM = getChildNode(bw, XML_UnitOfMeasurement);
				if (UOM != null)
				{
					rs.setBillingWeightUOMCode(getChildNodeValue(UOM, XML_Code));
					rs.setBillingWeightUOMDesc(getChildNodeValue(UOM, XML_Description));
				}
			}
			// Transportation Charges
			Node transNode = getChildNode(ratedShipment, XML_TransportationCharges);
			if (transNode != null)
			{
				rs.setTransportationCurrencyCode(getChildNodeValue(transNode, XML_CurrencyCode));
				rs.setTransportationValue(getChildNodeValue(transNode, XML_MonetaryValue));
			}
			// Handling Charges
			Node handNode = getChildNode(ratedShipment, XML_HandlingCharges);
			if (handNode != null)
			{
				rs.setHandlingChargeCurrencyCode(getChildNodeValue(handNode, XML_CurrencyCode));
				rs.setHandlingChargeValue(getChildNodeValue(handNode, XML_MonetaryValue));
			}
			// Service Option Charges
			Node soNode = getChildNode(ratedShipment, XML_ServiceOptionsCharges);
			if (soNode != null)
			{
				rs.setServiceOptionsCurrencyCode(getChildNodeValue(soNode, XML_CurrencyCode));
				rs.setServiceOptionsValue(getChildNodeValue(soNode, XML_MonetaryValue));
			}
			// Total Charges
			Node totNode = getChildNode(ratedShipment, XML_TotalCharges);
			if (totNode != null)
			{
				rs.setTotalCurrencyCode(getChildNodeValue(totNode, XML_CurrencyCode));
				rs.setTotalValue(getChildNodeValue(totNode, XML_MonetaryValue));
			}
			// rated Packages
			Vector packVector = new Vector();
			Node ratedPackage = null;
			for (ratedPackage = getChildNode(ratedShipment, XML_RatedPackage); ratedPackage != null; ratedPackage = ratedPackage.getNextSibling())
			{
				RatedPackage rp = (RatedPackage) factory.getXPCIContainer("RatedPackage");
				/*** Rated Package****/
				// fill billing weight
				Node packBW = getChildNode(ratedPackage, XML_BillingWeight);
				if (packBW != null)
				{
					rp.setBillingWeight(getChildNodeValue(packBW, XML_Weight));
					Node UOM = getChildNode(packBW, XML_UnitOfMeasurement);
					if (UOM != null)
					{
						rp.setBillingWeightUOMCode(getChildNodeValue(UOM, XML_Code));
						rp.setBillingWeightUOMDesc(getChildNodeValue(UOM, XML_Description));
					}
				}
				// fill reference numbers
				Vector refVector = new Vector();
				Node refNode = null;
				for (refNode = getChildNode(ratedPackage, XML_ReferenceNumber); refNode != null; refNode = refNode.getNextSibling())
				{
					// new reference object
					ReferenceNumber refNum = (ReferenceNumber) factory.getXPCIContainer("ReferenceNumber");
					refNum.setCode(getChildNodeValue(refNode, XML_Code));
					refNum.setValue(getChildNodeValue(refNode, XML_Value));
					// add reference numbers to Vector
					refVector.addElement(refNum);
				}
				rp.setReferenceNumbers(refVector);
				// fill service option charges
				Node soPackNode = getChildNode(ratedPackage, XML_ServiceOptionsCharges);
				if (soPackNode != null)
				{
					rp.setServiceOptionsCurrencyCode(getChildNodeValue(soPackNode, XML_CurrencyCode));
					rp.setServiceOptionsValue(getChildNodeValue(soPackNode, XML_MonetaryValue));
				}
				// fill total charges
				Node totPackNode = getChildNode(ratedPackage, XML_TotalCharges);
				if (totPackNode != null)
				{
					rp.setTotalCurrencyCode(getChildNodeValue(totPackNode, XML_CurrencyCode));
					rp.setTotalValue(getChildNodeValue(totPackNode, XML_MonetaryValue));
				}
				// fill transportation charges
				Node tranPackNode = getChildNode(ratedPackage, XML_TransportationCharges);
				if (tranPackNode != null)
				{
					rp.setTransportationCurrencyCode(getChildNodeValue(tranPackNode, XML_CurrencyCode));
					rp.setTransportationValue(getChildNodeValue(tranPackNode, XML_MonetaryValue));
				}
				// fill weight
				rp.setWeight(getChildNodeValue(ratedPackage, XML_Weight));

				// add package to vector
				packVector.addElement(rp);
			}
			// add vector to Rated Shipment
			rs.setRatedPackages(packVector);
		}
		this.ratedShipment = rsVec;
	} catch (Exception e)
	{
		String errMsg = e.getClass().getName() + ": " + e.getMessage();
		throw new SDKException(errMsg, SDKException.XML_PROCESSING_ERROR);
	}
}
}
