package com.ups.xmlsdk;

/**
 * FileName: XMLAdapterFactory.java
 * Date: 10/10/2000
 */

import java.util.Hashtable;

/**
 * XMLAdapterFactory is a singleton class, responsible for dynamically loading
 * Adapters, keeping track of the loaded Adapters, and Returning loaded Adapters.
 *
 */

public class SDKFactory
{
	private static SDKFactory classFactory;
	private Hashtable _classTable = new Hashtable();
	private java.lang.String xpciPackage = "com.ups.xmlsdk.xpci.";
	static
	{
		classFactory = new SDKFactory();
	}
/**
 *	public synchronized Object getAdapter(String adapterName)
 *	This method is responsible for loading the class dynamically,
 *	if the class is not yet loaded.
 *	It keeps track of the load classes in a hashtable.
 *
 *	@return Object
 *	@param adapterName String, name of the Adapter to be loaded ex: com.ups.xmlsdk.shipping.ShipmentAdapter
 */

public synchronized Adapter getAdapter(String adapterName) throws ClassNotFoundException, InstantiationException, IllegalAccessException
{
	Class classObject = (Class) _classTable.get(adapterName);
	if (classObject == null)
	{
		classObject = Class.forName(adapterName);
	}
	_classTable.put(adapterName, classObject);
	Object object = classObject.newInstance();
	return (Adapter) object;
}
/**
 * public static SDKFactory getInstance() method is a class method,
 * retuning the class instance
 * @return SDKFactory
 * 
 */

public static SDKFactory getInstance()
{
	return classFactory;
}
/**
 *	public synchronized Object getServiceContainer(String containerName)
 *	This method is responsible for loading the class dynamically,
 *	if the class is not yet loaded.
 *	It keeps track of the load classes in a hashtable.
 *
 *	@return Object
 *	@param containerName String, name of the Adapter to be loaded ex: com.ups.xmlsdk.shipping.ShipmentConfirmResponse
 */

public synchronized Object getServiceContainer(String containerName) throws ClassNotFoundException, InstantiationException, IllegalAccessException
{
	Class classObject = (Class) _classTable.get(containerName);
	if (classObject == null)
	{
		classObject = Class.forName(containerName);
	}
	_classTable.put(containerName, classObject);
	Object object = classObject.newInstance();
	return object;
}
/**
 *	public synchronized Class getBean(String beanName)
 *	This method is responsible for loading the class dynamically,
 *	if the class is not yet loaded.
 *	It keeps track of the load classes in a hashtable.
 *  This method will only allow instantiation of xpci Beans (com.ups.xmlsdk.xpci.*)
 *
 *	@return Class
 *	@param beanName String, name of the Bean to be loaded ex: Shipment
 */

public synchronized Object getXPCIContainer(String beanName) throws ClassNotFoundException, IllegalAccessException, InstantiationException
{
	Class classObject = (Class) _classTable.get(beanName);
	if (classObject == null)
	{
		classObject = Class.forName(xpciPackage + beanName);
	}
	_classTable.put(beanName, classObject);
	Object object = classObject.newInstance();
	return object;
}
/**
 * 
 * Attempts to open system resources by setting referenced objects to Null.
 * 
 * @param anObject java.lang.Object
 */
public void releaseResource(Object anObject)
{
	anObject = null;
}
}
