package com.ups.xmlsdk;

import com.ibm.xml.parser.TXDocument;
import java.io.*;
import java.util.*;
import com.ups.xmlsdk.util.*;
import com.ibm.xml.parsers.DOMParser;
import com.ups.xmlsdk.xpci.*;
import org.xml.sax.*;
import org.w3c.dom.*;
/**
 * The Adapter utilizes the XML4J parser to construct XML documents.  This class is a
 * base class providing the parsing and dom manipulation of XML documents.
 */


public class Adapter implements AdapterInterface, XMLDefinitions
{
	protected com.ibm.xml.parsers.DOMParser parser = null;

	protected ServiceRequestContainer servReqCont;
	protected ServiceResponseContainer servRespCont;
	protected SDKFactory factory;
	protected final static java.lang.String RESPONSE_SUCCESS = "1";
	protected final static java.lang.String RESPONSE_FAILURE = "0";
	protected final static java.lang.String RESPONSE_TRANSIENT = "3";
/**
 * Adapter constructor comment.
 */
public Adapter()
{
	parser = new com.ibm.xml.parsers.DOMParser();
	factory = SDKFactory.getInstance();
}
/**
 * 
 * 
 * 
 * @return java.lang.StringBuffer
 * @param aServReqContainer com.ups.xmlsdk.ServiceRequestContainer
 */
public StringBuffer adaptFromObject(ServiceRequestContainer aServReqContainer) throws Exception{
	return null;
}
/**
 * Method takes an XML document as a StringBuffer, parses and populates the bean
 * with the tracking data.
 * @param java.lang.StringBuffer document
 */
public ServiceResponseContainer adaptFromXml(StringBuffer document) throws Exception
{
	try
	{
		Document doc = getDocument(document.toString());
		return servRespCont;
	} catch (Exception e)
	{
		throw e;
	}
}
/**
 * This method takes a Node determines the address structure of the nodes child and returns
 * an instance of the structure to the caller.
 * (Hint: Use polymorphism to determine the return object's instance)
 * 
 * @return com.ups.xml.beans.AddressAbstract
 * @param nodeName org.w3c.dom.Node
 */
protected AddressAbstract buildAddressAbstract(Node parent) throws Exception
{

	// build address to return
	if (parent.hasChildNodes())
	{
		AddressAbstract addAb = null;
		Node address = parent.getFirstChild().getNextSibling();
		if ((address != null) && (address.getNodeType() != Node.TEXT_NODE))
		{
			String addName = address.getNodeName();
			if (addName.equals(XML_Address))
			{
				Address add = (Address) factory.getXPCIContainer("Address");
				add.setAddressLine1(getChildNodeValue(address, XML_AddressLine1));
				add.setAddressLine2(getChildNodeValue(address, XML_AddressLine2));
				add.setAddressLine3(getChildNodeValue(address, XML_AddressLine3));
				add.setCity(getChildNodeValue(address, XML_City));
				add.setCountryCode(getChildNodeValue(address, XML_CountryCode));
				add.setPostalCode(getChildNodeValue(address, XML_PostalCode));
				add.setStateProvinceCode(getChildNodeValue(address, XML_StateProvinceCode));
				Node res = getChildNode(address, XML_ResidentialAddressIndicator);
				if (res != null)
					add.setResidentialAddress(true);
				// set the address reference to the abstract ref to be returned
				addAb = add;
			}
			// build artifact to return
			if (addName.equals(XML_AddressArtifactFormat))
			{
				AddressArtifactFormat aaf = (AddressArtifactFormat) factory.getXPCIContainer("AddressArtifactFormat");
				// consignee name
				aaf.setConsigneeName(getChildNodeValue(address, XML_ConsigneeName));
				// street number low
				aaf.setStreetNumberLow(getChildNodeValue(address, XML_StreetNumberLow));
				// street number high
				aaf.setStreetNumberHigh(getChildNodeValue(address, XML_StreetNumberHigh));
				// street number odd even
				Node snb = getChildNode(address, XML_StreetNumberOddEven);
				if (snb != null)
				{
					if (getChildNode(snb, XML_BothIndicator) != null)
						aaf.setStreetNumberBothIndicator(true);
					if (getChildNode(snb, XML_EvenIndicator) != null)
						aaf.setStreetNumberEvenIndicator(true);
					if (getChildNode(snb, XML_OddIndicator) != null)
						aaf.setStreetNumberOddIndicator(true);
				}
				// street number prefix
				aaf.setStreetNumberPrefix(getChildNodeValue(address, XML_StreetNumberPrefix));
				// street name
				aaf.setStreetName(getChildNodeValue(address, XML_StreetName));
				// street type
				aaf.setStreetType(getChildNodeValue(address, XML_StreetType));
				// street suffix
				aaf.setStreetSuffix(getChildNodeValue(address, XML_StreetSuffix));
				// building name
				aaf.setBuildingName(getChildNodeValue(address, XML_BuildingName));
				// Address extended Information
				Vector aeiVec = new Vector();
				Node aeiNode = null;
				for (aeiNode = getChildNode(address, XML_AddressExtendedInformation); aeiNode != null; aeiNode = aeiNode.getNextSibling())
				{
					if (aeiNode != null && (aeiNode.getNodeType() != Node.TEXT_NODE))
					{
						AddressExtendedInformation aei = (AddressExtendedInformation) factory.getXPCIContainer("AddressExtendedInformation");
						aei.setHigh(getChildNodeValue(aeiNode, XML_High));
						aei.setLow(getChildNodeValue(aeiNode, XML_Low));
						aei.setType(getChildNodeValue(aeiNode, XML_Type));
						if (getChildNode(aeiNode, XML_OddIndicator) != null)
							aei.setOddIndicator(true);
						if (getChildNode(aeiNode, XML_EvenIndicator) != null)
							aei.setEvenIndicator(true);
						if (getChildNode(aeiNode, XML_BothIndicator) != null)
							aei.setBothIndicator(true);
					}
				}
				aaf.setAddressExtendedInformation(aeiVec);
				// political division 4
				aaf.setPoliticalDivision4(getChildNodeValue(address, XML_PoliticalDivision4));
				// political division 3
				aaf.setPoliticalDivision3(getChildNodeValue(address, XML_PoliticalDivision3));
				// political division 2
				aaf.setPoliticalDivision2(getChildNodeValue(address, XML_PoliticalDivision2));
				// political division 1
				aaf.setPoliticalDivision1(getChildNodeValue(address, XML_PoliticalDivision1));
				// country
				aaf.setCountry(getChildNodeValue(address, XML_Country));
				// country code
				aaf.setCountryCode(getChildNodeValue(address, XML_CountryCode));
				// postcode primary high
				aaf.setPostCodePrimaryHigh(getChildNodeValue(address, XML_PostCodePrimaryHigh));
				// postcode primary low
				aaf.setPostCodePrimaryLow(getChildNodeValue(address, XML_PostCodePrimaryLow));
				// post code extended low
				aaf.setPostCodeExtendedLow(getChildNodeValue(address, XML_PostCodeExtendedLow));
				// post code extended high
				aaf.setPostCodeExtendedHigh(getChildNodeValue(address, XML_PostCodeExtendedHigh));
				// set the addressArtifactFormat reference to the abstract ref to be returned
				addAb = aaf;
			}
			// build key to return

			if (addName.equals(XML_AddressArtifactFormat))
			{
				AddressKeyFormat akf = (AddressKeyFormat) factory.getXPCIContainer("AddressKeyFormat");
				akf.setAddressLine1(getChildNodeValue(address, XML_AddressLine1));
				akf.setAddressLine2(getChildNodeValue(address, XML_AddressLine2));
				akf.setBuildingName(getChildNodeValue(address, XML_BuildingName));
				akf.setConsigneeName(getChildNodeValue(address, XML_ConsigneeName));
				akf.setCountry(getChildNodeValue(address, XML_Country));
				akf.setRegion(getChildNodeValue(address, XML_Region));
				akf.setUrbanization(getChildNodeValue(address, XML_Urbanization));
				// set the addressKeyFormat reference to the abstract ref to be returned
				addAb = akf;
			}
			// build token to return

			if (addName.equals(XML_AddressTokenFormat))
			{
				AddressTokenFormat atf = (AddressTokenFormat) factory.getXPCIContainer("AddressTokenFormat");
				// set the addressTokenFormat reference to the abstract ref to be returned
				addAb = atf;
			}
			// build region to return

			if (addName.equals(XML_AddressRegionalFormat))
			{
				AddressRegionalFormat arf = (AddressRegionalFormat) factory.getXPCIContainer("AddressRegionalFormat");
				arf.setPoliticalDivision1(getChildNodeValue(address, XML_PoliticalDivision1));
				arf.setPoliticalDivision2(getChildNodeValue(address, XML_PoliticalDivision2));
				arf.setPoliticalDivision3(getChildNodeValue(address, XML_PoliticalDivision3));
				arf.setPoliticalDivision4(getChildNodeValue(address, XML_PoliticalDivision4));
				arf.setCountry(getChildNodeValue(address, XML_Country));
				arf.setPostCodePrimaryLow(getChildNodeValue(address, XML_PostCodePrimaryLow));

				// set the addressRegionalFormat reference to the abstract ref to be returned
				addAb = arf;
			}
			// build label to return

			if (addName.equals(XML_AddressLabelFormat))
			{
				AddressLabelFormat alf = (AddressLabelFormat) factory.getXPCIContainer("AddressLabelFormat");
				Node alfNode = null;
				Vector alfVec = new Vector();
				for (alfNode = getChildNode(address, XML_UserInput); alfNode != null; alfNode = alfNode.getNextSibling())
				{
					alfVec.addElement(alfNode.getNodeValue());
				}
				// add vector to alf
				
				alf.setUserInput(alfVec);
				// set the addressLabelFormat reference to the abstract ref to be returned
				addAb = alf;
			}
		}
		return addAb;
	} else
	{
		return null;
	}
}
/**
 * This method will populate an instance of a com.ups.xml.beans.Agent.
 *
 * @param org.w3c.dom.Node, com.ups.xml.beans.Agent
 */
protected void buildAgent(Node parent, Agent targetAgent) throws Exception
{
	targetAgent.setAttentionName(getChildNodeValue(parent, XML_AttentionName));
	targetAgent.setCompanyName(getChildNodeValue(parent, XML_CompanyName));

	// build phone number container
	Node faxNum = getChildNode(parent, XML_FaxNumber);
	if (faxNum != null)
	{
		targetAgent.setPhoneNumber(buildPhoneVector(faxNum));
	}
	targetAgent.setName(getChildNodeValue(parent, XML_Name));
	targetAgent.setShipperAssignedID(getChildNodeValue(parent, XML_ShipperAssignedIdentificationNumber));
	targetAgent.setShipperNumber(getChildNodeValue(parent, XML_ShipperNumber));
	targetAgent.setTaxID(getChildNodeValue(parent, XML_TaxIdentificationNumber));

	// build address information container
	targetAgent.setAddress(buildAddressAbstract(parent));

	// build phone number container
	org.w3c.dom.Node phoneNum = getChildNode(parent, XML_PhoneNumber);
	if (phoneNum != null)
	{
		targetAgent.setPhoneNumber(buildPhoneVector(phoneNum));
	}
}
/**
 * 
 * This method constructs one of the children of com.ups.xml.beans.Phone according to the child's 
 * node type of the Node passed to this method.
 *
 * @param parent org.w3c.dom.Node
 * @exception java.lang.Exception
 */
protected Phone buildPhone(Node parent) throws Exception
{
	// build Vector of phone objects to return
	if (parent.hasChildNodes())
	{
		Phone phone = (Phone) factory.getXPCIContainer("Phone");
		Node phoneNode = phoneNode = parent.getFirstChild().getNextSibling();
		if (phoneNode.getNodeType() != Node.TEXT_NODE)
		{
			String phoneName = phoneNode.getNodeName();
			if (phoneName.equals(XML_StructuredPhoneNumber))
			{
				StructuredPhoneNumber spn = (StructuredPhoneNumber) factory.getXPCIContainer("StructuredPhoneNumber");
				spn.setPhoneCountryCode(getChildNodeValue(phoneNode, XML_PhoneCountryCode));
				spn.setPhoneDialPlanNumber(getChildNodeValue(phoneNode, XML_PhoneDialPlanNumber));
				spn.setPhoneExtension(getChildNodeValue(phoneNode, XML_PhoneExtension));
				spn.setPhoneLineNumber(getChildNodeValue(phoneNode, XML_PhoneLineNumber));
				phone = spn;
			}
		}
		return phone;
	}
	return null;
}
/**
 * This method utilizes build phone to construct a vector containing Phone objects
 * 
 * @param parent org.w3c.dom.Node
 * @exception java.lang.Exception
 */
protected Vector buildPhoneVector(Node parent) throws Exception
{
	// build Vector of phone objects to return
	if (parent.hasChildNodes())
	{
		Vector phoneVec = new Vector();
		Node phoneNode = null;
		for (phoneNode = parent.getFirstChild().getNextSibling(); phoneNode != null; phoneNode = phoneNode.getNextSibling())
		{
			if (phoneNode.getNodeType() != Node.TEXT_NODE)
				phoneVec.addElement(buildPhone(phoneNode));
		}
		return phoneVec;
	}
	return null;
}
/**
 * 
 * 
 * 
 */
protected void buildRequest(Document doc, String rootname)
{
	Request req = servReqCont.getRequest();
	AdapterUtility.buildReqHdr(doc, req.getRequestAction(), req.getRequestOption(), req.getCustomerContext(), req.getXpciVersion(), rootname);
}
/**
 * This method will populate the instance variable response with the data found in the
 * referenced XML document.  Handles the Interchange section of the Document.  
 *
 * @param org.w3c.dom.Node  The root node of the current document.
 * @exception java.lang.Exception
 */
protected void buildResponse(Node root) throws Exception
{
	Response resp = (Response) factory.getXPCIContainer("Response");
	Vector errVect = new Vector();
	Node responseNode = getChildNode(root, XML_Response);
	Node transRef = getChildNode(responseNode, XML_TransactionReference);
	resp.setCustomerContext(getChildNodeValue(transRef, XML_CustomerContext));
	resp.setXpciVersion(getChildNodeValue(transRef, XML_XpciVersion));
	resp.setResponseStatusCode(getChildNodeValue(responseNode, XML_ResponseStatusCode));
	resp.setResponseStatusDescription(getChildNodeValue(responseNode, XML_ResponseStatusDescription));
	Node child = null;
	for (child = getChildNode(responseNode, XML_Error); child != null; child = child.getNextSibling())
	{
		if (child.getNodeType() != org.w3c.dom.Node.TEXT_NODE)
		{
			com.ups.xmlsdk.xpci.Error err = (com.ups.xmlsdk.xpci.Error) factory.getXPCIContainer("Error");
			err.setErrorCode(getChildNodeValue(child, XML_ErrorCode));
			err.setErrorDescription(getChildNodeValue(child, XML_ErrorDescription));
			err.setSeverity(getChildNodeValue(child, XML_ErrorSeverity));
			// build the errorLocation section of the error
			Vector errLocVect = new Vector();
			Node son = null;
			for (son = getChildNode(child, XML_ErrorLocation); son != null; son = son.getNextSibling())
			{
				if (son.getNodeType() != org.w3c.dom.Node.TEXT_NODE)
				{
					com.ups.xmlsdk.xpci.ErrorLocation errLoc = (com.ups.xmlsdk.xpci.ErrorLocation) factory.getXPCIContainer("ErrorLocation");
					errLoc.setErrorLocationAttributeName(getChildNodeValue(son, XML_ErrorLocationAttributeName));
					errLoc.setErrorLocationElementName(getChildNodeValue(son, XML_ErrorLocationElementName));
					errLoc.setErrorLocationElementReference(getChildNodeValue(son, XML_ErrorLocationElementReference));
					errLocVect.addElement(errLoc);
				}
			}
			err.setErrorLocation(errLocVect);
			// build the error digest section of the error
			Vector errorDigest = new Vector();
			Node pup = null;
			for (pup = getChildNode(child, XML_ErrorDigest); pup != null; pup = pup.getNextSibling())
			{
				if (pup.getNodeType() != Node.TEXT_NODE)
				{
					errorDigest.addElement(getNodeValue(pup));
				}
			}
			err.setErrorDigest(errorDigest);
			errVect.addElement(err);
		}
	}
	resp.setError(errVect);
	servRespCont.setResponse(resp);
}
// This method creates the XML document and its root node 
protected Document createXMLDocument(String rootName)
{
	Document doc = new TXDocument();
	Element root = doc.createElement(rootName);
	doc.appendChild(root);
	return doc;
}
/**
 * 
 * 
 * 
 * @return java.lang.StringBuffer
 * @param doc org.w3c.dom.Document
 */
protected StringBuffer docToBuffer(Document doc) throws Exception
{
	StringWriter sw = new StringWriter();
	try
	{
		((TXDocument) doc).setVersion("1.0");
		((TXDocument) doc).printWithFormat(sw);
	} catch (Exception e)
	{
		throw e;
	}
	return sw.getBuffer();
}
/**
 * Given a parent node and the child name, returns the child node.
 * @return org.w3c.dom.Node
 * @param nodeName java.lang.String
 */


protected Node getChildNode(org.w3c.dom.Node parent, String nodeName)
{
	if (parent == null)
		return null;
	Node child = null;
	for (child = parent.getFirstChild(); child != null; child = child.getNextSibling())
	{
		if (child.getNodeName().equals(nodeName))
			return child;
	}
	return null;
}
/**
 * Given a parent node and the child node name returns the child node value.
 * @return java.lang.String
 * @param node org.w3c.dom.Node
 * @param fieldName java.lang.String
 */


protected static String getChildNodeValue(Node node, String fieldName)
{
	if (node == null)
		return "";
	String value = "";
	for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling())
	{
		if (child.getNodeName().equals(fieldName))
		{
			value = getNodeValue(child);
		}
	}
	return value;
}
protected  final Document getDocument(String adaptee) throws Exception
{
	Document doc = null;
	try
	{
		if (parser != null)
		{
			StringReader adapteeReader = new StringReader(adaptee);
			InputSource input = new InputSource(adapteeReader);
			parser.parse(input);
			doc = parser.getDocument();
		} else
			throw new Exception("error parsing");
	} catch (SAXException sx)
	{
		Exception ex = sx.getException();
		if (ex != null)
			ex.printStackTrace();
		else
			sx.printStackTrace();
		throw new Exception("Error parsing");
	}
	return doc;
}
protected final static String getNodeValue(Node node)
{
	if (node == null)
		return "";
	NodeList nl = node.getChildNodes();
	if (nl == null)
	{
		return new String("");
	}
	Node value = nl.item(0);
	return value.getNodeValue();
}
}
