package com.ups.xmlsdk.xpci;

/**
 * FileName: XpciFactory.java
 * Date: 10/10/2000
 */

import java.util.Hashtable;

/**
 * XMLBeansFactory is a singleton class, responsible for dynamically loading
 * Beans, keeping track of the loaded Beans, and Returning loaded Beans.
 *
 */

public class XpciFactory
{
	private static XpciFactory classFactory;
	private Hashtable _classTable = new Hashtable();
	private String packageName = "com.ups.xmlsdk.xpci.";
	/**
		Constructor is made private to make sure that class can not be instantiated
	*/
	private XpciFactory(){}
/**
 *	public synchronized Class getBean(String beanName)
 *	This method is responsible for loading the class dynamically,
 *	if the class is not yet loaded.
 *	It keeps track of the load classes in a hashtable.
 *
 *	@return Class
 *	@param beanName String, name of the Bean to be loaded ex: com.ups.xmlsdk.xpci.Package
 */

public synchronized Object getBean(String beanName) throws ClassNotFoundException, IllegalAccessException, InstantiationException
{
	Class classObject = (Class) _classTable.get(beanName);
	if (classObject == null)
	{
		classObject = Class.forName(packageName + beanName);
	}
	_classTable.put(beanName, classObject);
	Object object = classObject.newInstance();
	return object;
}
/**
 * public static XMLBeansFactory getInstance() method is a class method,
 * retuning the class instance
 * @return XpciFactory
 * 
 */

public static XpciFactory getInstance()
{
	if (classFactory == null)
	{
		classFactory = new XpciFactory();
	}
	return classFactory;
}
}
