package com.ups.xmlsdk.xpci;

/**
 * The AddressArtifactFormat Class is to be used as a data container.  The instance variables available
 * in the AddressArtifactFormat Class are those provided by the XPCI for AddressArtifactFormat.
 */
public class AddressArtifactFormat extends AddressAbstract implements java.io.Serializable
{
	private java.lang.String consigneeName;
	private java.lang.String streetNumberLow;
	private java.lang.String streetNumberHigh;
	private java.lang.String streetNumberPrefix;
	private java.lang.String streetName;
	private java.lang.String streetType;
	private java.lang.String streetSuffix;
	private java.lang.String buildingName;
	private java.lang.String politicalDivision4;
	private java.lang.String politicalDivision3;
	private java.lang.String politicalDivision2;
	private java.lang.String politicalDivision1;
	private java.lang.String country;
	private java.lang.String countryCode;
	private java.lang.String postCodePrimaryLow;
	private java.lang.String postCodePrimaryHigh;
	private java.lang.String postCodeExtendedHigh;
	private java.lang.String postCodeExtendedLow;
	private java.util.Vector addressExtendedInformation;
	private boolean streetNumberOddIndicator;
	private boolean streetNumberEvenIndicator;
	private boolean streetNumberBothIndicator;
/**
 * Returns the instance variable value for Address Extended Information.
 * 
 * @return java.util.Vector
 */
public java.util.Vector getAddressExtendedInformation() {
	return addressExtendedInformation;
}
/**
 * 
 * Returns the instance variable value for Address Building Name.
 * 
 * @return java.lang.String
 */
public java.lang.String getBuildingName()
{
	return buildingName;
}
/**
 * 
 * Returns the instance variable value for Address Consignee Name.
 * 
 * @return java.lang.String
 */
public java.lang.String getConsigneeName()
{
	return consigneeName;
}
/**
 * 
 * Returns the instance variable value for Address Country.
 * 
 * @return java.lang.String
 */
public java.lang.String getCountry()
{
	return country;
}
/**
 * 
 * Returns the instance variable value for Address Country Code.
 * 
 * @return java.lang.String
 */
public java.lang.String getCountryCode()
{
	return countryCode;
}
/**
 * 
 * Returns the instance variable value for Address Political Division 1.
 * 
 * @return java.lang.String
 */
public java.lang.String getPoliticalDivision1()
{
	return politicalDivision1;
}
/**
 * 
 * Returns the instance variable value for Address Political Division 2.
 * 
 * @return java.lang.String
 */
public java.lang.String getPoliticalDivision2()
{
	return politicalDivision2;
}
/**
 * 
 * Returns the instance variable value for Address Political Division 3.
 * 
 * @return java.lang.String
 */
public java.lang.String getPoliticalDivision3()
{
	return politicalDivision3;
}
/**
 * 
 * Returns the instance variable value for Address Political Division 4.
 * 
 * @return java.lang.String
 */
public java.lang.String getPoliticalDivision4()
{
	return politicalDivision4;
}
/**
 * 
 * Returns the instance variable value for Address Post Code Extended High.
 * 
 * @return java.lang.String
 */
public java.lang.String getPostCodeExtendedHigh()
{
	return postCodeExtendedHigh;
}
/**
 * 
 * Returns the instance variable value for Address Post Code Extended Low.
 * 
 * @return java.lang.String
 */
public java.lang.String getPostCodeExtendedLow()
{
	return postCodeExtendedLow;
}
/**
 * 
 * Returns the instance variable value for Address Post Code Primary High.
 * 
 * @return java.lang.String
 */
public java.lang.String getPostCodePrimaryHigh()
{
	return postCodePrimaryHigh;
}
/**
 * 
 * Returns the instance variable value for Address Post Code Primary Low.
 * 
 * @return java.lang.String
 */
public java.lang.String getPostCodePrimaryLow()
{
	return postCodePrimaryLow;
}
/**
 * 
 * Returns the instance variable value for Address Street Name.
 * 
 * @return java.lang.String
 */
public java.lang.String getStreetName()
{
	return streetName;
}
/**
 * 
 * Returns the instance variable value for Address Street Number High.
 * 
 * @return java.lang.String
 */
public java.lang.String getStreetNumberHigh()
{
	return streetNumberHigh;
}
/**
 * 
 * Returns the instance variable value for Address Street Number Low.
 * 
 * @return java.lang.String
 */
public java.lang.String getStreetNumberLow()
{
	return streetNumberLow;
}
/**
 * 
 * Returns the instance variable value for Address Street Number Prefix.
 * 
 * @return java.lang.String
 */
public java.lang.String getStreetNumberPrefix()
{
	return streetNumberPrefix;
}
/**
 * 
 * Returns the instance variable value for Address Street Suffix.
 * 
 * @return java.lang.String
 */
public java.lang.String getStreetSuffix()
{
	return streetSuffix;
}
/**
 * 
 * Returns the instance variable value for Address Street Type.
 * 
 * @return java.lang.String
 */
public java.lang.String getStreetType()
{
	return streetType;
}
/**
 * 
 * Returns the instance variable value for Address Street Number OddEven Indicator Both.
 * 
 * @return boolean
 */
public boolean isStreetNumberBothIndicator()
{
	return streetNumberBothIndicator;
}
/**
 * 
 * Returns the instance variable value for Address Street Number Even Indicator.
 * 
 * @return boolean
 */
public boolean isStreetNumberEvenIndicator()
{
	return streetNumberEvenIndicator;
}
/**
 * 
 * Returns the instance variable value for Address Street Number Odd Indicator.
 * 
 * @return boolean
 */
public boolean isStreetNumberOddIndicator()
{
	return streetNumberOddIndicator;
}
/**
 * 
 * Sets the instance variable value for Address Extended Information.
 * 
 * @param newAddressExtendedInformation java.util.Vector
 */
public void setAddressExtendedInformation(java.util.Vector newAddressExtendedInformation)
{
	addressExtendedInformation = newAddressExtendedInformation;
}
/**
 * 
 * Sets the instance variable value for Address Building Name.
 * 
 * @param newBuildingName java.lang.String
 */
public void setBuildingName(java.lang.String newBuildingName)
{
	buildingName = newBuildingName;
}
/**
 * 
 * Sets the instance variable value for Address Consignee Name.
 * 
 * @param newConsigneeName java.lang.String
 */
public void setConsigneeName(java.lang.String newConsigneeName)
{
	consigneeName = newConsigneeName;
}
/**
 * 
 * Sets the instance variable value for Address Country.
 * 
 * @param newCountry java.lang.String
 */
public void setCountry(java.lang.String newCountry)
{
	country = newCountry;
}
/**
 * 
 * Sets the instance variable value for Address Country Code.
 * 
 * @param newCountryCode java.lang.String
 */
public void setCountryCode(java.lang.String newCountryCode)
{
	countryCode = newCountryCode;
}
/**
 * 
 * Sets the instance variable value for Address Political Division 1.
 * 
 * @param newPoliticalDivision1 java.lang.String
 */
public void setPoliticalDivision1(java.lang.String newPoliticalDivision1) {
	politicalDivision1 = newPoliticalDivision1;
}
/**
 * 
 * Sets the instance variable value for Address Political Division 2.
 * 
 * @param newPoliticalDivision2 java.lang.String
 */
public void setPoliticalDivision2(java.lang.String newPoliticalDivision2)
{
	politicalDivision2 = newPoliticalDivision2;
}
/**
 * 
 * Sets the instance variable value for Address Political Division 3.
 * 
 * @param newPoliticalDivision3 java.lang.String
 */
public void setPoliticalDivision3(java.lang.String newPoliticalDivision3)
{
	politicalDivision3 = newPoliticalDivision3;
}
/**
 * 
 * Sets the instance variable value for Address Political Division 4.
 * 
 * @param newPoliticalDivision4 java.lang.String
 */
public void setPoliticalDivision4(java.lang.String newPoliticalDivision4)
{
	politicalDivision4 = newPoliticalDivision4;
}
/**
 * 
 * Sets the instance variable value for Address Post Code Extended High.
 * 
 * @param newPostCodeExtendedHigh java.lang.String
 */
public void setPostCodeExtendedHigh(java.lang.String newPostCodeExtendedHigh)
{
	postCodeExtendedHigh = newPostCodeExtendedHigh;
}
/**
 * 
 * Sets the instance variable value for Address Post Code Extended Low.
 * 
 * @param newPostCodeExtendedLow java.lang.String
 */
public void setPostCodeExtendedLow(java.lang.String newPostCodeExtendedLow)
{
	postCodeExtendedLow = newPostCodeExtendedLow;
}
/**
 * 
 * Sets the instance variable value for Address Post Code Primary High.
 * 
 * @param newPostCodePrimaryHigh java.lang.String
 */
public void setPostCodePrimaryHigh(java.lang.String newPostCodePrimaryHigh)
{
	postCodePrimaryHigh = newPostCodePrimaryHigh;
}
/**
 * 
 * Sets the instance variable value for Address Post Code Primary Low.
 * 
 * @param newPostCodePrimaryLow java.lang.String
 */
public void setPostCodePrimaryLow(java.lang.String newPostCodePrimaryLow)
{
	postCodePrimaryLow = newPostCodePrimaryLow;
}
/**
 * 
 * Sets the instance variable value for Address Street Name.
 * 
 * @param newStreetName java.lang.String
 */
public void setStreetName(java.lang.String newStreetName)
{
	streetName = newStreetName;
}
/**
 * 
 * Sets the instance variable value for Address Street Number Odd/Even Both Indicator.
 * 
 * @param newStreetNumberBothIndicator boolean
 */
public void setStreetNumberBothIndicator(boolean newStreetNumberBothIndicator) {
	streetNumberBothIndicator = newStreetNumberBothIndicator;
}
/**
 * 
 * Sets the instance variable value for Address Street Number Odd/Even Even Indicator.
 * 
 * @param newStreetNumberEvenIndicator boolean
 */
public void setStreetNumberEvenIndicator(boolean newStreetNumberEvenIndicator)
{
	streetNumberEvenIndicator = newStreetNumberEvenIndicator;
}
/**
 * 
 * Sets the instance variable value for Address Street Number High.
 * 
 * @param newStreetNumberHigh java.lang.String
 */
public void setStreetNumberHigh(java.lang.String newStreetNumberHigh)
{
	streetNumberHigh = newStreetNumberHigh;
}
/**
 * 
 * Sets the instance variable value for Address Street Number Low.
 * 
 * @param newStreetNumberLow java.lang.String
 */
public void setStreetNumberLow(java.lang.String newStreetNumberLow)
{
	streetNumberLow = newStreetNumberLow;
}
/**
 * 
 * 
 * 
 * @param newStreetNumberOddIndicator boolean
 */
public void setStreetNumberOddIndicator(boolean newStreetNumberOddIndicator) {
	streetNumberOddIndicator = newStreetNumberOddIndicator;
}
/**
 * 
 * Sets the instance variable value for Address Street Number Prefix.
 * 
 * @param newStreetNumberPrefix java.lang.String
 */
public void setStreetNumberPrefix(java.lang.String newStreetNumberPrefix)
{
	streetNumberPrefix = newStreetNumberPrefix;
}
/**
 * 
 * Sets the instance variable value for Address Street Suffix.
 * 
 * @param newStreetSuffix java.lang.String
 */
public void setStreetSuffix(java.lang.String newStreetSuffix)
{
	streetSuffix = newStreetSuffix;
}
/**
 * 
 * Sets the instance variable value for Address Street Type.
 * 
 * @param newStreetType java.lang.String
 */
public void setStreetType(java.lang.String newStreetType)
{
	streetType = newStreetType;
}
/**
 * Returns the beans data as a String of XML Nodes.
 * @return java.lang.String
 */
public String toString()
{
	StringBuffer objXml = new StringBuffer();
	objXml.append("<AddressArtifactFormat>");
	// consignee name
	objXml.append("</ConsigneeName>");
	objXml.append(consigneeName);
	objXml.append("<ConsigneeName>");
	// street number low
	objXml.append("<StreetNumberLow>");
	objXml.append(streetNumberLow);
	objXml.append("</StreetNumberLow>");
	// street number high
	objXml.append("<StreetNumberHigh>");
	objXml.append(streetNumberHigh);
	objXml.append("</StreetNumberHigh>");
	// street number odd Even
	objXml.append("<StreetNumberOddEven>");
	if (streetNumberBothIndicator)
		objXml.append("<BothIndicator/>");
	if (streetNumberEvenIndicator)
		objXml.append("<EvenIndicator/>");
	if (streetNumberOddIndicator)
		objXml.append("<OddIndicator/>");
	objXml.append("</StreetNumberOddEven>");
	// street number prefix
	objXml.append("<StreetNumberPrefix>");
	objXml.append(streetNumberPrefix);
	objXml.append("</StreetNumberPrefix>");
	// street name
	objXml.append("<StreetName>");
	objXml.append(streetName);
	objXml.append("</StreetName>");
	// street type
	objXml.append("<StreetType>");
	objXml.append(streetType);
	objXml.append("</StreetType>");
	// street suffix
	objXml.append("<StreetSuffix>");
	objXml.append(streetSuffix);
	objXml.append("</StreetSuffix>");
	// building name
	objXml.append("<BuildingName>");
	objXml.append(buildingName);
	objXml.append("</BuildingName>");
	// address extended information

	java.util.Enumeration enum = addressExtendedInformation.elements();
	while (enum.hasMoreElements())
	{
		AddressExtendedInformation aei = (AddressExtendedInformation) enum.nextElement();
		aei.toString();
	}
	// Political Division 4
	objXml.append("<PoliticalDivision4>");
	objXml.append(politicalDivision4);
	objXml.append("</PoliticalDivision4>");
	// Political Division 3
	objXml.append("<PoliticalDivision3>");
	objXml.append(politicalDivision3);
	objXml.append("</PoliticalDivision3>");
	// Political Division 2
	objXml.append("<PoliticalDivision2>");
	objXml.append(politicalDivision2);
	objXml.append("</PoliticalDivision2>");
	// Political Division 1
	objXml.append("<PoliticalDivision1>");
	objXml.append(politicalDivision1);
	objXml.append("</PoliticalDivision1>");
	// country
	objXml.append("<Country>");
	objXml.append(country);
	objXml.append("</Country>");
	// country code
	objXml.append("<CountryCode>");
	objXml.append(countryCode);
	objXml.append("</CountryCode>");
	// post code primary high
	objXml.append("<PostCodePrimaryHigh>");
	objXml.append(postCodePrimaryHigh);
	objXml.append("</PostCodePrimaryHigh>");
	// post code primary low
	objXml.append("<PostCodePrimaryLow>");
	objXml.append(postCodePrimaryLow);
	objXml.append("</PostCodePrimaryLow>");
	// post code extended high
	objXml.append("<PostCodeExtendedHigh>");
	objXml.append(postCodeExtendedHigh);
	objXml.append("</PostCodeExtendedHigh>");
	// post code extended low
	objXml.append("<PostCodeExtendedLow>");
	objXml.append(postCodeExtendedLow);
	objXml.append("</PostCodeExtendedLow>");
	// end tag
	objXml.append("</AddressArtifactFormat>");
	return objXml.toString();
}
}
