package com.ups.xmlsdk.util.logging;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/

import java.util.Date;
import com.ups.xmlsdk.util.MarkUp;
import com.ups.xmlsdk.util.formatter.SyncSimpleDateFormat;
/**
 * Implement a default log record formatting class. 
 */
public class XMLLogFormatter implements LogFormatter
{
	int maxRecLen = 256;
	static final String sep = " ";
	/**
	 * Append a character to the buffer as a readable 7-bit US ASCII string. For
	 * characters in the range 0x20-0x7e, this is a single printable character,
	 * otherwise it is a 2-character ascii hex sequence of the form <XX>.
	 * For greater than 8-bit characters it is a 4-byte delimited hex sequence
	 * <XXXX>.
	 * @return the length in bytes of the appended string.
	 */
	public final int appendAscii(int spaceLeft, StringBuffer buf, char c)
	{
		if (c > 0xff)
		{
			if (spaceLeft < 6) return 0;
			buf.append("<");
			if (c <= 0xfff) buf.append('0');
			buf.append(Integer.toHexString(c)).append(">");
			return 6;
		}
		else if ((c < 0x20) || (c > 0x7e))
		{
			if (spaceLeft < 4) return 0;
			buf.append("<");
			if (c <= 0xf) buf.append('0');
			buf.append(Integer.toHexString(c)).append(">");
			return 4;
		}
		else
		{
			if (spaceLeft < 1) return 0;
			buf.append(c);
			return 1;
		}
	}
	public void format(StringBuffer buf, Date time,
		String facility, int priority, String id, String msg, long code)
			throws LogException
	{
		if ((priority < 0) || (priority > LOG_ALL))
		{
			throw new LogException("log priority out of range");
		}
		buf.setLength(0);
		formatHeader(buf, time, facility, priority, id, false);
		int hdrLen = buf.length();
		while((msg = formatMessage(hdrLen, buf, msg, code)) != null)
		{
			formatHeader(buf, time, facility, priority, id, true);
		}
	}
	/**
	 * Make up for weak output formatting in java Format classes
	 */
	public static StringBuffer formatField(
			StringBuffer sb, String s, int width, boolean left)
	{
		int l = s.length();
		if (l < width)
		{
			int pad = width - l;
			if (left)
			{
				sb.append(s);
				for (int i=0; i<pad; i++) sb.append(' ');
			}
			else
			{
				for (int i=0; i<pad; i++) sb.append(' ');
				sb.append(s);
			}
		}
		else
		{
			sb.append(s);
		}
		return sb;
	}
/**
 * Format a log record header and append to the buffer.
 */
public void formatHeader(StringBuffer buf, Date time, String facility, int priority, String id, boolean cont)
{
	if (cont)
		buf.append("\n");
	SyncSimpleDateFormat df = new SyncSimpleDateFormat("MM/dd/yyyy HH:mm:ss.SSS");
	buf.append(df.format(time)).append(sep);
	df.release();
	buf.append(priStr[priority]).append(sep);
	buf.append(id).append(sep);
	formatField(buf, facility, 4, true);
	buf.append(cont ? sepA : sep2);
}
	/**
	 * Append a message and code to the buffer.  If the record exceeds the
	 * allowable record length return a non-null String remainder.
	 */
	public String formatMessage(int hdrLen, StringBuffer buf,
											String msg, long code)
	{
		int spaceLeft = maxRecLen - hdrLen;
		if (code != CODE_UNSET)
		{
			int l = buf.length();
			buf.append("(").append(code).append(") ");
			spaceLeft -= (l - buf.length());
		}
		for (int i=0; i<msg.length(); i++)
		{
			int appended = appendAscii(spaceLeft, buf, msg.charAt(i));
			if (appended == 0) return msg.substring(i);
			else spaceLeft -= appended;
		}
		return null;
	}
	public int getMaxRecLen()
	{
		return maxRecLen;
	}
	public void setMaxRecLen(int m)
	{
		maxRecLen = m;
	}
}
