package com.ups.xmlsdk.util.logging;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/

import java.util.Date;

/**
 * Interface for formatting log records.  Takes a record and converts it
 * into a string record for writing to a file.
 */
public interface LogFormatter extends LogDefs
{
	public void format(StringBuffer buf, Date time, String facility,
		int priority, String id, String msg, long code) throws LogException;
	public int getMaxRecLen();
	public void setMaxRecLen(int m);
}
