package com.ups.xmlsdk.util.logging;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/

import java.io.*;
import java.util.Date;

/**
 * File logging class
 */
public class LogFile extends Logger
{
	BufferedWriter file;

	public LogFile(String facility, String filePath, boolean append)
		throws IOException
	{
		super(facility);
		file = new BufferedWriter(new FileWriter(filePath, append));
	}
	public void close() throws IOException
	{
		file.close();
	}
	public final int log(LogContext context, String facility,
		int priority, String msg, long code) throws LogException
	{	
		if (priority > level) return level;
		try
		{
			StringBuffer cb = context.getBuffer();
			synchronized(cb)
			{
				formatter.format(cb, new Date(), facility, priority,
					context.getId(), msg, code);
				file.write(cb.toString() + "\n");
				file.flush();
			}
		}
		catch(Exception e)
		{
			throw new LogException(e.getMessage());
		}
		return level;
	}
}
