package com.ups.xmlsdk.util.logging;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/

/**
 * Interface for creating and managing loggers.
 */
public interface LogFactory
{
	/**
	 * Add a logger, indexed by its facility.
	 */
	public void addLogger(Logger l);
	/**
	 * Get the default logger for the application
	 */
	public Logger getDefaultLogger();
	/**
	 * Get the logger for the given facility, or null if there is none.
	 */
	public Logger getLogger(String facility);
	/**
	 * Set the default logger for the application
	 */
	public void setDefaultLogger(Logger l);
}
