package com.ups.xmlsdk.util.logging;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/

import java.io.Serializable;

/*
 * Generate a context string for a log entry.  This is for the user to
 * customize the record contents for the application.  The context also
 * maintains the thread-specific buffer for formatting records.
 */

public class LogContext
{
	StringBuffer logBuf = new StringBuffer();

	/**
	 * Return the log user's log buffer
	 */
	public final StringBuffer getBuffer() { return logBuf; }
	/**
	 * Return an identifying string for this record instance.  This should be
	 * customized by a nontrivial application to contain user ID, etc.
	 */
	public String getId()
	{
		return Thread.currentThread().toString();
	}
}
