package com.ups.xmlsdk.util.logging;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/

import java.io.*;
import java.util.Date;

/**
 * Simple Console logging class.
 */
public class LogConsole extends Logger
{
	public static final int MAX_RECSIZE = 1024;

	BufferedWriter file;
	int recsize = MAX_RECSIZE;

	public LogConsole(String facility)
	{
		super(facility);
	}
	public void close() throws IOException {}
	public final int log(LogContext context, String facility, int priority,
		String msg, long code) throws LogException
	{	
		if (priority > level) return level;
		try
		{
			StringBuffer cb = context.getBuffer();
			formatter.format(cb, new Date(), facility, priority,
				context.getId(), msg, code);
			synchronized(cb)
			{
				System.out.println(cb);
			}
		}
		catch(Exception e)
		{
			throw new LogException(e.getMessage());
		}
		return level;
	}
}
