package com.ups.xmlsdk.util.logging;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/

import java.util.*;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.SimpleTimeZone;
import com.ups.xmlsdk.util.formatter.SyncSimpleDateFormat;
import com.ups.xmlsdk.util.config.AppConfig;

/**
 * Define a log wrapper for the primary that reads the "Log" property
 * from an AppConfig instance at regular intervals.  This property string
 * is set in the iss options file and is of the form:
 *
 *   Log = <severity> [, fac1:<severity>, fac2:<severity>]
 *
 *   where severity codes (adapted from UNIX syslog) are:
 *     0 - emergency
 *     1 - alert
 *     2 - critical
 *     3 - error
 *     4 - warning
 *     5 - notice
 *     6 - info
 *     7 - debug
 *     8 - call trace
 *
 *   and facility codes are:
 *     av  - address validation
 *     cc  - credit card
 *     cms - general cms messaging
 *     db  - database
 *     lbl - label generator
 *     ods - ODS pickup
 *     pld - pld messages
 *     rav - rave
 *
 *  It allows the specification of a default logging severity
 *  and one or more modified values for individual facilities.
 *
 */
public class LogConfigReader extends Logger
{
	int cnt = -1;
	int ival = 25; // (re)read config every 25 log calls
	Hashtable facSev = null;
	AppConfig config;
	int[] Counts = new int[12];
	long timeOfLastCountWrite;
	public static final String dateTimeFormatStr = "MM/dd HH:mm:ss";
	public LogConfigReader(AppConfig config, Logger primary)
	{
		super(primary.getFacility(), primary);
		this.config = config;
		primary.setLevel(LOG_ALL);
	}
	public final int log(LogContext context, String facility, int priority,
		String msg, long code) throws LogException
	{
	// Count messages by priority. If special priority: exit now, there is no message.
	if (LogCount(priority) == 1)return 0;

		if ((++cnt % ival) == 0)
		{
			// refresh from config
			// level = LOG_ALL;
			facSev = null;
			String cfgSeverity = null;
			try
			{
				cfgSeverity = config.getString("LogLevel");
			}
			catch(Exception e) {}
			if (cfgSeverity != null)
			{
			  StringTokenizer st = new StringTokenizer(cfgSeverity, ",");
			  while(st.hasMoreTokens())
			  {
				String t = st.nextToken().trim().toUpperCase();
				int i = t.indexOf(':');
				if (i == -1)
				{
					// look for system severity setting
					try
					{
						int iSev= Integer.parseInt(t);
						if (iSev < 0) iSev = 0;
						else if (iSev > LOG_ALL) iSev = LOG_ALL;
						level = iSev;
					}
					catch(NumberFormatException ne) {}
				}
				else
				{
					// look for facility severity setting
					if (facSev == null)
					{
						facSev = new Hashtable();
					}
					String fac = t.substring(0, i);
					if (fac != null && fac.length() > 0)
					{
						String sev = t.substring(i+1);
						if (sev != null && sev.length() > 0)
						{
							try
							{
								int iSev= Integer.parseInt(sev);
								if (iSev < 0) iSev = 0;
								else if (iSev > LOG_ALL) iSev = LOG_ALL;
								facSev.put(fac, new Integer(iSev));
							}
							catch(NumberFormatException ne) {}
						}
					}
				}
			  }
			}
		}

		// threshold
		if (facSev != null)
		{
			Integer sev = (Integer)facSev.get(facility);
			if (sev != null)
			{
				int iSev = sev.intValue();
				if (priority > iSev) return iSev;
			}
			else
			{
				if (priority > level) return level;
			}
		}
		else
		{
			if (priority > level) return level;
		}

		// output
		super.log(context, facility, priority, msg, code);
		return level;
	}
  private int LogCount(int priority)
  {
		int i;

	if (priority >= LogDefs.LOG_START_SESSION && priority <= LogDefs.LOG_PRINT_LABEL)
	{
	    Counts[priority  - LogDefs.LOG_START_SESSION + 9]++;
	  return 1;
	}else{
	  if (priority >= 0 && priority <= 8)
	  {
	  	Counts[priority]++;
	  }
	}

	long milliseconds = new Date().getTime();

	if (milliseconds - timeOfLastCountWrite < 60000)return 0;
		timeOfLastCountWrite = milliseconds;

		String port = System.getProperty("args.port");
		if (port == null || port.equals(""))
		{
			port = "?";
		}
	try{
			SyncSimpleDateFormat sdf = new SyncSimpleDateFormat(dateTimeFormatStr);
			String timeString  = sdf.format( new Date() ) ;
			sdf.release();
	 		BufferedWriter file = new BufferedWriter(new FileWriter("/export/netsite/ext-admin/logs/sdk/SDKLogCounts.tmp",true));
   	        file.write(timeString + " Port " + port + " Log Counts: " +
			  String.valueOf(Counts[0]) + " " +
	      String.valueOf(Counts[1]) + " " +
	      String.valueOf(Counts[2]) + " " +
	      String.valueOf(Counts[3]) + " " +
	      String.valueOf(Counts[4]) + " " +
	      String.valueOf(Counts[5]) + " " +
	      String.valueOf(Counts[6]) + " " +
	      String.valueOf(Counts[7]) + " " +
	      String.valueOf(Counts[8]) + " " +
	      String.valueOf(Counts[9]) + " " +
	      String.valueOf(Counts[10]) + " " +
	      String.valueOf(Counts[11]) + "\n");
	  file.close();
	  for(i = 0; i < 12; i++)Counts[i] = 0;
	}
	catch (Exception e)
	{
	}
	return 0;
  }        
}
