package com.ups.xmlsdk.util.config;

/*
**
** The use, disclosure, reproduction, modification, transfer, or transmittal
** of this work for any purpose in any form or by any means without the
** written permission of United Parcel Service is strictly prohibited.
**
** Confidential, Unpublished Property of United Parcel Service.
** Use and Distribution Limited Solely to Authorized Personnel.
**
** Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
**
*/

import java.io.*;
import java.util.*;
import com.ups.xmlsdk.util.logging.*;


/**
 * ConfigUpdater monitors the application's config file, and if that's updated,
 * it sets the new parameters in AppInfo.
 *
 */
public class ConfigUpdater extends Thread
{
	// Constants
	static private final String THREAD_NAME = "ConfigUpdaterThread";
	private int configUpdaterSleepTime;
	private boolean stop;
	private long lastModified;
	private AppConfig ac;
	/**
	 * Constructor.
	 */
	public ConfigUpdater(AppConfig acIn, int wakeUpInterval)
	{
		super(THREAD_NAME);
		ac = acIn;
		configUpdaterSleepTime = wakeUpInterval;
		stop = false;
		lastModified = 0;
	}
	/**
	 * Runs the CacheMonitorThread process.
	 */
	public void run()
	{
		while (stop == false)
		{
			try
			{
				// Sleep
				sleep(configUpdaterSleepTime);
				if (updateConfig())
				{
					ac.notifyChanged();
				}
			}
			catch (InterruptedException ie)
			{
				stop = true;
			}
			catch (Exception e)
			{
				stop = true;
			}
		}

   }         
	/**
	 * Set the stop flag to true.
	 */
	protected void setStop()
	{
		stop = true;
	}
   /**
	* Checks and returns the number of sequences in the database that are deemed "too old".
	*/
   private boolean updateConfig()
	   throws Exception
   {
   		boolean configChanged = false;

   		String configFileName = ac.getConfigFileName();
		if (configFileName == null || configFileName.length() < 1)
		{
			ac.logger.error("ConfigUpdater: configFileNotSet");
			throw new Exception("ConfigUpdater: configFileNotSet");
		}

		File cfgFile = new File(configFileName);
		if (lastModified != cfgFile.lastModified())
		{
			lastModified = cfgFile.lastModified();
			LineNumberReader optionLineReader = null;
			try
			{
				optionLineReader = new LineNumberReader ( new FileReader ( configFileName ) );

				StringTokenizer tokenLine = null;
				String line = optionLineReader.readLine();
				String key = null;
				String value = null;

				while ( line != null )
				{
					tokenLine = new StringTokenizer( line , ":=");
					try
					{
						key = (String) tokenLine.nextElement();
	                    value = line.substring(key.length() + 1);
		                key = key.trim();
			            value = value.trim();

					    // Check if value has changed.
						try
	                    {
							String currentValue = ac.getString(key);
	    	                if (!currentValue.equals(value))
		    	            {
			    	        	ac.setString(key, value);
						        configChanged = true;
				        	}
	                    }
		                catch (ConfigValueNotFoundException cvnf) // if not there, add it.
			            {
							ac.logger.error("ConfigUpdater: Config value not found: "
								+ cvnf.getMessage());
				        	ac.setString(key, value);
					        configChanged = true;
						}
		                catch ( Exception e ) // Any other error, skip it.
			            {
							// SCR 5706 - This catch gets blank lines and comments
							// no need for log message
							//ac.logger.error("ConfigUpdater: Update, Exception: "
							//	+ e.getMessage());
				        }
				    }
					catch ( Exception e )
	                {
						//ac.logger.error("ConfigUpdater: Update, Exception: "
					  //  	+ e.getMessage());
		            }

			        line = optionLineReader.readLine();
				}
	            optionLineReader.close();
		    }
			catch (Exception e)
	        {
		    	try
			    {
					optionLineReader.close();
	            }
		        catch (Exception e2)
			    {
				}

				ac.logger.error("ConfigUpdater: Update, Exception: "
					+ e.getMessage());
			}
		}
		return configChanged;
	}
}
