package com.ups.xmlsdk.util;

import java.applet.*;
import java.awt.*;
import java.awt.Toolkit;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import java.awt.image.*;

/**
 * This Class will allow you to print a label image from a
 * base64 encoded string generated by the FOSS system
 *
 * Creation date: (6/9/00 9:34:44 AM)
 * @author: Jeffrey A. York
 */

public class LabelPrint extends Frame
{
	// instance variable to hold string from FOSS system 
	private String image;
	// instance variable created by decoding string and creating gif image
	protected Image i;
	// instance variable to hold decoded image data
	protected byte gifFile[];
	
/**
 * LabelPrintGen constructor comment.
 */
public LabelPrint()
{
	super();
}
/**
 * This method takes a base 64 encoded graphic image.  The class
 * is a controller class for printing the image.
 * Creation date: (6/1/00 9:42:48 AM)
 * @param param byte
 */
public void decodeNDisplay()
{
	// Decode the image
	System.out.println("Decoding Image");
	gifFile = Base64.base64Decode(image.getBytes());
	System.out.println("Decoding Image complete");
	if (gifFile == null)
	{
		System.out.println("gifFile is null");
		System.exit(-1);
	}
	//convert the bytes to an image type
	i = this.getToolkit().createImage(gifFile,0,gifFile.length);

	// scale the image to a usable image unfortunately pixelates the image
	//	i = i.getScaledInstance(673,399,i.SCALE_REPLICATE);

	// display the label to the user
	this.setTitle("This is your UPS label");
	this.setSize(673,399);
	this.show();
	System.out.println("The Label is now visible");
}
/**
 * Insert the method's description here.
 * Creation date: (6/12/00 8:40:36 AM)
 */
public void display()
{ //convert the bytes to an image type
	i = this.getToolkit().createImage(gifFile, 0, gifFile.length);

	// scale the image to a usable image unfortunately pixelates the image
	//	i = i.getScaledInstance(673,399,i.SCALE_REPLICATE);

	// display the label to the user
	this.setTitle("This is your UPS label");
	this.setSize(673, 399);
	this.show();
	System.out.println("The Label is now visible");
}
/**
 * Insert the method's description here.
 * Creation date: (6/8/00 8:26:13 AM)
 * @return java.lang.String
 */
public java.lang.String getImage() {
	return image;
}
/**
 * Insert the method's description here.
 * Creation date: (6/8/00 8:07:51 AM)
 * @param g java.awt.Graphics
 */
public void paint(Graphics g)
{
	g.drawImage(i,0,0,673,399,0,0,1300,800,this);
}
/**
 * Insert the method's description here.
 * Creation date: (6/8/00 8:08:28 AM)
 */
public void print()
{
	// the toolkit of the current OS
	Toolkit toolkit = this.getToolkit();
	// create the printJob for hardcopy printing
	PrintJob pj = toolkit.getPrintJob(this,"UPS Label Generator",null);
	if (pj ==null) System.exit(-1); //handles cancel on print dialog
	// generate the Graphics object that is printed
	Graphics pg = pj.getGraphics();
	// Frame contents to raphics object
	this.printAll(pg);
	// send Graphics object to device
	pg.dispose();
	// end the PrintJob to clear up the resources
	pj.end();
		
}
/**
 * Insert the method's description here.
 * Creation date: (6/12/00 8:37:08 AM)
 * @param imagedata java.lang.Byte[]
 */
public void setImage(byte[] imagedata) {
	gifFile = imagedata;}
/**
 * Insert the method's description here.
 * Creation date: (6/8/00 8:26:13 AM)
 * @param newImage java.lang.String
 */
public void setImage(java.lang.String newImage) {
	image = newImage;
}
}
