package com.ups.xmlsdk.tnt;

import com.ups.xmlsdk.xpci.ServiceSummary;
import com.ups.xmlsdk.xpci.TransitResponse;
import java.util.Vector;
import org.w3c.dom.Node;
import com.ups.xmlsdk.*;
import com.ups.xmlsdk.util.SDKException;
import com.ibm.xml.parser.LibraryException;
import org.w3c.dom.Element;
import org.w3c.dom.Document;
public class TimeInTransitAdapter extends Adapter
{
	private com.ups.xmlsdk.xpci.AddressAbstract transitFrom;
	private com.ups.xmlsdk.xpci.AddressAbstract transitTo;
	private java.lang.String pickupDate;
	private java.lang.String time;
	private java.lang.String shipmentWeight;
	private java.lang.String shipmentWeightUOMCode;
	private java.lang.String shipmentWeightUOMDesc;
	private boolean residentialAddressIndicator;
	private boolean documentsOnlyIndicator;
	private java.lang.String invoiceMonetaryValue;
	private java.lang.String invoiceCurrencyCode;
	private static final java.lang.String TNTRoot = "TimeInTransitRequest";

	// for Response Adaption
	private java.util.Vector transitFromList;
	private java.util.Vector transitToList;
	private java.util.Vector transitResponse;
/**
 * TimeInTransitRequest constructor comment.
 */
public TimeInTransitAdapter() {
	super();
}
/**
 * This method will construct a ShipmentAcceptRequest based on the Beans data.
 * @return java.lang.StringBuffer
 */
public StringBuffer buildTNTXml(String digest, com.ups.xmlsdk.xpci.Request request) throws Exception
{
	StringBuffer xmlBuf = new StringBuffer();
	Document doc = createXMLDocument(TNTRoot);
	Element root = doc.getDocumentElement();
	root.setAttribute("xml:lang", "en-US");
	try
	{
		buildRequest(doc, TNTRoot);
		// transit to
		AdapterUtility.buildAddress(doc, XML_TransitTo, transitTo);
		// transit from
		AdapterUtility.buildAddress(doc, XML_TransitFrom, transitFrom);
		// pickup date
		AdapterUtility.addNode(doc, TNTRoot, XML_PickupDate, pickupDate, null, null);
		// Shipment Weight
		AdapterUtility.addNode(doc, TNTRoot, XML_ShipmentWeight, null, null, null);
		AdapterUtility.addNode(doc, XML_ShipmentWeight, XML_Weight, shipmentWeight, null, null);
		AdapterUtility.addNode(doc, XML_ShipmentWeight, XML_UnitOfMeasurement, null, null, null);
		AdapterUtility.addNode(doc, XML_UnitOfMeasurement, XML_Code, shipmentWeightUOMCode, null, null);
		AdapterUtility.addNode(doc, XML_UnitOfMeasurement, XML_Description, shipmentWeightUOMDesc, null, null);
		// Time
		AdapterUtility.addNode(doc, TNTRoot, XML_Time, time, null, null);
		// invoice
		AdapterUtility.addNode(doc, TNTRoot, XML_InvoiceLineTotal, null, null, null);
		AdapterUtility.addNode(doc, XML_InvoiceLineTotal, XML_MonetaryValue, invoiceMonetaryValue, null, null);
		AdapterUtility.addNode(doc, XML_InvoiceLineTotal, XML_CurrencyCode, invoiceCurrencyCode, null, null);
		// res indicator
		if (residentialAddressIndicator)
			AdapterUtility.addNode(doc, TNTRoot, XML_ResidentialAddressIndicator, null, null, null);
		// docs indicator
		if (documentsOnlyIndicator)
			AdapterUtility.addNode(doc, TNTRoot, XML_DocumentsOnly, null, null, null);
		// document to StringBuffer
		xmlBuf = docToBuffer(doc);
	} catch (LibraryException le)
	{
		String errMsg = "Library Exception";
		throw new SDKException(errMsg, SDKException.UNDETERMINED);
	} catch (java.io.IOException ie)
	{
		String errMsg = "IOException";
		throw new SDKException(errMsg, SDKException.UNDETERMINED);
	} catch (Exception e)
	{
		String errMsg = "Probably caused by insufficient data-" + e.getMessage();
		throw new SDKException(errMsg, SDKException.XML_PROCESSING_ERROR);
	}
	return xmlBuf;
}
/**
 * 
 * 
 * 
 * @return java.util.Vector
 */
public java.util.Vector getTransitFromList() {
	return transitFromList;
}
/**
 * 
 * 
 * 
 * @return java.util.Vector
 */
public java.util.Vector getTransitResponse() {
	return transitResponse;
}
/**
 * 
 * 
 * 
 * @return java.util.Vector
 */
public java.util.Vector getTransitToList() {
	return transitToList;
}
/**
 * 
 * 
 * 
 * @param xmlIn java.lang.StringBuffer
 * @exception com.ups.xml.util.SDKException The exception description.
 */
public void parseDocument(StringBuffer xmlIn) throws Exception
{
	try
	{
		Document doc = getDocument(xmlIn.toString());
		org.w3c.dom.Node root = doc.getFirstChild();
		// get reponse
		buildResponse(root);
		// walk and retrieve the data
		Node tranResp = null;
		Vector trVec = new Vector();
		for (tranResp = getChildNode(root, XML_TransitResponse); tranResp != null; tranResp = tranResp.getNextSibling())
		{
			TransitResponse tr = (TransitResponse) factory.getXPCIContainer("TransitResponse");
			// Service Summary
			Node servSum = null;
			Vector servVec = new Vector();
			for (servSum = getChildNode(tranResp, XML_ServiceSummary); servSum != null; servSum = servSum.getNextSibling())
			{
				if (servSum.getNodeName().equalsIgnoreCase(XML_ServiceSummary))
				{
					ServiceSummary serv = (ServiceSummary) factory.getXPCIContainer("ServiceSummary");
					Node service = getChildNode(servSum, XML_Service);
					if (service != null)
					{
						serv.setServiceCode(getChildNodeValue(service, XML_Code));
						serv.setServiceDescription(getChildNodeValue(service, XML_Description));
					}
					// guaranteed
					Node guar = getChildNode(servSum, XML_Guaranteed);
					if (guar != null)
					{
						serv.setGuaranteedCode(getChildNodeValue(guar, XML_Code));
						serv.setGuaranteedDescription(getChildNodeValue(guar, XML_Description));
					}
					// estimated arrival
					Node estimate = getChildNode(tranResp, XML_EstimatedArrival);
					if (estimate != null)
					{
						// day of week
						serv.setDayOfWeek(getChildNodeValue(estimate, XML_DayOfWeek));
						// date
						serv.setDate(getChildNodeValue(estimate, XML_Date));
						// time
						serv.setTime(getChildNodeValue(estimate, XML_Time));
						// business transit days
						serv.setBusinessTransitDays(getChildNodeValue(estimate, XML_BusinessTransitDays));
						// total transit days
						serv.setTotalTransitDays(getChildNodeValue(estimate, XML_TotalTransitDays));
						// customer cutoff
						serv.setCustomerCenterCutOff(getChildNodeValue(estimate, XML_CustomerCenterCutoff));
						// rest days
						serv.setRestDays(getChildNodeValue(estimate, XML_RestDays));
						// holiday count
						serv.setHolidayCount(getChildNodeValue(estimate, XML_HolidayCount));
						// next day pickup
						Node next = getChildNode(tranResp, XML_NextDayPickupIndicator);
						if (next != null)
							serv.setNextDayPickupIndicator(true);
						// delay count
						serv.setDelayCount(getChildNodeValue(estimate, XML_DelayCount));
					}
					// add service summary to vector
					servVec.addElement(serv);
				}
			}
			tr.setServiceSummary(servVec);
			// documents indicator
			Node docInd = getChildNode(tranResp, XML_DocumentsOnly);
			if (docInd != null)
				tr.setDocumentsIndicator(true);
			// auto duty indicator
			Node auto = getChildNode(tranResp, XML_AutoDutyIndicator);
			if (auto != null)
				tr.setAutoDutyIndicator(true);
			// transit from
			tr.setTransitFrom(buildAddressAbstract(getChildNode(tranResp, XML_TransitFrom)));
			// transit to
			tr.setTransitTo(buildAddressAbstract(getChildNode(tranResp, XML_TransitTo)));
			// shipment weight
			Node sw = getChildNode(tranResp, XML_ShipmentWeight);
			if (sw != null)
			{
				Node wt = getChildNode(sw, XML_Weight);
				if (wt != null)
					tr.setShipmentWeight(wt.getNodeValue());
				Node UOM = getChildNode(sw, XML_UnitOfMeasurement);
				if (UOM != null)
				{
					tr.setShipmentWeightUOMCode(getChildNodeValue(UOM, XML_Code));
					tr.setShipmentWeightUOMDesc(getChildNodeValue(UOM, XML_Description));
				}
			}
			// POD days
			Node poddays = getChildNode(tranResp, XML_PODDays);
			if (poddays != null)
				tr.setPodDays(poddays.getNodeValue());
			// PODDate
			Node podDate = getChildNode(tranResp, XML_PODDate);
			if (podDate != null)
				tr.setPodDate(podDate.getNodeValue());
			// residential indicator
			Node res = getChildNode(tranResp, XML_ResidentialAddressIndicator);
			if (res != null)
				tr.setResidentialAddressIndicator(true);
			// add tr to vector
			trVec.addElement(tr);
		}
		transitResponse = trVec;
		Node toList = getChildNode(root, XML_TransitToList);
		if (toList != null)
		{
			Node cand = null;
			Vector candVec = new Vector();
			for (cand = getChildNode(toList, XML_Candidate); cand != null; cand = cand.getNextSibling())
			{
			}
			transitToList = candVec;
		}
		Node fromList = getChildNode(root, XML_TransitFromList);
		if (fromList != null)
		{
			Vector candVec = new Vector();
			Node cand = null;
			for (cand = getChildNode(fromList, XML_Candidate); cand != null; cand = cand.getNextSibling())
			{
			}
			transitFromList = candVec;
		}
	} catch (Exception e)
	{
		String errMsg = e.getClass().getName() + ": " + e.getMessage();
		throw new SDKException(errMsg, SDKException.XML_PROCESSING_ERROR);
	}
}
/**
 * 
 * 
 * 
 * @param newDocumentsOnlyIndicator boolean
 */
public void setDocumentsOnlyIndicator(boolean newDocumentsOnlyIndicator) {
	documentsOnlyIndicator = newDocumentsOnlyIndicator;
}
/**
 * 
 * 
 * 
 * @param newInvoiceCurrencyCode java.lang.String
 */
public void setInvoiceCurrencyCode(java.lang.String newInvoiceCurrencyCode) {
	invoiceCurrencyCode = newInvoiceCurrencyCode;
}
/**
 * 
 * 
 * 
 * @param newInvoiceMonetaryValue java.lang.String
 */
public void setInvoiceMonetaryValue(java.lang.String newInvoiceMonetaryValue) {
	invoiceMonetaryValue = newInvoiceMonetaryValue;
}
/**
 * 
 * 
 * 
 * @param newPickupDate java.lang.String
 */
public void setPickupDate(java.lang.String newPickupDate) {
	pickupDate = newPickupDate;
}
/**
 * 
 * 
 * 
 * @param newResidentialAddressIndicator boolean
 */
public void setResidentialAddressIndicator(boolean newResidentialAddressIndicator) {
	residentialAddressIndicator = newResidentialAddressIndicator;
}
/**
 * 
 * 
 * 
 * @param newShipmentWeight java.lang.String
 */
public void setShipmentWeight(java.lang.String newShipmentWeight) {
	shipmentWeight = newShipmentWeight;
}
/**
 * 
 * 
 * 
 * @param newShipmentWeightUOMCode java.lang.String
 */
public void setShipmentWeightUOMCode(java.lang.String newShipmentWeightUOMCode) {
	shipmentWeightUOMCode = newShipmentWeightUOMCode;
}
/**
 * 
 * 
 * 
 * @param newShipmentWeightUOMDesc java.lang.String
 */
public void setShipmentWeightUOMDesc(java.lang.String newShipmentWeightUOMDesc) {
	shipmentWeightUOMDesc = newShipmentWeightUOMDesc;
}
/**
 * 
 * 
 * 
 * @param newTime java.lang.String
 */
public void setTime(java.lang.String newTime) {
	time = newTime;
}
/**
 * 
 * 
 * 
 * @param newTransitFrom com.ups.xmlsdk.xpci.AddressAbstract
 */
public void setTransitFrom(com.ups.xmlsdk.xpci.AddressAbstract newTransitFrom) {
	transitFrom = newTransitFrom;
}
/**
 * 
 * 
 * 
 * @param newTransitTo com.ups.xmlsdk.xpci.AddressAbstract
 */
public void setTransitTo(com.ups.xmlsdk.xpci.AddressAbstract newTransitTo) {
	transitTo = newTransitTo;
}
}
