package com.ups.xmlsdk.row;

/*
**  The use, disclosure, reproduction, modification, transfer, or transmittal
**    of this work for any purpose in any form or by any means without the
**     written permission of United Parcel Service is strictly prohibited.
**
**        Confidential, Unpublished Property of United Parcel Service.
**        Use and Distribution Limited Solely to Authorized Personnel.
**
**  Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
*/
import java.io.*;
import org.xml.sax.*;
import org.w3c.dom.*;
import com.ups.xmlsdk.xpci.*;
import com.ups.xmlsdk.util.*;
import com.ibm.xml.parsers.DOMParser;

/**
 * ReturnLabelUtils is a collection of utilities used in processing objects for 
 * Return on the Web.
 * <br><br>Creation date: (11/29/00 2:35:31 PM)
 * @author: James C. Bragg (jcbragg@ups.com)
 */
public class ReturnLabelUtils {

/**
 * Insert the method's description here.
 * Creation date: (12/19/00 10:48:15 AM)
 */
public ReturnLabelUtils() {
	super();	
}
/**
 * Insert the method's description here.
 * Creation date: (12/20/00 10:17:34 AM)
 * @param labelImage com.ups.xmlsdk.xpci.LabelImage
 * @return byte []
 * @exception com.ups.xmlsdk.util.SDKException The exception description.
 */
public byte [] getEltron(LabelImage labelImage) throws SDKException {
	byte [] image = null;
	
	// get Image Type
	String imageType = labelImage.getImageFormatCode();

	// check if eltron is avaliable
	if (imageType.equals("epl")) {
		image = getImage(labelImage);
	}
	
	return image;	
}
/**
 * getHTML: Purpose allows user the ability retrieve the HTML page only.
 * <br><br>Creation date: (12/14/00 10:50:48 AM)
 * @param labelImage com.ups.xmlsdk.xpci.LabelImage
 * @return byte []
 * @exception com.ups.xmlsdk.util.SDKException The exception description.
 */
private byte [] getHtml(LabelImage labelImage) throws com.ups.xmlsdk.util.SDKException {
	
	// Get encoded HTML
	String encodeHTML = labelImage.getHTMLImage();
	
	return (Base64.base64Decode(encodeHTML.getBytes()));
}
/**
 * getImage: Purpose allows user the ability retrieve the Label Image.
 * <BR><BR>Creation date: (12/7/00 1:22:05 PM)
 * @param labelImage com.ups.xmlsdk.xpci.LabelImage
 * @return byte []
 * @exception com.ups.xmlsdk.util.SDKException The exception description.
 */
private byte[] getImage(LabelImage labelImage) throws com.ups.xmlsdk.util.SDKException {

	// Get encoded image
	String encodeImage = labelImage.getGraphicImage();
	
	return (Base64.base64Decode(encodeImage.getBytes()));
}
/**
 * saveLabel: Purpose allow the user to specify a location when the image of 
 * the label will be saved.
 * <BR><BR>Creation date: (12/5/00 10:58:03 AM)
 * @param labelResults com.ups.xmlsdk.xpci.LabelResults 
 * @param directory java.lang.String
 * @exception com.ups.xmlsdk.util.SDKException The exception description.
 */
public void saveLabel(LabelResults labelResults, String directory) throws com.ups.xmlsdk.util.SDKException {

	try {

		if (labelResults == null) {
			throw new SDKException("Return Label not available, check for errors..");

		} else {
			
			FileOutputStream out = null;
			byte [] gifimage;
			byte [] html;
			
			// get Tracking Number
			String trackNum = labelResults.getTrackingNumber();

			// get LabelImage from LabelResults
			LabelImage labelImage = labelResults.getLabelImage();

			// get Image Type
			String imageType = labelImage.getImageFormatCode();

			// check if eltron is avaliable
			if (!imageType.equals("epl")) {
				html = getHtml(labelImage); 
			} else {
				html = null;
			}

			// get gif image
			gifimage = getImage(labelImage);
			if (gifimage != null) {

				// this image type is not an eltron save as gif file
				if (!imageType.equals("epl")) {
					out = new FileOutputStream(new String(directory + "label" + trackNum + ".gif"));
				} else {
					out = new FileOutputStream(new String(directory + trackNum + ".epl"));
				}

				// write data to file
				out.write(gifimage);
			}

			// check if HTML is available
			if (html != null) {

				// Create html file and write to fileserver
				out = new FileOutputStream(new String(directory + trackNum + ".html"));
				out.write(html);
			}
		}

	} catch (IOException ioe) { // Error trying to write image and/or html file to fileserver
		throw new SDKException("IO Exception: ", ioe.getMessage());
			
	} catch (SDKException sdke) {
		throw (sdke);

	} catch (Exception e) {	// General Exception
		throw new SDKException("General Exception: ", e.getMessage());
	}
}
}
