package com.ups.xmlsdk.la;

import com.ups.xmlsdk.xpci.Access;
import com.ups.xmlsdk.util.SDKException;
import com.ibm.xml.parser.LibraryException;
import org.w3c.dom.Element;
import org.w3c.dom.Document;
import com.ups.xmlsdk.*;
/**
 * The AccessRequestBean will construct an AccessRequest XML Document from the data provided
 * to the bean through it's setters.
 * @version 1.0
 */
public class AccessAdapter extends Adapter
{
/**
 * AccessRequestBean constructor.
 */
public AccessAdapter() {
	super();
}
/**
 * The buildXml method returns a StringBuffer containing and AccessRequest Document built from
 * the beans data.
 * @return java.lang.StringBuffer
 */
public StringBuffer adaptFromObject(Access acc) throws SDKException
{
	StringBuffer xmlBuf = new StringBuffer();
	Document doc = createXMLDocument(XML_AccessRequest);
	Element root = doc.getDocumentElement();
	root.setAttribute("xml:lang", "en-US");
	try
	{
		// build access info
		AdapterUtility.addNode(doc, XML_AccessRequest, XML_AccessLicenseNumber, acc.getLicenseNumber(), null, null);
		AdapterUtility.addNode(doc, XML_AccessRequest, XML_UserId, acc.getUserId(), null, null);
		AdapterUtility.addNode(doc, XML_AccessRequest, XML_Password, acc.getPassword(), null, null);


		// convert Document to StringBuffer
		xmlBuf = docToBuffer(doc);
	} catch (LibraryException le)
	{
		String errMsg = "Library Exception";
		throw new SDKException(errMsg, SDKException.UNDETERMINED);
	} catch (java.io.IOException ie)
	{
		String errMsg = "IOException";
		throw new SDKException(errMsg, SDKException.UNDETERMINED);
	} catch (Exception e)
	{
		String errMsg = "Probably caused by insufficient data-" + e.getMessage();
		throw new SDKException(errMsg, SDKException.XML_PROCESSING_ERROR);
	}
	return xmlBuf;
}
}
