package com.ups.xmlsdk.av;

import com.ibm.xml.parser.LibraryException;
import org.w3c.dom.Element;
import com.ups.xmlsdk.xpci.AddressValidationResult;
import com.ups.xmlsdk.xpci.Address;
import com.ups.xmlsdk.*;
import java.util.Vector;
import org.w3c.dom.Node;
import com.ups.xmlsdk.util.SDKException;
import org.w3c.dom.Document;
public class AddressValidationAdapter extends Adapter
{
	private java.util.Vector addressValidationResult;
	private com.ups.xmlsdk.xpci.Address address;
/**
 * AddressValidationResponse constructor comment.
 */
public AddressValidationAdapter() {
	super();
}
/**
 * 
 * 
 * 
 * @return java.lang.StringBuffer
 */
public StringBuffer buildAddressValidationXML() throws SDKException
{
	StringBuffer xmlBuf = new StringBuffer();
	Document doc = createXMLDocument(XML_AddressValidationRequest);
	Element root = doc.getDocumentElement();
	root.setAttribute("xml:lang", "en-US");
	try
	{
		// build Request node
		buildRequest(doc, XML_AddressValidationRequest);

		// build address
		Vector addressVector = new Vector();
		String addr1 = address.getAddressLine1();
		String addr2 = address.getAddressLine2();
		String addr3 = address.getAddressLine3();
		String city = address.getCity();
		String state = address.getStateProvinceCode();
		String postal = address.getPostalCode();
		String country = address.getCountryCode();
		boolean res = address.isResidentialAddress();
		addressVector = AdapterUtility.buildAddressVector(addr1, addr2, addr3, city, state, postal, country, res);
		AdapterUtility.buildNode(doc, XML_AddressValidationRequest, XML_Address, addressVector);

		// convert Document to StringBuffer
		xmlBuf = docToBuffer(doc);
	} catch (LibraryException le)
	{
		String errMsg = "Library Exception";
		throw new SDKException(errMsg, SDKException.UNDETERMINED);
	} catch (java.io.IOException ie)
	{
		String errMsg = "IOException";
		throw new SDKException(errMsg, SDKException.UNDETERMINED);
	} catch (Exception e)
	{
		String errMsg = "Probably caused by insufficient data-" + e.getMessage();
		throw new SDKException(errMsg, SDKException.XML_PROCESSING_ERROR);
	}
	return xmlBuf;
}
/**
 * 
 * 
 * 
 * @return java.util.Vector
 */
public java.util.Vector getAddressValidationResult() {
	return addressValidationResult;
}
/**
 * 
 * 
 * 
 * @param xmlIn java.lang.StringBuffer
 * @exception com.ups.xml.util.SDKException The exception description.
 */
public void parseDocument(StringBuffer xmlIn) throws SDKException
{
	try
	{
		Document doc = getDocument(xmlIn.toString());
		Node root = doc.getFirstChild();
		// get reponse
		buildResponse(root);
		// walk and retrieve the data
		Vector addResVector = new Vector();
		Node addResNode = null;
		for (addResNode = getChildNode(root, XML_AddressValidationResult); addResNode != null; addResNode = addResNode.getNextSibling())
		{
			AddressValidationResult adr = (AddressValidationResult) factory.getXPCIContainer("AddressValidationResult");
			adr.setRank(getChildNodeValue(addResNode, XML_Rank));
			adr.setQuality(getChildNodeValue(addResNode, XML_Quality));
			adr.setPostalCodeHighEnd(getChildNodeValue(addResNode, XML_PostalCodeHighEnd));
			adr.setPostalCodelowEnd(getChildNodeValue(addResNode, XML_PostalCodeLowEnd));
			// build address
			Node addNode = getChildNode(addResNode, XML_Address);
			if (addNode != null)
			{
				Address add = (Address) factory.getXPCIContainer("Address");
				add.setAddressLine1(getChildNodeValue(addNode, XML_AddressLine1));
				add.setAddressLine2(getChildNodeValue(addNode, XML_AddressLine2));
				add.setAddressLine3(getChildNodeValue(addNode, XML_AddressLine3));
				add.setCity(getChildNodeValue(addNode, XML_City));
				add.setCountryCode(getChildNodeValue(addNode, XML_CountryCode));
				add.setPostalCode(getChildNodeValue(addNode, XML_PostalCode));
				add.setStateProvinceCode(getChildNodeValue(addNode, XML_StateProvinceCode));
				Node res = getChildNode(addNode, XML_ResidentialAddressIndicator);
				if (res != null)
					add.setResidentialAddress(true);
				adr.setAddress(add);
			}
			addResVector.addElement(adr);
		}
		// set the new vector to the instance variable
		addressValidationResult = addResVector;
	} catch (Exception e)
	{
		String errMsg = e.getClass().getName() + ": " + e.getMessage();
		throw new SDKException(errMsg, SDKException.XML_PROCESSING_ERROR);
	}
}
/**
 * 
 * 
 * 
 * @param newAddress com.ups.xml.xpci.Address
 */
public void setAddress(com.ups.xmlsdk.xpci.Address newAddress) {
	address = newAddress;
}
}
