package com.ups.xmlsdk;

import com.ups.xmlsdk.xpci.*;
import com.ups.xml.xpci.AddressLabelFormat;
import com.ups.xml.xpci.Address;
import com.ups.xml.xpci.AddressRegionalFormat;
import com.ups.xml.xpci.AddressKeyFormat;
import com.ups.xml.xpci.AddressArtifactFormat;
import java.util.*;
import com.ibm.xml.parser.*;
import org.w3c.dom.*;

/* The use, disclosure, reproduction, modification, transfer, or transmittal
 * of this work for any purpose in any form or by any means without the
 * written permission of United Parcel Service is strictly prohibited.
 *
 * Confidential, Unpublished Property of United Parcel Service.
 * Use and Distribution Limited Solely to Authorized Personnel.
 *
 * Copyright 1999 United Parcel Service of America, Inc.  All Rights Reserved.
 */
public class AdapterUtility
{
// adds a new element tag with text node date, e.g. <City>Timonium</City>
// if 'str' is null, the element is added as an "empty" element
//  e.g. <City/>
public static void addNode(Document doc, String strParentTag, String newTagName, String textString, String attrName, String attrValue)
{
  	Element item = doc.createElement(newTagName); 	// this creates the new element tag
	Node parentTag = doc.getDocumentElement(); 		// default parent to root

	// we are getting a nodelist because it allows us to specify the parent element
	// by its string name; that way, we don't have to pass Elements around
	NodeList nl = doc.getDocumentElement().getElementsByTagName(strParentTag);
	parentTag = nl.item(nl.getLength()-1);

	try 
	{
		if (textString != null) 
		{
			// we support #RM, which means, 'do not add this node'
		   	if(!textString.startsWith("#RM") && !textString.startsWith("#rm"))
		   	{
				item.appendChild(doc.createTextNode(textString));
				parentTag.appendChild(item);
			}
		}
		else 
		{
			if(attrName != null && attrValue != null)
				item.setAttribute(attrName, attrValue);
			parentTag.appendChild(item);
		}
	}
	catch (Exception e) { e.printStackTrace();}
}
/**
 * 
 * Utility for constructing address Nodes for any of the Address Abstract Child classes
 * 
 * @param address com.ups.xml.xpci.AddressAbstract
 */
public static void buildAddress(Document doc, java.lang.String parent, com.ups.xmlsdk.xpci.AddressAbstract address)
{
	String child = "";
	if (address instanceof com.ups.xmlsdk.xpci.Address)
	{
		Address add = (Address) address;
		java.util.Vector addVec = buildAddressVector(add.getAddressLine1(), add.getAddressLine2(), add.getAddressLine3(), add.getCity(), add.getStateProvinceCode(), add.getPostalCode(), add.getCountryCode(), add.isResidentialAddress());
		buildNode(doc, parent, "Address", addVec);
	}
	if (address instanceof com.ups.xmlsdk.xpci.AddressKeyFormat)
	{
		child = "AddressKeyFormat";
		AddressKeyFormat akf = (AddressKeyFormat) address;
		addNode(doc, parent, child, null, null, null);
		// consignee name
		if (akf.getConsigneeName() != null)
			addNode(doc, child, "ConsigneeName", akf.getConsigneeName(), null, null);
		// bulding name
		if (akf.getBuildingName() != null)
			addNode(doc, child, "BuildingName", akf.getBuildingName(), null, null);
		// address line 1
		if (akf.getAddressLine1() != null)
			addNode(doc, child, "AddressLine1", akf.getAddressLine1(), null, null);
		// address line 2
		if (akf.getAddressLine2() != null)
			addNode(doc, child, "AddressLine2", akf.getAddressLine2(), null, null);
		// region
		if (akf.getRegion() != null)
			addNode(doc, child, "Region", akf.getRegion(), null, null);
		// urbanization
		if (akf.getUrbanization() != null)
			addNode(doc, child, "Urbanization", akf.getUrbanization(), null, null);
		// country
		if (akf.getCountry() != null)
			addNode(doc, child, "Country", akf.getCountry(), null, null);
	}
	if (address instanceof com.ups.xmlsdk.xpci.AddressLabelFormat)
	{
		child = "AddressLabelFormat";
		AddressLabelFormat alf = (AddressLabelFormat) address;
		addNode(doc, parent, child, null, null, null);
		java.util.Vector addVec = alf.getUserInput();
		if (addVec != null)
		{
			java.util.Enumeration enum = addVec.elements();
			while (enum.hasMoreElements())
			{
				String value = (java.lang.String) enum.nextElement();
				addNode(doc, child, "UserInput", value, null, null);
			}
		}
	}
	if (address instanceof com.ups.xmlsdk.xpci.AddressRegionalFormat)
	{
		child = "AddressRegionalFormat";
		AddressRegionalFormat arf = (AddressRegionalFormat) address;
		addNode(doc, parent, child, null, null, null);
		// political division 4
		if (arf.getPoliticalDivision4() != null)
			addNode(doc, child, "PoliticalDivision4", arf.getPoliticalDivision4(), null, null);
		// political division 3
		if (arf.getPoliticalDivision3() != null)
			addNode(doc, child, "PoliticalDivision3", arf.getPoliticalDivision3(), null, null);
		// political division 2
		if (arf.getPoliticalDivision2() != null)
			addNode(doc, child, "PoliticalDivision2", arf.getPoliticalDivision2(), null, null);
		// political division 1
		if (arf.getPoliticalDivision1() != null)
			addNode(doc, child, "PoliticalDivision1", arf.getPoliticalDivision1(), null, null);
		// country
		if (arf.getCountry() != null)
			addNode(doc, child, "Country", arf.getCountry(), null, null);
		// post code primary low
		if (arf.getPostCodePrimaryLow() != null)
			addNode(doc, child, "PostCodePrimaryLow", arf.getPostCodePrimaryLow(), null, null);
	}
	if (address instanceof com.ups.xmlsdk.xpci.AddressArtifactFormat)
	{
		child = "AddressArtifactFormat";
		AddressArtifactFormat aaf = (AddressArtifactFormat) address;
		addNode(doc, parent, child, null, null, null);
		// consignee name
		if (aaf.getConsigneeName() != null)
			addNode(doc, child, "ConsigneeName", aaf.getConsigneeName(), null, null);
		// Street number low
		if (aaf.getStreetNumberLow() != null)
			addNode(doc, child, "StreetNumberLow", aaf.getStreetNumberLow(), null, null);
		// street number high
		if (aaf.getStreetNumberHigh() != null)
			addNode(doc, child, "StreetNumberHigh", aaf.getStreetNumberHigh(), null, null);
		// street number odd even
		if (aaf.isStreetNumberBothIndicator() | aaf.isStreetNumberEvenIndicator() | aaf.isStreetNumberOddIndicator())
		{
			addNode(doc, child, "StreetNumberOddEven", null, null, null);
			// indicators
			if (aaf.isStreetNumberBothIndicator())
				addNode(doc, "StreetNumberOddEven", "BothIndicator", null, null, null);
			if (aaf.isStreetNumberEvenIndicator())
				addNode(doc, "StreetNumberOddEven", "EvenIndicator", null, null, null);
			if (aaf.isStreetNumberOddIndicator())
				addNode(doc, "StreetNumberOddEven", "OddIndicator", null, null, null);
		}
		// street number prefix
		if (aaf.getStreetNumberPrefix() != null)
			addNode(doc, child, "StreetNumberPrefix", aaf.getStreetNumberPrefix(), null, null);
		// street name
		if (aaf.getStreetName() != null)
			addNode(doc, child, "StreetName", aaf.getStreetName(), null, null);
		// street type
		if (aaf.getStreetType() != null)
			addNode(doc, child, "StreetType", aaf.getStreetType(), null, null);
		// street suffix
		if (aaf.getStreetSuffix() != null)
			addNode(doc, child, "StreetSufix", aaf.getStreetSuffix(), null, null);
		// building name
		if (aaf.getBuildingName() != null)
			addNode(doc, child, "BuildingName", aaf.getBuildingName(), null, null);
		// address extended information
		java.util.Vector addVec = aaf.getAddressExtendedInformation();
		if (addVec != null)
		{
			java.util.Enumeration enum = addVec.elements();
			while (enum.hasMoreElements())
			{
				addNode(doc, child, "AddressExtendedInformation", null, null, null);
				com.ups.xmlsdk.xpci.AddressExtendedInformation aei = (com.ups.xmlsdk.xpci.AddressExtendedInformation) enum.nextElement();
				addNode(doc, "AddressExtendedInformation", "High", aei.getHigh(), null, null);
				addNode(doc, "AddressExtendedInformation", "Low", aei.getLow(), null, null);
				addNode(doc, "AddressExtendedInformation", "Type", aei.getType(), null, null);
			}
		}
		// political division 4
		if (aaf.getPoliticalDivision4() != null)
			addNode(doc, child, "PoliticalDivision4", aaf.getPoliticalDivision4(), null, null);
		// political division 3
		if (aaf.getPoliticalDivision3() != null)
			addNode(doc, child, "PoliticalDivision3", aaf.getPoliticalDivision3(), null, null);
		// political division 2
		if (aaf.getPoliticalDivision2() != null)
			addNode(doc, child, "PoliticalDivision2", aaf.getPoliticalDivision2(), null, null);
		// political division 1
		if (aaf.getPoliticalDivision1() != null)
			addNode(doc, child, "PoliticalDivision1", aaf.getPoliticalDivision1(), null, null);
		// country
		if (aaf.getCountry() != null)
			addNode(doc, child, "Country", aaf.getCountry(), null, null);
		// country code
		if (aaf.getCountryCode() != null)
			addNode(doc, child, "CountryCode", aaf.getCountryCode(), null, null);
		// post code primary low
		if (aaf.getPostCodePrimaryLow() != null)
			addNode(doc, child, "PostCodePrimaryLow", aaf.getPostCodePrimaryLow(), null, null);
		// post code primary high
		if (aaf.getPostCodePrimaryHigh() != null)
			addNode(doc, child, "PostCodePrimaryHigh", aaf.getPostCodePrimaryHigh(), null, null);
		// post code extended high
		if (aaf.getPostCodeExtendedHigh() != null)
			addNode(doc, child, "PostCodeExtendedHigh", aaf.getPostCodeExtendedHigh(), null, null);
		// post code extended low
		if (aaf.getPostCodeExtendedLow() != null)
			addNode(doc, child, "PostCodeExtendedLow", aaf.getPostCodeExtendedLow(), null, null);
	}
	if (address instanceof com.ups.xmlsdk.xpci.AddressTokenFormat)
	{
		// Currently not supported
	}
}
  public static Vector buildAddressVector(String addr1, String addr2, String addr3, String city, String state, String postal, String country)
  {
	Vector addressVector = new Vector();
	if (addr1 != null)
	  addressVector.addElement(buildVector("AddressLine1", addr1));
	if (addr2 != null)
	  addressVector.addElement(buildVector("AddressLine2", addr2));
	if (addr3 != null)
	  addressVector.addElement(buildVector("AddressLine3", addr3));
	if (city != null)
	  addressVector.addElement(buildVector("City", city));
	if (state != null)
	  addressVector.addElement(buildVector("StateProvinceCode", state));
	if (postal != null)
	  addressVector.addElement(buildVector("PostalCode", postal));
	if (country != null)
	  addressVector.addElement(buildVector("CountryCode", country));
	return addressVector;
  }          
public static Vector buildAddressVector(String addr1, String addr2, String addr3, String city, String state, String postal, String country, boolean res)
{
	Vector addressVector = new Vector();
	if (addr1 != null)
		addressVector.addElement(buildVector("AddressLine1", addr1));
	if (addr2 != null)
		addressVector.addElement(buildVector("AddressLine2", addr2));
	if (addr3 != null)
		addressVector.addElement(buildVector("AddressLine3", addr3));
	if (city != null)
		addressVector.addElement(buildVector("City", city));
	if (state != null)
		addressVector.addElement(buildVector("StateProvinceCode", state));
	if (postal != null)
		addressVector.addElement(buildVector("PostalCode", postal));
	if (country != null)
		addressVector.addElement(buildVector("CountryCode", country));
	if (res)
		addressVector.addElement(buildVector("ResidentialAddress", null));
	return addressVector;
}
public static void buildComment(Document doc, String strParentTag, String comment) {
	
	Comment c = doc.createComment(comment);
	Element item = doc.getDocumentElement();
	Node parentTag = doc.getDocumentElement();

	NodeList nl = doc.getDocumentElement().getElementsByTagName(strParentTag);
	parentTag = nl.item(nl.getLength() - 1);
	try {
		if ((!comment.startsWith("#RM")) && (comment != null)) {
			parentTag.appendChild(c);
		}
	} catch (Exception e) {
		e.printStackTrace();
	}
	
}
// This method builds an part of the DOM tree and attaches it to the document using recursion
public static void buildMixedContentNode(Document doc, String strParentTag, String nodeName, String nodeData,Vector data)
{
	addNode(doc, strParentTag, nodeName, nodeData, null, null);
	
	
	Enumeration e = data.elements();
	while(e.hasMoreElements()) 
	{
		Vector v = (Vector) e.nextElement();
		if(v.elementAt(1) instanceof Vector)
			buildNode(doc, nodeName, (String) v.elementAt(0), (Vector) v.elementAt(1));
		else 
			addNode(doc, nodeName, (String) v.elementAt(0), (String) v.elementAt(1), null, null);
	}
}
// This method builds an part of the DOM tree and attaches it to the document using recursion
public static void buildNode(Document doc, String strParentTag, String nodeName, Vector data)
{
	addNode(doc, strParentTag, nodeName, null, null, null);

	Enumeration e = data.elements();
	while(e.hasMoreElements()) 
	{
		Vector v = (Vector) e.nextElement();
		if(v.elementAt(1) instanceof Vector)
			buildNode(doc, nodeName, (String) v.elementAt(0), (Vector) v.elementAt(1));
		else 
			addNode(doc, nodeName, (String) v.elementAt(0), (String) v.elementAt(1), null, null);
	}
}
public static void buildReqHdr(Document doc, String reqaction, String[] reqoption, String context, String xpciversion, String strParentTag)
{
	Vector master = new Vector();
	Vector tr = new Vector();
	tr.addElement(AdapterUtility.buildVector("CustomerContext", context));
	tr.addElement(AdapterUtility.buildVector("XpciVersion", xpciversion));
	master.addElement(AdapterUtility.buildVector("TransactionReference", tr));
	master.addElement(AdapterUtility.buildVector("RequestAction", reqaction));
	if (reqoption != null)
	{
		int i = reqoption.length;
		for (int k = 0; k < i; k++)
		{
			master.addElement(AdapterUtility.buildVector("RequestOption", reqoption[k]));
		}
	}
	buildNode(doc, strParentTag, "Request", master);
}
//Response Header - this does not include the optional error element.
public static void buildRespHdr(Document doc, String responseCode, String responseDesc, String context, String xpciversion, String strParentTag)
{
	Vector master = new Vector();
	Vector tr = new Vector();
	tr.addElement(AdapterUtility.buildVector("CustomerContext", context));
	tr.addElement(AdapterUtility.buildVector("XpciVersion", xpciversion));
	master.addElement(AdapterUtility.buildVector("TransactionReference", tr));
	master.addElement(AdapterUtility.buildVector("ResponseStatusCode", responseCode));
	master.addElement(AdapterUtility.buildVector("ResponseStatusDescription", responseDesc));
	buildNode(doc, strParentTag, "Response", master);
}
// This method takes two elements and combines them as a "name-value" pair in a vector
public static Vector buildVector(String s1, Object s2)
{
	Vector v = new Vector();
	v.addElement(s1);
	v.addElement(s2);
	return(v);
}
}
